/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.model.commands;

import com.iscobol.plugins.editor.util.intf.Factory;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractBeanToolbar;
import com.iscobol.screenpainter.beans.AbstractComboBox;
import com.iscobol.screenpainter.beans.AbstractDateEntry;
import com.iscobol.screenpainter.beans.AbstractGrid;
import com.iscobol.screenpainter.beans.AbstractJavaBean;
import com.iscobol.screenpainter.beans.AbstractListBox;
import com.iscobol.screenpainter.beans.AbstractPushButton;
import com.iscobol.screenpainter.beans.AbstractTreeView;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.ResourcesProvider;
import com.iscobol.screenpainter.beans.types.BorderStyle;
import com.iscobol.screenpainter.model.BarModel;
import com.iscobol.screenpainter.model.ComboBoxModel;
import com.iscobol.screenpainter.model.ComponentModel;
import com.iscobol.screenpainter.model.ContainerModel;
import com.iscobol.screenpainter.model.IToolbarModel;
import com.iscobol.screenpainter.model.ModelElement;
import com.iscobol.screenpainter.model.RibbonModel;
import com.iscobol.screenpainter.model.TabControlModel;
import com.iscobol.screenpainter.model.TabPageModel;
import com.iscobol.screenpainter.model.ToolbarModel;
import com.iscobol.screenpainter.model.WindowModel;
import com.iscobol.screenpainter.model.commands.TabPageCreateCommand;
import com.iscobol.screenpainter.preferences.ISPPreferenceInitializer;
import com.iscobol.screenpainter.propertysheet.pages.TabbedPropertySheetPage;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * Exception performing whole class analysis ignored.
 */
public class ComponentCreateCommand
extends Command {
    protected ComponentModel newComponent;
    protected final ContainerModel parent;
    protected Rectangle bounds;

    public ComponentCreateCommand(ComponentModel componentModel, ContainerModel containerModel, Rectangle rectangle) {
        this.newComponent = componentModel;
        this.parent = containerModel;
        this.bounds = rectangle;
        this.setLabel("Create component");
    }

    public boolean canExecute() {
        return this.newComponent != null && this.parent != null && this.bounds != null;
    }

    public void execute() {
        TabbedPropertySheetPage tabbedPropertySheetPage;
        ModelElement modelElement = (ModelElement)this.parent;
        WindowModel windowModel = modelElement.getParentWindow();
        Rectangle rectangle = this.bounds;
        Point point = rectangle.getLocation();
        Dimension dimension = rectangle.getSize();
        ScreenProgram screenProgram = windowModel.getScreenProgram();
        AbstractBeanControl abstractBeanControl = (AbstractBeanControl)this.newComponent.getTarget();
        abstractBeanControl.setPalette(screenProgram.getScreenPalette());
        abstractBeanControl.setCellSize(modelElement.getCellWidth(), modelElement.getCellHeight());
        ISPPreferenceInitializer.initialize((Object)abstractBeanControl, (String)IscobolBeanConstants.getTypeName((int)abstractBeanControl.getType()), (IPreferenceStore)IscobolScreenPainterPlugin.getDefault().getPreferenceStore(), (ScreenProgram)screenProgram);
        if (dimension.width <= 0) {
            dimension.width = (int)abstractBeanControl.getSizePixels();
        }
        if (dimension.height <= 0) {
            dimension.height = (int)abstractBeanControl.getLinesPixels();
        }
        abstractBeanControl.setConstraints(point.x, point.y, dimension.width, dimension.height);
        String string = windowModel.getDefaultName(abstractBeanControl.getType());
        abstractBeanControl.setName(string);
        int n = windowModel.getDefaultId();
        abstractBeanControl.setId(n);
        abstractBeanControl.setTabOrder(this.parent.getComponentCount() + 1, false);
        if ("true".equals(PluginUtilities.getPersistentProperty((IResource)screenProgram.getProject(), (String)"Default", (String)"iscobolsp.showonlywd2supported"))) {
            this.checkWd2Attributes(abstractBeanControl, screenProgram.getProject());
        }
        windowModel.registerControlId(n);
        windowModel.registerControlName(string);
        this.newComponent.setParent(modelElement);
        this.parent.addComponent(this.newComponent);
        this.newComponent.setCreatingComponent(true);
        this.newComponent.setLocation(this.getRealLocation(point, modelElement, dimension.height));
        if (this.newComponent instanceof BarModel) {
            ((BarModel)this.newComponent).setHorizontal(dimension.width > dimension.height);
        }
        if (abstractBeanControl.mustManageGotoEventOnToolbar() && this.parent instanceof IToolbarModel) {
            ModelElement.createEventProc((Object)abstractBeanControl, (String)string, (ScreenProgram)screenProgram);
        }
        if (this.newComponent instanceof ComboBoxModel && !((ComboBoxModel)this.newComponent).isVResizeEnabled()) {
            dimension.height = ((ComboBoxModel)this.newComponent).getComboHeight(dimension.height);
        }
        this.newComponent.setSize(dimension);
        this.newComponent.setCreatingComponent(false);
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (tabbedPropertySheetPage = PluginUtilities.getTabbedPropertySheetPage((IWorkbenchWindow)iWorkbenchWindow)) != null) {
            tabbedPropertySheetPage.setLastEditPartModel(null);
            tabbedPropertySheetPage.setLastSelectedPropertyName(null);
        }
        if (this.newComponent instanceof TabControlModel) {
            int n2;
            tabbedPropertySheetPage = (TabControlModel)this.newComponent;
            switch (tabbedPropertySheetPage.getType()) {
                case 14: {
                    n2 = 305;
                    break;
                }
                case 12: {
                    n2 = 303;
                    break;
                }
                default: {
                    n2 = 302;
                }
            }
            TabPageModel tabPageModel = new TabPageModel("Page-1", n2);
            TabPageCreateCommand tabPageCreateCommand = new TabPageCreateCommand(tabPageModel, (TabControlModel)tabbedPropertySheetPage);
            tabPageCreateCommand.execute();
        }
    }

    private void checkWd2Attributes(AbstractBeanControl abstractBeanControl, IProject iProject) {
        switch (abstractBeanControl.getType()) {
            case 108: {
                AbstractComboBox abstractComboBox = (AbstractComboBox)abstractBeanControl;
                Set set = Factory.getWd2UnsupportedAttributes((IProject)iProject, (int)8);
                if (!set.contains("3-D")) break;
                abstractComboBox.setBorder(new BorderStyle(3));
                break;
            }
            case 107: {
                AbstractListBox abstractListBox = (AbstractListBox)abstractBeanControl;
                Set set = Factory.getWd2UnsupportedAttributes((IProject)iProject, (int)7);
                if (!set.contains("3-D")) break;
                abstractListBox.setBorder(new BorderStyle(3));
                break;
            }
            case 110: {
                AbstractGrid abstractGrid = (AbstractGrid)abstractBeanControl;
                Set set = Factory.getWd2UnsupportedAttributes((IProject)iProject, (int)12);
                if (set.contains("3-D")) {
                    abstractGrid.setBorder(new BorderStyle(3));
                }
                if (!set.contains("ROW-DIVIDERS")) break;
                abstractGrid.setRowDividers(0);
                break;
            }
            case 118: {
                AbstractJavaBean abstractJavaBean = (AbstractJavaBean)abstractBeanControl;
                Set set = Factory.getWd2UnsupportedAttributes((IProject)iProject, (int)19);
                if (!set.contains("NO-BOX")) break;
                abstractJavaBean.setBorder(new BorderStyle(3));
                break;
            }
            case 115: {
                AbstractTreeView abstractTreeView = (AbstractTreeView)abstractBeanControl;
                Set set = Factory.getWd2UnsupportedAttributes((IProject)iProject, (int)14);
                if (!set.contains("NO-BOX")) break;
                abstractTreeView.setBorder(new BorderStyle(3));
                break;
            }
            case 119: {
                AbstractDateEntry abstractDateEntry = (AbstractDateEntry)abstractBeanControl;
                Set set = Factory.getWd2UnsupportedAttributes((IProject)iProject, (int)20);
                if (!set.contains("CALENDAR-FONT")) break;
                abstractDateEntry.setCalendarFont(null);
            }
        }
    }

    private Point getRealLocation(Point point, ModelElement modelElement, int n) {
        Point point2 = point.getCopy();
        for (ModelElement modelElement2 = modelElement; modelElement2 != null; modelElement2 = modelElement2.getParent()) {
            if (!(modelElement2 instanceof ToolbarModel)) continue;
            ToolbarModel toolbarModel = (ToolbarModel)modelElement2;
            if (((AbstractBeanToolbar)toolbarModel.getTarget()).isMultiline()) break;
            point2.y = (toolbarModel.getToolbarHeight() - n) / 2;
            break;
        }
        return point2;
    }

    static void redo(ComponentModel componentModel, ContainerModel containerModel) {
        ModelElement modelElement = (ModelElement)containerModel;
        componentModel.setParent(modelElement);
        containerModel.addComponent(componentModel);
        AbstractBeanControl abstractBeanControl = (AbstractBeanControl)componentModel.getTarget();
        componentModel.getParentWindow().getScreenProgram().restoreResources((ResourcesProvider)abstractBeanControl);
        componentModel.getParentWindow().registerControlIds((ResourcesProvider)abstractBeanControl);
        componentModel.getParentWindow().registerControlExceptionValues((ResourcesProvider)abstractBeanControl);
        int n = abstractBeanControl.getTabOrder();
        abstractBeanControl.setTabOrder(containerModel.getComponentCount(), false);
        abstractBeanControl.setTabOrder(n);
        if (modelElement instanceof TabPageModel && modelElement.getParent() instanceof RibbonModel && abstractBeanControl instanceof AbstractPushButton && ((AbstractPushButton)abstractBeanControl).isOnHeader()) {
            RibbonModel ribbonModel = (RibbonModel)modelElement.getParent();
            ribbonModel.addOnHeaderButton(componentModel);
        }
    }

    public void redo() {
        ComponentCreateCommand.redo((ComponentModel)this.newComponent, (ContainerModel)this.parent);
    }

    static void undo(ComponentModel componentModel, ContainerModel containerModel) {
        ModelElement modelElement = (ModelElement)containerModel;
        ResourcesProvider resourcesProvider = (ResourcesProvider)componentModel.getTarget();
        if (modelElement instanceof TabPageModel && modelElement.getParent() instanceof RibbonModel && resourcesProvider instanceof AbstractPushButton && ((AbstractPushButton)resourcesProvider).isOnHeader()) {
            RibbonModel ribbonModel = (RibbonModel)modelElement.getParent();
            ribbonModel.removeOnHeaderButton((Object)resourcesProvider);
        }
        componentModel.getParentWindow().getScreenProgram().pruneResources(resourcesProvider);
        componentModel.getParentWindow().unregisterControlIds(resourcesProvider);
        componentModel.getParentWindow().unregisterControlExceptionValues(resourcesProvider);
        containerModel.removeComponent(componentModel);
        componentModel.setParent(null);
    }

    public void undo() {
        ComponentCreateCommand.undo((ComponentModel)this.newComponent, (ContainerModel)this.parent);
    }
}

