/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.model.commands;

import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractPushButton;
import com.iscobol.screenpainter.beans.ResourcesProvider;
import com.iscobol.screenpainter.model.ComponentModel;
import com.iscobol.screenpainter.model.ContainerModel;
import com.iscobol.screenpainter.model.ModelElement;
import com.iscobol.screenpainter.model.RibbonModel;
import com.iscobol.screenpainter.model.TabPageModel;
import org.eclipse.gef.commands.Command;

public class ComponentDeleteCommand
extends Command {
    private final ComponentModel child;
    private final ContainerModel parent;
    private int removedComponentIdx;

    public ComponentDeleteCommand(ContainerModel containerModel, ComponentModel componentModel) {
        if (containerModel == null || componentModel == null) {
            throw new IllegalArgumentException();
        }
        this.parent = containerModel;
        this.child = componentModel;
        this.setLabel("Delete " + componentModel.getName());
    }

    public boolean canUndo() {
        return this.removedComponentIdx >= 0;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        ScreenProgram screenProgram;
        ResourcesProvider resourcesProvider = (ResourcesProvider)this.child.getTarget();
        ModelElement modelElement = (ModelElement)this.parent;
        if (modelElement instanceof TabPageModel && modelElement.getParent() instanceof RibbonModel && resourcesProvider instanceof AbstractPushButton && ((AbstractPushButton)resourcesProvider).isOnHeader()) {
            screenProgram = (RibbonModel)modelElement.getParent();
            screenProgram.removeOnHeaderButton((Object)resourcesProvider);
        }
        screenProgram = this.child.getParentWindow().getScreenProgram();
        boolean bl = screenProgram.getMustAskConfirmDeleteVariable();
        screenProgram.setMustAskConfirmDeleteVariable(false);
        screenProgram.pruneResources(resourcesProvider);
        screenProgram.setMustAskConfirmDeleteVariable(bl);
        this.child.getParentWindow().unregisterControlIds(resourcesProvider);
        this.child.getParentWindow().unregisterControlExceptionValues(resourcesProvider);
        this.removedComponentIdx = this.parent.removeComponent(this.child);
        this.child.setParent(null);
    }

    public void undo() {
        ModelElement modelElement = (ModelElement)this.parent;
        this.child.setParent(modelElement);
        this.parent.addComponent(this.removedComponentIdx, this.child);
        ResourcesProvider resourcesProvider = (ResourcesProvider)this.child.getTarget();
        this.child.getParentWindow().getScreenProgram().restoreResources(resourcesProvider);
        this.child.getParentWindow().registerControlIds(resourcesProvider);
        this.child.getParentWindow().registerControlExceptionValues(resourcesProvider);
        AbstractBeanControl abstractBeanControl = (AbstractBeanControl)this.child.getTarget();
        int n = abstractBeanControl.getTabOrder();
        abstractBeanControl.setTabOrder(this.parent.getComponentCount(), false);
        abstractBeanControl.setTabOrder(n);
        if (modelElement instanceof TabPageModel && modelElement.getParent() instanceof RibbonModel && abstractBeanControl instanceof AbstractPushButton && ((AbstractPushButton)abstractBeanControl).isOnHeader()) {
            RibbonModel ribbonModel = (RibbonModel)modelElement.getParent();
            ribbonModel.addOnHeaderButton(this.child);
        }
    }
}

