/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.model.commands;

import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.Menu;
import com.iscobol.screenpainter.model.ComboBoxModel;
import com.iscobol.screenpainter.model.ComponentModel;
import com.iscobol.screenpainter.model.MenuModel;
import com.iscobol.screenpainter.model.StatusbarModel;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class ComponentSetConstraintCommand
extends Command {
    private final Rectangle newBounds;
    private Rectangle oldBounds;
    private final ChangeBoundsRequest request;
    private final ComponentModel component;

    public ComponentSetConstraintCommand(ComponentModel componentModel, ChangeBoundsRequest changeBoundsRequest, Rectangle rectangle) {
        if (componentModel == null || changeBoundsRequest == null || rectangle == null) {
            throw new IllegalArgumentException();
        }
        this.component = componentModel;
        this.request = changeBoundsRequest;
        this.newBounds = rectangle.getCopy();
        this.setLabel("Change bounds " + (componentModel != null ? componentModel.getName() : ""));
    }

    private boolean isLock() {
        boolean bl = this.component instanceof StatusbarModel || this.component instanceof MenuModel ? false : ((AbstractBeanControl)this.component.getTarget()).isLock();
        return bl || this.component.isWd2Unsupported();
    }

    public boolean canExecute() {
        Object object = this.request.getType();
        return !(this.component instanceof StatusbarModel) && !this.isLock() && ("move".equals(object) || "move children".equals(object) || "resize".equals(object) || "resize children".equals(object));
    }

    public void execute() {
        this.oldBounds = new Rectangle(this.component.getLocation(), this.component.getSize());
        this.redo();
    }

    public void redo() {
        Rectangle rectangle = this.newBounds;
        Dimension dimension = rectangle.getSize();
        if (this.component instanceof ComboBoxModel && !((ComboBoxModel)this.component).isVResizeEnabled()) {
            dimension.height = ((ComboBoxModel)this.component).getComboHeight(dimension.height);
        }
        this.component.setSize(dimension);
        this.component.setLocation(rectangle.getLocation());
        if (this.component instanceof MenuModel) {
            ((Menu)this.component.getTarget()).setLocation(rectangle.x + 1, rectangle.y + 1);
        }
    }

    public void undo() {
        Dimension dimension = this.oldBounds.getSize();
        if (this.component instanceof ComboBoxModel && !((ComboBoxModel)this.component).isVResizeEnabled()) {
            dimension.height = ((ComboBoxModel)this.component).getComboHeight(dimension.height);
        }
        this.component.setSize(dimension);
        this.component.setLocation(this.oldBounds.getLocation());
        if (this.component instanceof MenuModel) {
            ((Menu)this.component.getTarget()).setLocation(this.oldBounds.x + 1, this.oldBounds.y + 1);
        }
    }
}

