/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.model.commands;

import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.model.commands.PasteData;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.Clipboard;

public class CutBeanCommand
extends Command {
    private PasteData pasteData;
    private ScreenProgram screenProgram;
    private List<Command> deleteCommands = new ArrayList();

    public CutBeanCommand() {
        this.setLabel("Cut");
    }

    public boolean canExecute() {
        return this.pasteData != null && !this.pasteData.isEmpty();
    }

    public void setPasteData(PasteData pasteData) {
        this.pasteData = pasteData;
        this.pasteData.setCopyCommand(false);
    }

    public PasteData getPasteData() {
        return this.pasteData;
    }

    public void setScreenProgram(ScreenProgram screenProgram) {
        this.screenProgram = screenProgram;
    }

    public boolean canUndo() {
        return this.canExecute() && this.pasteData.getEditableControlWrapper() == null;
    }

    public void execute() {
        if (this.canExecute()) {
            if (this.screenProgram != null) {
                this.screenProgram.setMustAskConfirmDeleteVariable(false);
            }
            Clipboard.getDefault().setContents((Object)this.pasteData);
            for (int i = 0; i < this.deleteCommands.size(); ++i) {
                Command command = (Command)this.deleteCommands.get(i);
                if (!command.canExecute()) continue;
                command.execute();
            }
            if (this.screenProgram != null) {
                this.screenProgram.setMustAskConfirmDeleteVariable(true);
            }
        }
    }

    public void undo() {
        if (this.canUndo()) {
            for (int i = this.deleteCommands.size() - 1; i >= 0; --i) {
                Command command = (Command)this.deleteCommands.get(i);
                if (!command.canUndo()) continue;
                command.undo();
            }
        }
    }

    public void addDeleteCommand(Command command) {
        this.deleteCommands.add(command);
    }
}

