/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.model.commands;

import com.iscobol.reportdesigner.ReportEditor;
import com.iscobol.reportdesigner.beans.ReportControl;
import com.iscobol.reportdesigner.beans.ReportElement;
import com.iscobol.reportdesigner.model.ReportComponentModel;
import com.iscobol.reportdesigner.model.ReportModel;
import com.iscobol.reportdesigner.model.ReportModelElement;
import com.iscobol.reportdesigner.model.ReportSectionModel;
import com.iscobol.screenpainter.ComponentFactory;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.ScreenSectionEditor;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractBeanStatusbar;
import com.iscobol.screenpainter.beans.AbstractBeanToolbar;
import com.iscobol.screenpainter.beans.AbstractRibbon;
import com.iscobol.screenpainter.beans.ExceptionTerminationValueProvider;
import com.iscobol.screenpainter.beans.Menu;
import com.iscobol.screenpainter.beans.ResourcesProvider;
import com.iscobol.screenpainter.beans.TabPage;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.beans.types.VariableUsage;
import com.iscobol.screenpainter.model.ComponentModel;
import com.iscobol.screenpainter.model.ContainerModel;
import com.iscobol.screenpainter.model.IToolbarModel;
import com.iscobol.screenpainter.model.MenuModel;
import com.iscobol.screenpainter.model.ModelElement;
import com.iscobol.screenpainter.model.RibbonModel;
import com.iscobol.screenpainter.model.ScreenSectionModel;
import com.iscobol.screenpainter.model.StatusbarModel;
import com.iscobol.screenpainter.model.TabControlModel;
import com.iscobol.screenpainter.model.TabPageModel;
import com.iscobol.screenpainter.model.ToolbarContainerModel;
import com.iscobol.screenpainter.model.ToolbarModel;
import com.iscobol.screenpainter.model.WindowModel;
import com.iscobol.screenpainter.model.commands.ComponentCreateCommand;
import com.iscobol.screenpainter.model.commands.PasteData;
import com.iscobol.screenpainter.model.commands.RibbonCreateCommand;
import com.iscobol.screenpainter.model.commands.StatusbarCreateCommand;
import com.iscobol.screenpainter.model.commands.ToolbarCreateCommand;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.propertysheet.SettingsContentPane;
import com.iscobol.screenpainter.propertysheet.VariableSettingsContentPane;
import com.iscobol.screenpainter.util.EditableControlWrapper;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.util.Set;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

public class PasteBeanCommand
extends Command {
    private ComponentModel[] components;
    private ReportComponentModel[] rptcomponents;
    private IToolbarModel[] toolbars;
    private MenuModel[] menus;
    private StatusbarModel statusbar;
    private ContainerModel containerModel;
    private ToolbarContainerModel toolbarContainer;
    private ScreenSectionModel screen;
    private ReportSectionModel sectionModel;
    private boolean canUndo;
    private PasteData pasteData;
    private TreeItem parentItem;
    private int index;
    private TreeItem[] pastedItems;
    private SettingsContentPane settingsContentPane;
    private EditableControlWrapper editableControlWrapper;
    private boolean allowDuplId = IscobolScreenPainterPlugin.getBooleanFromStore((String)"iscobol.AllowDuplicatedID");

    public PasteBeanCommand() {
        this.setLabel("Paste");
    }

    public void setTreeItem(TreeItem treeItem) {
        if (treeItem != null) {
            if (treeItem.getItemCount() > 0) {
                this.parentItem = treeItem;
                this.index = 0;
            } else {
                this.parentItem = treeItem.getParentItem();
                this.index = this.parentItem != null ? this.parentItem.indexOf(treeItem) + 1 : treeItem.getParent().indexOf(treeItem) + 1;
            }
        }
    }

    public void setSettingsContentPane(SettingsContentPane settingsContentPane) {
        this.settingsContentPane = settingsContentPane;
    }

    boolean isPasteVariablesCommand() {
        return this.settingsContentPane != null;
    }

    public void setContainerModel(ContainerModel containerModel) {
        this.containerModel = containerModel;
    }

    public void setReportSectionModel(ReportSectionModel reportSectionModel) {
        this.sectionModel = reportSectionModel;
    }

    public void setToolbarContainer(ToolbarContainerModel toolbarContainerModel) {
        this.toolbarContainer = toolbarContainerModel;
    }

    public void setScreen(ScreenSectionModel screenSectionModel) {
        this.screen = screenSectionModel;
    }

    public boolean canExecute() {
        LocalSelectionTransfer localSelectionTransfer;
        Clipboard clipboard;
        Object object;
        Object object2 = org.eclipse.gef.ui.actions.Clipboard.getDefault().getContents();
        if (this.editableControlWrapper != null) {
            return true;
        }
        if (!(object2 != null && object2 instanceof PasteData || (object = (clipboard = new Clipboard(Display.getDefault())).getContents((Transfer)(localSelectionTransfer = LocalSelectionTransfer.getTransfer()))) instanceof IStructuredSelection && (object2 = ((IStructuredSelection)object).getFirstElement()) instanceof PasteData)) {
            return false;
        }
        PasteData pasteData = (PasteData)object2;
        if (pasteData.getVariablesErrorMessage() != null) {
            return true;
        }
        if (pasteData.isEmpty()) {
            return false;
        }
        return !(this.isPasteVariablesCommand() ? pasteData.getSettingItems() == null || pasteData.getSettingItems().length == 0 : pasteData.getSettingItems() != null && pasteData.getSettingItems().length > 0);
    }

    public void execute() {
        LocalSelectionTransfer localSelectionTransfer;
        Clipboard clipboard;
        Object object;
        Object object2 = org.eclipse.gef.ui.actions.Clipboard.getDefault().getContents();
        this.pasteData = object2 == null ? ((object = (clipboard = new Clipboard(Display.getDefault())).getContents((Transfer)(localSelectionTransfer = LocalSelectionTransfer.getTransfer()))) instanceof IStructuredSelection && (object2 = ((IStructuredSelection)object).getFirstElement()) instanceof PasteData ? (PasteData)object2 : null) : (PasteData)object2;
        if (this.editableControlWrapper == null && (this.pasteData == null || this.pasteData.isEmpty() && this.pasteData.getVariablesErrorMessage() == null)) {
            return;
        }
        if (this.isPasteVariablesCommand()) {
            this.pasteVariables();
        } else if (this.editableControlWrapper != null) {
            this.canUndo = false;
        } else if (this.sectionModel != null) {
            this.pasteReportElements();
        } else {
            this.pasteScreenElements();
        }
        if (this.pasteData != null) {
            this.pasteData.incrementCounter();
        }
    }

    private void pasteVariables() {
        if (this.pasteData.getVariablesErrorMessage() != null && this.settingsContentPane instanceof VariableSettingsContentPane) {
            PluginUtilities.logError((String)this.pasteData.getVariablesErrorMessage());
        } else {
            SettingItem[] settingItemArray = this.pasteData.getSettingItems();
            this.pastedItems = new TreeItem[settingItemArray.length];
            int n = 0;
            int n2 = this.index;
            while (n < settingItemArray.length) {
                this.pastedItems[n] = this.settingsContentPane.paste(settingItemArray[n], this.parentItem, n2);
                ++n;
                ++n2;
            }
            this.canUndo = true;
        }
    }

    private void pasteReportElements() {
        ReportEditor reportEditor = null;
        ScreenProgramEditor screenProgramEditor = PluginUtilities.getCurrentScreenProgramEditor();
        if (screenProgramEditor != null && (reportEditor = screenProgramEditor.getActiveReportEditor()) != null) {
            reportEditor.beginPaste();
        }
        ReportModel reportModel = null;
        ReportComponentModel[] reportComponentModelArray = this.pasteData.getReportComponents();
        this.rptcomponents = new ReportComponentModel[reportComponentModelArray.length];
        if (reportComponentModelArray.length > 0) {
            reportModel = this.sectionModel.getReportModel();
            for (int i = 0; i < reportComponentModelArray.length; ++i) {
                this.rptcomponents[i] = this.cloneReportComponent(reportComponentModelArray[i], this.sectionModel, reportModel, this.pasteData.getCounter());
                reportModel.getScreenProgram().restoreReportResources(this.rptcomponents[i].getTarget());
                this.canUndo = true;
            }
        }
        ScreenProgram screenProgram = this.pasteData.getScreenProgram();
        if (reportModel != null && screenProgram != null) {
            ScreenProgram screenProgram2 = reportModel.getScreenProgram();
            Set set = PropertyDescriptorRegistry.getProbableParagraphList((ScreenProgram)screenProgram2);
            for (int i = 0; i < this.rptcomponents.length; ++i) {
                if (screenProgram == null) {
                    screenProgram = this.pasteData.getReportComponents()[i].getReportModel().getScreenProgram();
                }
                PropertyDescriptorRegistry.findAndCreateMissingResources((Object)this.rptcomponents[i].getTarget(), (ScreenProgram)screenProgram, (ScreenProgram)screenProgram2, (Set)set);
            }
        }
        if (reportEditor != null) {
            reportEditor.endPaste();
        }
    }

    private void pasteScreenElements() {
        ScreenSectionEditor screenSectionEditor = null;
        ScreenProgramEditor screenProgramEditor = PluginUtilities.getCurrentScreenProgramEditor();
        if (screenProgramEditor != null && (screenSectionEditor = screenProgramEditor.getActiveScreenEditor()) != null) {
            screenSectionEditor.beginPaste();
        }
        WindowModel windowModel = null;
        ComponentModel[] componentModelArray = this.pasteData.getComponents();
        this.components = new ComponentModel[componentModelArray.length];
        if (componentModelArray.length > 0) {
            int n;
            for (n = 0; n < componentModelArray.length; ++n) {
                if (this.containerModel != componentModelArray[n]) continue;
                this.containerModel = (ContainerModel)componentModelArray[n].getParent();
            }
            windowModel = this.containerModel.getParentWindow();
            for (n = 0; n < componentModelArray.length; ++n) {
                this.components[n] = this.cloneComponent(componentModelArray[n], this.containerModel, windowModel, this.pasteData.getCounter());
                windowModel.getScreenProgram().restoreResources((ResourcesProvider)this.components[n].getTarget());
                this.canUndo = true;
            }
        }
        IToolbarModel[] iToolbarModelArray = this.pasteData.getToolbars();
        this.toolbars = new IToolbarModel[iToolbarModelArray.length];
        if (iToolbarModelArray.length > 0) {
            windowModel = this.toolbarContainer.getParentWindow();
            for (int i = 0; i < iToolbarModelArray.length; ++i) {
                this.toolbars[i] = iToolbarModelArray[i] instanceof ToolbarModel ? this.cloneToolbar((ToolbarModel)iToolbarModelArray[i], windowModel) : this.cloneRibbon((RibbonModel)iToolbarModelArray[i], windowModel);
                windowModel.getScreenProgram().restoreResources((ResourcesProvider)this.toolbars[i].getTarget());
            }
            this.canUndo = true;
        }
        MenuModel[] menuModelArray = this.pasteData.getMenus();
        this.menus = new MenuModel[menuModelArray.length];
        if (this.menus.length > 0) {
            windowModel = this.screen.getParentWindow();
            for (int i = 0; i < menuModelArray.length; ++i) {
                this.menus[i] = this.cloneMenu(menuModelArray[i], windowModel);
                windowModel.getScreenProgram().restoreResources((ResourcesProvider)this.menus[i].getTarget());
            }
            this.canUndo = true;
        }
        if (this.pasteData.getStatusbar() != null) {
            if (this.screen.getStatusBar() == null) {
                windowModel = this.screen.getParentWindow();
                this.statusbar = this.cloneStatusbar(this.pasteData.getStatusbar(), windowModel);
                windowModel.getScreenProgram().restoreResources((ResourcesProvider)this.statusbar.getTarget());
            }
            this.canUndo = true;
        }
        ScreenProgram screenProgram = this.pasteData.getScreenProgram();
        if (windowModel != null && screenProgram != null) {
            int n;
            ScreenProgram screenProgram2 = windowModel.getScreenProgram();
            Set set = PropertyDescriptorRegistry.getProbableParagraphList((ScreenProgram)screenProgram2);
            for (n = 0; n < this.components.length; ++n) {
                PropertyDescriptorRegistry.findAndCreateMissingResources((Object)this.components[n].getTarget(), (ScreenProgram)screenProgram, (ScreenProgram)screenProgram2, (Set)set);
            }
            for (n = 0; n < this.toolbars.length; ++n) {
                PropertyDescriptorRegistry.findAndCreateMissingResources((Object)this.toolbars[n].getTarget(), (ScreenProgram)screenProgram, (ScreenProgram)screenProgram2, (Set)set);
            }
            for (n = 0; n < this.menus.length; ++n) {
                PropertyDescriptorRegistry.findAndCreateMissingResources((Object)this.menus[n].getTarget(), (ScreenProgram)screenProgram, (ScreenProgram)screenProgram2, (Set)set);
            }
            if (this.statusbar != null) {
                PropertyDescriptorRegistry.findAndCreateMissingResources((Object)this.statusbar.getTarget(), (ScreenProgram)screenProgram, (ScreenProgram)screenProgram2, (Set)set);
            }
        }
        if (screenSectionEditor != null) {
            screenSectionEditor.endPaste();
        }
    }

    public void redo() {
        if (this.isPasteVariablesCommand()) {
            this.pasteVariables();
        } else {
            int n;
            if (this.components.length > 0) {
                for (n = 0; n < this.components.length; ++n) {
                    ComponentCreateCommand.redo((ComponentModel)this.components[n], (ContainerModel)this.containerModel);
                }
            }
            if (this.toolbars.length > 0) {
                for (n = 0; n < this.toolbars.length; ++n) {
                    if (this.toolbars[n] instanceof ToolbarModel) {
                        ToolbarCreateCommand.redo((ToolbarModel)((ToolbarModel)this.toolbars[n]), (ToolbarContainerModel)this.toolbarContainer);
                        continue;
                    }
                    RibbonCreateCommand.redo((RibbonModel)((RibbonModel)this.toolbars[n]), (ToolbarContainerModel)this.toolbarContainer);
                }
            }
            if (this.menus.length > 0) {
                for (n = 0; n < this.menus.length; ++n) {
                    ComponentCreateCommand.redo((ComponentModel)this.menus[n], (ContainerModel)this.screen);
                }
            }
            if (this.statusbar != null && this.screen.getStatusBar() == null) {
                StatusbarCreateCommand.redo((StatusbarModel)this.statusbar, (ScreenSectionModel)this.screen);
            }
        }
        this.pasteData.incrementCounter();
    }

    public boolean canUndo() {
        return this.canUndo;
    }

    public void undo() {
        if (this.pastedItems != null) {
            for (int i = 0; i < this.pastedItems.length; ++i) {
                this.settingsContentPane.cut(this.pastedItems[i], null);
            }
        } else {
            int n;
            if (this.components.length > 0) {
                for (n = 0; n < this.components.length; ++n) {
                    ComponentCreateCommand.undo((ComponentModel)this.components[n], (ContainerModel)this.containerModel);
                }
            }
            if (this.toolbars.length > 0) {
                for (n = 0; n < this.toolbars.length; ++n) {
                    if (this.toolbars[n] instanceof ToolbarModel) {
                        ToolbarCreateCommand.undo((ToolbarModel)((ToolbarModel)this.toolbars[n]), (ToolbarContainerModel)this.toolbarContainer);
                        continue;
                    }
                    RibbonCreateCommand.undo((RibbonModel)((RibbonModel)this.toolbars[n]), (ToolbarContainerModel)this.toolbarContainer);
                }
            }
            if (this.menus.length > 0) {
                for (n = 0; n < this.menus.length; ++n) {
                    ComponentCreateCommand.undo((ComponentModel)this.menus[n], (ContainerModel)this.screen);
                }
            }
            if (this.statusbar != null && this.screen.getStatusBar() == this.statusbar) {
                StatusbarCreateCommand.undo((StatusbarModel)this.statusbar, (ScreenSectionModel)this.screen);
            }
        }
        this.pasteData.decrementCounter();
    }

    public EditableControlWrapper getEditableControlWrapper() {
        return this.editableControlWrapper;
    }

    public void setEditableControlWrapper(EditableControlWrapper editableControlWrapper) {
        this.editableControlWrapper = editableControlWrapper;
    }

    private ComponentModel cloneComponent(ComponentModel componentModel, ContainerModel containerModel, WindowModel windowModel, int n) {
        ComponentModel componentModel2;
        block12: {
            block11: {
                int n2;
                Point point = componentModel.getLocation();
                Dimension dimension = componentModel.getSize();
                AbstractBeanControl abstractBeanControl = (AbstractBeanControl)componentModel.getTarget();
                AbstractBeanControl abstractBeanControl2 = (AbstractBeanControl)PropertyDescriptorRegistry.cloneBean((Object)abstractBeanControl);
                componentModel2 = ComponentFactory.getNewObject((AbstractBeanControl)abstractBeanControl2);
                int n3 = abstractBeanControl.getId();
                if (!this.allowDuplId && windowModel.controlIdAlreadyExists(n3)) {
                    n3 = windowModel.getDefaultId();
                }
                abstractBeanControl2.setId(n3);
                String string = abstractBeanControl.getName();
                if (windowModel.getScreenProgram().controlNameAlreadyExists(string)) {
                    string = windowModel.getDefaultName(abstractBeanControl.getType());
                }
                abstractBeanControl2.setName(string);
                abstractBeanControl2.setLevel(0);
                abstractBeanControl2.setTabOrder(containerModel.getComponentCount() + 1, false);
                if (abstractBeanControl2 instanceof ExceptionTerminationValueProvider && (n2 = ((ExceptionTerminationValueProvider)abstractBeanControl2).getExceptionValue()) > 0) {
                    windowModel.registerControlExceptionValue(n2);
                }
                windowModel.registerControlId(n3);
                windowModel.registerControlName(string);
                containerModel.addComponent(-1, componentModel2, true);
                componentModel2.setParent((ModelElement)containerModel);
                if (componentModel.getParent() == containerModel) {
                    point.x += n * 10;
                    point.y += n * 10;
                } else {
                    int n4;
                    Dimension dimension2 = new Dimension(containerModel.getWidth(), containerModel.getHeight());
                    if (dimension.width > dimension2.width) {
                        dimension.width = dimension2.width;
                    }
                    if (dimension.height > dimension2.height) {
                        dimension.height = dimension2.height;
                    }
                    if ((n4 = point.x + dimension.width - dimension2.width) > 0) {
                        point.x -= n4;
                    }
                    if ((n4 = point.y + dimension.height - dimension2.height) > 0) {
                        point.y -= n4;
                    }
                }
                componentModel2.setLocation(point);
                componentModel2.setSize(dimension, true);
                if (!(componentModel instanceof TabControlModel)) break block11;
                TabControlModel tabControlModel = (TabControlModel)componentModel;
                TabControlModel tabControlModel2 = (TabControlModel)componentModel2;
                TabPageModel[] tabPageModelArray = new TabPageModel[tabControlModel.getPageCount()];
                tabControlModel.getPages(tabPageModelArray);
                for (int i = 0; i < tabPageModelArray.length; ++i) {
                    this.cloneTabPage(tabPageModelArray[i], tabControlModel2, windowModel);
                }
                break block12;
            }
            if (!(componentModel instanceof ContainerModel)) break block12;
            ContainerModel containerModel2 = (ContainerModel)componentModel;
            ContainerModel containerModel3 = (ContainerModel)componentModel2;
            ComponentModel[] componentModelArray = new ComponentModel[containerModel2.getComponentCount()];
            containerModel2.getComponents(componentModelArray);
            for (int i = 0; i < componentModelArray.length; ++i) {
                this.cloneComponent(componentModelArray[i], containerModel3, windowModel, 0);
            }
        }
        return componentModel2;
    }

    private ReportComponentModel cloneReportComponent(ReportComponentModel reportComponentModel, ReportSectionModel reportSectionModel, ReportModel reportModel, int n) {
        ScreenProgram screenProgram = reportModel.getScreenProgram();
        Point point = reportComponentModel.getLocation();
        Dimension dimension = reportComponentModel.getSize();
        ReportControl reportControl = (ReportControl)reportComponentModel.getTarget();
        ReportControl reportControl2 = (ReportControl)PropertyDescriptorRegistry.cloneBean((Object)reportControl);
        ReportComponentModel reportComponentModel2 = new ReportComponentModel((ReportElement)reportControl2);
        String string = reportControl.getName();
        if (screenProgram.reportControlNameAlreadyExists(string)) {
            string = screenProgram.getDefaultReportElementName(reportModel.getName(), reportControl2.getType());
        }
        reportControl2.setName(string);
        screenProgram.registerReportControlName(string);
        reportSectionModel.addComponent(-1, reportComponentModel2, true);
        reportComponentModel2.setParent((ReportModelElement)reportSectionModel);
        if (reportComponentModel.getParent() == reportSectionModel) {
            point.x += n * 10;
            point.y += n * 10;
        } else {
            int n2;
            Dimension dimension2 = new Dimension(reportSectionModel.getWidth(), reportSectionModel.getHeight());
            if (dimension.width > dimension2.width) {
                dimension.width = dimension2.width;
            }
            if (dimension.height > dimension2.height) {
                dimension.height = dimension2.height;
            }
            if ((n2 = point.x + dimension.width - dimension2.width) > 0) {
                point.x -= n2;
            }
            if ((n2 = point.y + dimension.height - dimension2.height) > 0) {
                point.y -= n2;
            }
        }
        reportComponentModel2.setLocation(point.x, point.y);
        reportComponentModel2.setSize(dimension.width, dimension.height);
        return reportComponentModel2;
    }

    private ToolbarModel cloneToolbar(ToolbarModel toolbarModel, WindowModel windowModel) {
        AbstractBeanToolbar abstractBeanToolbar = (AbstractBeanToolbar)toolbarModel.getTarget();
        AbstractBeanToolbar abstractBeanToolbar2 = (AbstractBeanToolbar)PropertyDescriptorRegistry.cloneBean((Object)abstractBeanToolbar);
        ToolbarModel toolbarModel2 = new ToolbarModel(abstractBeanToolbar2, this.toolbarContainer);
        String string = abstractBeanToolbar.getName();
        if (windowModel.getScreenProgram().controlNameAlreadyExists(string)) {
            string = windowModel.getDefaultName(abstractBeanToolbar.getType());
        }
        abstractBeanToolbar2.setName(string);
        abstractBeanToolbar2.setTabOrder(this.toolbarContainer.getToolbarCount() + 1, false);
        windowModel.registerControlName(string);
        this.toolbarContainer.addToolbar(-1, (IToolbarModel)toolbarModel2, true);
        toolbarModel2.setParent((ModelElement)this.toolbarContainer);
        VariableType variableType = windowModel.getScreenProgram().createHandleVariable("toolbar-handle", 25);
        abstractBeanToolbar2.setToolbarHandle(variableType.getName());
        windowModel.getScreenProgram().getResourceRegistry().registerVariable(variableType, (Object)abstractBeanToolbar2, "toolbar-handle");
        toolbarModel2.setToolbarHeight(toolbarModel.getToolbarHeight());
        ComponentModel[] componentModelArray = new ComponentModel[toolbarModel.getComponentCount()];
        toolbarModel.getComponents(componentModelArray);
        for (int i = 0; i < componentModelArray.length; ++i) {
            this.cloneComponent(componentModelArray[i], (ContainerModel)toolbarModel2, windowModel, 0);
        }
        return toolbarModel2;
    }

    private RibbonModel cloneRibbon(RibbonModel ribbonModel, WindowModel windowModel) {
        AbstractRibbon abstractRibbon = (AbstractRibbon)ribbonModel.getTarget();
        AbstractRibbon abstractRibbon2 = (AbstractRibbon)PropertyDescriptorRegistry.cloneBean((Object)abstractRibbon);
        RibbonModel ribbonModel2 = new RibbonModel(abstractRibbon2, this.toolbarContainer);
        String string = abstractRibbon.getName();
        if (windowModel.getScreenProgram().controlNameAlreadyExists(string)) {
            string = windowModel.getDefaultName(abstractRibbon.getType());
        }
        abstractRibbon2.setName(string);
        abstractRibbon2.setTabOrder(this.toolbarContainer.getToolbarCount() + 1, false);
        windowModel.registerControlName(string);
        this.toolbarContainer.addToolbar(-1, (IToolbarModel)ribbonModel2, true);
        ribbonModel2.setParent((ModelElement)this.toolbarContainer);
        VariableType variableType = windowModel.getScreenProgram().createHandleVariable("ribbon-handle", 61);
        abstractRibbon2.setRibbonHandle(variableType.getName());
        windowModel.getScreenProgram().getResourceRegistry().registerVariable(variableType, (Object)abstractRibbon2, "ribbon-handle");
        ribbonModel2.setToolbarHeight(ribbonModel.getToolbarHeight());
        TabPageModel[] tabPageModelArray = new TabPageModel[ribbonModel.getPageCount()];
        ribbonModel.getPages(tabPageModelArray);
        for (int i = 0; i < tabPageModelArray.length; ++i) {
            this.cloneTabPage(tabPageModelArray[i], (TabControlModel)ribbonModel2, windowModel);
        }
        return ribbonModel2;
    }

    private MenuModel cloneMenu(MenuModel menuModel, WindowModel windowModel) {
        Point point = menuModel.getLocation();
        Dimension dimension = menuModel.getSize();
        Menu menu = (Menu)menuModel.getTarget();
        Menu menu2 = (Menu)PropertyDescriptorRegistry.cloneBean((Object)menu);
        MenuModel menuModel2 = new MenuModel(menu2);
        String string = menu.getName();
        if (windowModel.getScreenProgram().controlNameAlreadyExists(string)) {
            string = windowModel.getDefaultName(301);
        }
        menu2.setName(string);
        windowModel.registerControlName(string);
        this.screen.addComponent(-1, (ComponentModel)menuModel2, true);
        menuModel2.setParent((ModelElement)this.screen);
        if (menuModel.getParent() == this.screen) {
            point.x += 10;
            point.y += 10;
        }
        VariableType variableType = windowModel.getScreenProgram().createHandleVariable("hmenu", 27);
        menu2.setMenuHandle(variableType.getName());
        windowModel.getScreenProgram().getResourceRegistry().registerVariable(variableType, (Object)menu2, "menu-handle");
        windowModel.registerControlExceptionValues((ResourcesProvider)menu2);
        menuModel2.setLocation(point);
        menuModel2.setSize(dimension);
        return menuModel2;
    }

    private StatusbarModel cloneStatusbar(StatusbarModel statusbarModel, WindowModel windowModel) {
        Dimension dimension = new Dimension(windowModel.getScreenSize().width, statusbarModel.getStatusBarHeight());
        Point point = new Point(0, windowModel.getScreenSize().height - statusbarModel.getStatusBarHeight());
        AbstractBeanStatusbar abstractBeanStatusbar = (AbstractBeanStatusbar)statusbarModel.getTarget();
        AbstractBeanStatusbar abstractBeanStatusbar2 = (AbstractBeanStatusbar)PropertyDescriptorRegistry.cloneBean((Object)abstractBeanStatusbar);
        StatusbarModel statusbarModel2 = new StatusbarModel(abstractBeanStatusbar2, this.screen);
        String string = abstractBeanStatusbar.getName();
        if (windowModel.getScreenProgram().controlNameAlreadyExists(string)) {
            string = windowModel.getDefaultName(abstractBeanStatusbar2.getType());
        }
        abstractBeanStatusbar2.setName(string);
        int n = abstractBeanStatusbar.getId();
        if (!this.allowDuplId && windowModel.controlIdAlreadyExists(n)) {
            n = windowModel.getDefaultId();
        }
        abstractBeanStatusbar2.setId(n);
        windowModel.registerControlName(string);
        this.screen.setStatusBar(statusbarModel2, true);
        statusbarModel2.setParent((ModelElement)this.screen);
        VariableType variableType = windowModel.getScreenProgram().createHandleVariable("statusbar-handle", 28);
        variableType.setUsage(new VariableUsage(28));
        abstractBeanStatusbar2.setHandle(variableType.getName());
        windowModel.getScreenProgram().getResourceRegistry().registerVariable(variableType, (Object)abstractBeanStatusbar2, "status bar handle");
        statusbarModel2.intSetLocation(point);
        statusbarModel2.intSetSize(dimension);
        return statusbarModel2;
    }

    private TabPageModel cloneTabPage(TabPageModel tabPageModel, TabControlModel tabControlModel, WindowModel windowModel) {
        TabPage tabPage = (TabPage)tabPageModel.getTarget();
        TabPage tabPage2 = (TabPage)PropertyDescriptorRegistry.cloneBean((Object)tabPage);
        TabPageModel tabPageModel2 = new TabPageModel(tabPage2);
        String string = tabPage.getName();
        if (windowModel.getScreenProgram().controlNameAlreadyExists(string)) {
            string = windowModel.getDefaultName(tabPage.getType());
        }
        tabPage2.setName(string);
        tabPage2.setTabOrder(tabControlModel.getPageCount() + 1, false);
        windowModel.registerControlName(string);
        tabControlModel.addPage(-1, tabPageModel2, true);
        tabPageModel2.setParent((ModelElement)tabControlModel);
        VariableType variableType = windowModel.getScreenProgram().createVariable(string + "-vis", 1004);
        tabPage2.setVisibleVariable(variableType.getName());
        windowModel.getScreenProgram().getResourceRegistry().registerVariable(variableType, (Object)tabPage2, "visible variable");
        ComponentModel[] componentModelArray = new ComponentModel[tabPageModel.getComponentCount()];
        tabPageModel.getComponents(componentModelArray);
        for (int i = 0; i < componentModelArray.length; ++i) {
            this.cloneComponent(componentModelArray[i], (ContainerModel)tabPageModel2, windowModel, 0);
        }
        return tabPageModel2;
    }
}

