/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.model.commands;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.ResourcesProvider;
import com.iscobol.screenpainter.beans.TabPage;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.model.ModelElement;
import com.iscobol.screenpainter.model.TabControlModel;
import com.iscobol.screenpainter.model.TabPageModel;
import com.iscobol.screenpainter.model.WindowModel;
import com.iscobol.screenpainter.preferences.ISPPreferenceInitializer;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.preference.IPreferenceStore;

public class TabPageCreateCommand
extends Command {
    private TabPageModel newPage;
    private final TabControlModel parent;

    public TabPageCreateCommand(TabPageModel tabPageModel, TabControlModel tabControlModel) {
        this.newPage = tabPageModel;
        this.parent = tabControlModel;
        this.setLabel("Create page");
    }

    public boolean canExecute() {
        return this.newPage != null && this.parent != null;
    }

    public void execute() {
        TabPage tabPage = (TabPage)this.newPage.getTarget();
        WindowModel windowModel = this.parent.getParentWindow();
        String string = windowModel.getDefaultName(tabPage.getType());
        tabPage.setName(string);
        tabPage.setTabOrder(this.parent.getPageCount() + 1, false);
        windowModel.registerControlName(string);
        ScreenProgram screenProgram = windowModel.getScreenProgram();
        tabPage.setPalette(screenProgram.getScreenPalette());
        ISPPreferenceInitializer.initialize((Object)tabPage, (String)IscobolBeanConstants.getTypeName((int)tabPage.getType()), (IPreferenceStore)IscobolScreenPainterPlugin.getDefault().getPreferenceStore(), (ScreenProgram)screenProgram);
        if (this.parent.getType() == 109) {
            VariableType variableType = screenProgram.createVariable(string + "-vis", 1004);
            tabPage.setVisibleVariable(variableType.getName());
            screenProgram.getResourceRegistry().registerVariable(variableType, (Object)tabPage, "visible variable");
        }
        this.parent.addPage(this.newPage);
        this.newPage.setParent((ModelElement)this.parent);
    }

    public void redo() {
        this.parent.addPage(this.newPage);
        this.newPage.setParent((ModelElement)this.parent);
        TabPage tabPage = (TabPage)this.newPage.getTarget();
        this.newPage.getParentWindow().getScreenProgram().restoreResources((ResourcesProvider)tabPage);
        this.newPage.getParentWindow().registerControlIds((ResourcesProvider)tabPage);
        this.newPage.getParentWindow().registerControlExceptionValues((ResourcesProvider)tabPage);
    }

    public void undo() {
        TabPage tabPage = (TabPage)this.newPage.getTarget();
        this.newPage.getParentWindow().getScreenProgram().pruneResources((ResourcesProvider)tabPage);
        this.newPage.getParentWindow().unregisterControlIds((ResourcesProvider)tabPage);
        this.newPage.getParentWindow().unregisterControlExceptionValues((ResourcesProvider)tabPage);
        this.parent.removePage(this.newPage);
        this.newPage.setParent(null);
    }
}

