/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.model.commands;

import com.iscobol.screenpainter.beans.ResourcesProvider;
import com.iscobol.screenpainter.beans.TabPage;
import com.iscobol.screenpainter.model.ModelElement;
import com.iscobol.screenpainter.model.TabControlModel;
import com.iscobol.screenpainter.model.TabPageModel;
import org.eclipse.gef.commands.Command;

public class TabPageDeleteCommand
extends Command {
    private final TabPageModel child;
    private final TabControlModel parent;
    private int removedPageIdx;

    public TabPageDeleteCommand(TabControlModel tabControlModel, TabPageModel tabPageModel) {
        if (tabControlModel == null || tabPageModel == null) {
            throw new IllegalArgumentException();
        }
        this.parent = tabControlModel;
        this.child = tabPageModel;
        this.setLabel("Delete " + tabPageModel.getName());
    }

    public boolean canUndo() {
        return this.removedPageIdx >= 0;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        TabPage tabPage = (TabPage)this.child.getTarget();
        this.child.getParentWindow().getScreenProgram().pruneResources((ResourcesProvider)tabPage);
        this.child.getParentWindow().unregisterControlIds((ResourcesProvider)tabPage);
        this.child.getParentWindow().unregisterControlExceptionValues((ResourcesProvider)tabPage);
        this.removedPageIdx = this.parent.removePage(this.child);
        this.child.setParent(null);
    }

    public void undo() {
        this.parent.addPage(this.removedPageIdx, this.child);
        this.child.setParent((ModelElement)this.parent);
        TabPage tabPage = (TabPage)this.child.getTarget();
        this.child.getParentWindow().getScreenProgram().restoreResources((ResourcesProvider)tabPage);
        this.child.getParentWindow().registerControlIds((ResourcesProvider)tabPage);
        this.child.getParentWindow().registerControlExceptionValues((ResourcesProvider)tabPage);
    }
}

