/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.model.commands;

import com.iscobol.screenpainter.beans.IToolbar;
import com.iscobol.screenpainter.beans.ResourcesProvider;
import com.iscobol.screenpainter.model.IToolbarModel;
import com.iscobol.screenpainter.model.ModelElement;
import com.iscobol.screenpainter.model.ToolbarContainerModel;
import org.eclipse.gef.commands.Command;

public class ToolbarDeleteCommand
extends Command {
    private final IToolbarModel child;
    private final ToolbarContainerModel parent;
    private int removedToolbarIdx;

    public ToolbarDeleteCommand(ToolbarContainerModel toolbarContainerModel, IToolbarModel iToolbarModel) {
        if (toolbarContainerModel == null || iToolbarModel == null) {
            throw new IllegalArgumentException();
        }
        this.parent = toolbarContainerModel;
        this.child = iToolbarModel;
        this.setLabel("Delete " + iToolbarModel.getName());
    }

    public boolean canUndo() {
        return this.removedToolbarIdx >= 0;
    }

    public void execute() {
        this.redo();
    }

    public void redo() {
        IToolbar iToolbar = (IToolbar)this.child.getTarget();
        this.child.getParentWindow().getScreenProgram().pruneResources((ResourcesProvider)iToolbar);
        this.child.getParentWindow().unregisterControlIds((ResourcesProvider)iToolbar);
        this.child.getParentWindow().unregisterControlExceptionValues((ResourcesProvider)iToolbar);
        this.removedToolbarIdx = this.parent.removeToolbar(this.child);
        this.child.setParent(null);
    }

    public void undo() {
        this.parent.addToolbar(this.removedToolbarIdx, this.child);
        this.child.setParent((ModelElement)this.parent);
        IToolbar iToolbar = (IToolbar)this.child.getTarget();
        this.child.getParentWindow().getScreenProgram().restoreResources((ResourcesProvider)iToolbar);
        this.child.getParentWindow().registerControlIds((ResourcesProvider)iToolbar);
        this.child.getParentWindow().registerControlExceptionValues((ResourcesProvider)iToolbar);
        int n = iToolbar.getTabOrder();
        iToolbar.setTabOrder(this.parent.getToolbarCount() + 1, false);
        iToolbar.setTabOrder(n);
    }
}

