/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.model.commands;

import com.iscobol.screenpainter.beans.AbstractBeanToolbar;
import com.iscobol.screenpainter.beans.IToolbar;
import com.iscobol.screenpainter.model.IToolbarModel;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class ToolbarSetConstraintCommand
extends Command {
    private final int newHeight;
    private int oldHeight;
    private final ChangeBoundsRequest request;
    private final IToolbarModel toolbar;

    public ToolbarSetConstraintCommand(IToolbarModel iToolbarModel, ChangeBoundsRequest changeBoundsRequest, int n) {
        if (iToolbarModel == null || changeBoundsRequest == null || n <= 0) {
            throw new IllegalArgumentException();
        }
        this.toolbar = iToolbarModel;
        this.request = changeBoundsRequest;
        this.newHeight = n;
        this.setLabel("Resize " + (iToolbarModel != null ? iToolbarModel.getName() : ""));
    }

    private boolean isLock() {
        return ((IToolbar)this.toolbar.getTarget()).isLock();
    }

    public boolean canExecute() {
        Object object = this.request.getType();
        return !this.isLock() && ("resize".equals(object) || "resize children".equals(object));
    }

    public void execute() {
        this.oldHeight = this.toolbar.getSize().height;
        this.redo();
    }

    public void redo() {
        this.setLinesPixels(this.newHeight);
    }

    public void undo() {
        this.setLinesPixels(this.oldHeight);
    }

    private void setLinesPixels(int n) {
        this.toolbar.setSize(new Dimension(this.toolbar.getSize().width, n));
        if (this.toolbar.getTarget() instanceof AbstractBeanToolbar) {
            ((AbstractBeanToolbar)this.toolbar.getTarget()).setLinesPixels(n);
        }
    }
}

