/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.model.commands;

import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.model.WindowModel;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class WindowSetConstraintCommand
extends Command {
    private final Rectangle newBounds;
    private Rectangle oldBounds;
    private final ChangeBoundsRequest request;
    private final WindowModel screen;

    public WindowSetConstraintCommand(WindowModel windowModel, ChangeBoundsRequest changeBoundsRequest, Rectangle rectangle) {
        if (windowModel == null || changeBoundsRequest == null || rectangle == null) {
            throw new IllegalArgumentException();
        }
        this.screen = windowModel;
        this.request = changeBoundsRequest;
        this.newBounds = rectangle.getCopy();
        this.setLabel("Resize " + (windowModel != null ? windowModel.getName() : ""));
    }

    private boolean isLock() {
        return ((AbstractBeanWindow)this.screen.getTarget()).isLock();
    }

    public boolean canExecute() {
        Object object = this.request.getType();
        return !this.isLock() && ("move".equals(object) || "move children".equals(object) || "resize".equals(object) || "resize children".equals(object));
    }

    public void execute() {
        this.oldBounds = new Rectangle(this.screen.getLocation(), this.screen.getSize());
        this.redo();
    }

    public void redo() {
        this.screen.setSize(this.newBounds.getSize());
    }

    public void undo() {
        this.screen.setSize(this.oldBounds.getSize());
    }
}

