/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.parts;

import com.iscobol.plugins.editor.util.BeanSnapshoter;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractBitmap;
import com.iscobol.screenpainter.beans.AbstractButton;
import com.iscobol.screenpainter.beans.AbstractCheckBox;
import com.iscobol.screenpainter.beans.AbstractPushButton;
import com.iscobol.screenpainter.beans.AbstractRadioButton;
import com.iscobol.screenpainter.beans.AbstractRibbon;
import com.iscobol.screenpainter.beans.AbstractTreeView;
import com.iscobol.screenpainter.beans.Menu;
import com.iscobol.screenpainter.beans.TabOrderable;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.ImageType;
import com.iscobol.screenpainter.beans.types.MenuItemSettingList;
import com.iscobol.screenpainter.beans.types.SettingItemList;
import com.iscobol.screenpainter.beans.types.TreeViewItemSettingList;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.dialogs.MenuSettingsDialog;
import com.iscobol.screenpainter.dialogs.SettingsDialog;
import com.iscobol.screenpainter.dialogs.TreeViewSettingsDialog;
import com.iscobol.screenpainter.model.ComponentModel;
import com.iscobol.screenpainter.model.MenuModel;
import com.iscobol.screenpainter.model.RibbonModel;
import com.iscobol.screenpainter.model.ScreenPainterModel;
import com.iscobol.screenpainter.model.ScreenPainterModelWithTitle;
import com.iscobol.screenpainter.model.WindowModel;
import com.iscobol.screenpainter.parts.ChangeTitleCellEditorLocator;
import com.iscobol.screenpainter.parts.ChangeTitleDirectEditManager;
import com.iscobol.screenpainter.parts.DirectEditable;
import com.iscobol.screenpainter.parts.IscobolScreenPainterEditPart;
import com.iscobol.screenpainter.parts.RibbonEditPart;
import com.iscobol.screenpainter.parts.TabOrderableEditPart;
import com.iscobol.screenpainter.parts.TabPageEditPart;
import com.iscobol.screenpainter.parts.gui.ComponentImageFigure;
import com.iscobol.screenpainter.policies.ChangeTitleDirectEditPolicy;
import com.iscobol.screenpainter.policies.ComponentDeletionEditPolicy;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * Exception performing whole class analysis ignored.
 */
public class ComponentEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
TabOrderableEditPart,
DirectEditable {
    private static final int HEADER_BUTTON_SPACING = 5;
    private Rectangle oldBounds;
    protected ChangeTitleDirectEditManager manager;

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            this.getCastedModel().addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void setParent(EditPart editPart) {
        super.setParent(editPart);
    }

    private void openMenuSettingsDialog(MenuModel menuModel) {
        Menu menu = (Menu)menuModel.getTarget();
        MenuSettingsDialog menuSettingsDialog = new MenuSettingsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), menu.getItemSettings());
        MenuItemSettingList menuItemSettingList = (MenuItemSettingList)menuSettingsDialog.openDialog();
        if (menuItemSettingList != null) {
            menuModel.setPropertyValue((Object)"item settings", (Object)menuItemSettingList);
            ScreenProgramEditor screenProgramEditor = PluginUtilities.getCurrentScreenProgramEditor();
            if (screenProgramEditor != null) {
                screenProgramEditor.setDirty(true);
            }
        }
    }

    private void openTreeSettingsDialog(ComponentModel componentModel) {
        AbstractTreeView abstractTreeView = (AbstractTreeView)componentModel.getTarget();
        TreeViewSettingsDialog treeViewSettingsDialog = new TreeViewSettingsDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), abstractTreeView.getTreeItemSettings());
        TreeViewItemSettingList treeViewItemSettingList = (TreeViewItemSettingList)treeViewSettingsDialog.openDialog();
        if (treeViewItemSettingList != null) {
            componentModel.setPropertyValue((Object)"tree item settings", (Object)treeViewItemSettingList);
            ScreenProgramEditor screenProgramEditor = PluginUtilities.getCurrentScreenProgramEditor();
            if (screenProgramEditor != null) {
                screenProgramEditor.setDirty(true);
            }
        }
    }

    public void openSettingsDialog(ComponentModel componentModel, String string, SettingItemList settingItemList, Shell shell, int[] nArray, String string2) {
        Object object = settingItemList instanceof MenuItemSettingList ? new MenuSettingsDialog(shell, (MenuItemSettingList)settingItemList) : new SettingsDialog(shell, settingItemList);
        object.setSelection(nArray, string2);
        SettingItemList settingItemList2 = object.openDialog();
        if (settingItemList2 != null) {
            componentModel.setPropertyValue((Object)string, (Object)settingItemList2);
            ScreenProgramEditor screenProgramEditor = PluginUtilities.getCurrentScreenProgramEditor();
            if (screenProgramEditor != null) {
                screenProgramEditor.setDirty(true);
            }
        }
    }

    private void openBitmapDialog(ComponentModel componentModel) {
        AbstractBitmap abstractBitmap = (AbstractBitmap)componentModel.getTarget();
        ImageType imageType = abstractBitmap.getBitmap();
        imageType = PropertyDescriptorRegistry.openImageDialog((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)(imageType != null ? imageType.getFileName() : null));
        if (imageType != null) {
            componentModel.setPropertyValue((Object)"bitmap", (Object)imageType);
            ScreenProgramEditor screenProgramEditor = PluginUtilities.getCurrentScreenProgramEditor();
            if (screenProgramEditor != null) {
                screenProgramEditor.setDirty(true);
            }
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            ComponentModel componentModel = this.getCastedModel();
            switch (componentModel.getType()) {
                case 301: {
                    this.openMenuSettingsDialog((MenuModel)componentModel);
                    break;
                }
                case 115: {
                    this.openTreeSettingsDialog(componentModel);
                    break;
                }
                case 106: {
                    this.openBitmapDialog(componentModel);
                    break;
                }
                case 105: {
                    String string = ((ScreenPainterModelWithTitle)this.getModel()).getTitle();
                    this.performDirectEdit(string, true);
                    break;
                }
                default: {
                    PropertyDescriptorRegistry.openEventParagraphsEditor((IscobolScreenPainterEditPart)this);
                }
            }
        }
        super.performRequest(request);
    }

    public void performDirectEdit(String string, boolean bl) {
        if (this.manager == null) {
            this.manager = new ChangeTitleDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, (CellEditorLocator)new ChangeTitleCellEditorLocator((GraphicalEditPart)this));
        }
        this.manager.setOrigValue(string, bl);
        this.manager.show();
    }

    public boolean isDirectEditSupported() {
        return this.isDirectEditSupported(true);
    }

    private boolean isDirectEditSupported(boolean bl) {
        switch (this.getCastedModel().getType()) {
            case 105: 
            case 113: {
                return true;
            }
            case 104: {
                if (bl) {
                    AbstractCheckBox abstractCheckBox = (AbstractCheckBox)this.getCastedModel().getTarget();
                    return abstractCheckBox.getBitmap() == null || abstractCheckBox.getTitlePosition().getValue() > 0;
                }
                return true;
            }
            case 102: {
                if (bl) {
                    AbstractPushButton abstractPushButton = (AbstractPushButton)this.getCastedModel().getTarget();
                    return abstractPushButton.getBitmap() == null || abstractPushButton.getTitlePosition().getValue() > 0;
                }
                return true;
            }
            case 103: {
                if (bl) {
                    AbstractRadioButton abstractRadioButton = (AbstractRadioButton)this.getCastedModel().getTarget();
                    return abstractRadioButton.getBitmap() == null || abstractRadioButton.getTitlePosition().getValue() > 0;
                }
                return true;
            }
        }
        return false;
    }

    protected void createEditPolicies() {
        this.installEditPolicy((Object)"ComponentEditPolicy", (EditPolicy)new ComponentDeletionEditPolicy());
        if (this.isDirectEditSupported(false)) {
            this.installEditPolicy((Object)"DirectEditPolicy", (EditPolicy)new ChangeTitleDirectEditPolicy());
        }
    }

    protected IFigure createFigure() {
        ComponentImageFigure componentImageFigure = new ComponentImageFigure((Object)this.getTabOrderable(), this.getCastedModel().isWd2Unsupported());
        componentImageFigure.setLayoutManager((LayoutManager)new XYLayout());
        Object object = this.getControl();
        if (object instanceof AbstractBeanControl) {
            ((AbstractBeanControl)object).refreshComponent();
        }
        Component component = this.getAwtComponent();
        this.setImage((ImageFigure)componentImageFigure, component);
        if (object instanceof AbstractButton && ((AbstractButton)object).isMultiline()) {
            this.setImage((ImageFigure)componentImageFigure, component);
        }
        return componentImageFigure;
    }

    protected Object getControl() {
        return this.getCastedModel().getTarget();
    }

    protected Component getAwtComponent() {
        return ((AbstractBeanControl)this.getControl()).getComponent();
    }

    protected void setImage(ImageFigure imageFigure, Component component) {
        AbstractPushButton abstractPushButton;
        component.setDropTarget(null);
        JPanel jPanel = new JPanel();
        jPanel.enableInputMethods(false);
        jPanel.setLayout(new GridLayout(1, 0));
        org.eclipse.draw2d.geometry.Dimension dimension = this.getCastedModel().getSize();
        jPanel.setBounds(0, 0, dimension.width, dimension.height);
        jPanel.setPreferredSize(new Dimension(dimension.width, dimension.height));
        jPanel.add(component);
        jPanel.setBackground(component.getBackground());
        jPanel.doLayout();
        Image image = imageFigure.getImage();
        if (image != null && !image.isDisposed()) {
            image.dispose();
        }
        Object object = this.getCastedModel().getTarget();
        boolean bl = this.getCastedModel().isTransparent();
        this.updateControlDecorations(imageFigure, object);
        if (this.getCastedModel().getOnPageButton() != null && (abstractPushButton = (AbstractPushButton)object).getBitmap() != null) {
            abstractPushButton.setBitmap(abstractPushButton.getBitmap().getImage(), (float)dimension.width, (float)dimension.height, true, abstractPushButton.isAutoFit(), abstractPushButton.isFlat(), abstractPushButton.getTitlePosition().getValue());
        }
        image = BeanSnapshoter.takeSWTPictureOf((JComponent)jPanel, (boolean)bl);
        imageFigure.setImage(image);
    }

    boolean isForceShowTabOrder() {
        WindowModel windowModel = this.getCastedModel().getParentWindow();
        return windowModel != null ? windowModel.isForceShowTabOrder() : false;
    }

    protected void updateControlDecorations(ImageFigure imageFigure, Object object) {
        if (imageFigure instanceof ComponentImageFigure) {
            boolean bl = this.isForceShowTabOrder();
            if (object instanceof TabOrderable && (bl || IscobolScreenPainterPlugin.getBooleanFromStore((String)"iscobolsp.showtaborder"))) {
                ((ComponentImageFigure)imageFigure).setDisplayedTabOrder(((TabOrderable)object).getTabOrder());
            }
            if (object instanceof AbstractBeanControl && IscobolScreenPainterPlugin.getBooleanFromStore((String)"iscobolsp.showcontrolid")) {
                AbstractBeanControl abstractBeanControl = (AbstractBeanControl)object;
                String string = abstractBeanControl.getIdVariable();
                if (string == null || string.length() == 0) {
                    string = Integer.toString(abstractBeanControl.getId());
                }
                ((ComponentImageFigure)imageFigure).setDisplayedId(string);
            }
            if (object instanceof AbstractBeanControl) {
                ((ComponentImageFigure)imageFigure).setDisplayedLocked(IscobolScreenPainterPlugin.getBooleanFromStore((String)"iscobolsp.showlockedicon") && ((AbstractBeanControl)object).isLock());
            }
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getCastedModel().removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    private ComponentModel getCastedModel() {
        return (ComponentModel)this.getModel();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Component component;
        this.refreshVisuals();
        String string = propertyChangeEvent.getPropertyName();
        if ("Component.Location".equals(string)) {
            return;
        }
        if ("on-header".equals(string)) {
            boolean bl = (Integer)propertyChangeEvent.getNewValue() == 1;
            for (component = this.getCastedModel().getParent(); component != null; component = component.getParent()) {
                if (!(component instanceof RibbonModel)) continue;
                RibbonModel ribbonModel = (RibbonModel)component;
                AbstractRibbon abstractRibbon = (AbstractRibbon)ribbonModel.getTarget();
                if (bl) {
                    abstractRibbon.setHeader(true);
                    ribbonModel.addOnHeaderButton(this.getCastedModel());
                    continue;
                }
                if (!(abstractRibbon.getPopUpMenu() != null && abstractRibbon.getPopUpMenu().length() != 0 || ribbonModel.hasOnHeaderComponents())) {
                    abstractRibbon.setHeader(false);
                }
                ribbonModel.removeOnHeaderButton(this.getCastedModel().getTarget());
            }
        } else if ("Component.Size".equals(string) && this.getCastedModel().isOnRibbonHeader()) {
            RibbonEditPart ribbonEditPart = (RibbonEditPart)this.getParent();
            ribbonEditPart.refreshOnHeaderButtons();
        }
        ImageFigure imageFigure = (ImageFigure)this.getFigure();
        component = this.getAwtComponent();
        this.setImage(imageFigure, component);
        if (propertyChangeEvent.getPropertyName().equals("multiline") && this.getControl() instanceof AbstractButton && ((AbstractButton)this.getControl()).isMultiline()) {
            this.setImage(imageFigure, component);
        }
    }

    public void refreshVisuals() {
        Rectangle rectangle;
        ComponentModel componentModel = this.getCastedModel();
        if (componentModel.isOnRibbonHeader()) {
            rectangle = new Rectangle();
            rectangle.height = 24;
            rectangle.width = (int)((AbstractPushButton)componentModel.getTarget()).getSizePixels() + 8;
            rectangle.y = 22;
            int n = 0;
            RibbonModel ribbonModel = (RibbonModel)componentModel.getParent();
            List list = ribbonModel.getOnHeaderButtons();
            for (ComponentModel componentModel2 : list) {
                n += 5;
                if (componentModel2 == componentModel) {
                    rectangle.x = n;
                }
                n += (int)((AbstractPushButton)componentModel2.getTarget()).getSizePixels() + 8;
            }
            int n2 = ribbonModel.getSize().width;
            if (n2 > n) {
                int n3 = ((AbstractRibbon)ribbonModel.getTarget()).getHeaderAlignment().getValue();
                if (n3 == 0) {
                    rectangle.x += (n2 - n) / 2;
                } else if (n3 == 2) {
                    rectangle.x += n2 - n;
                }
            }
        } else {
            rectangle = new Rectangle(componentModel.getLocation(), componentModel.getSize());
        }
        if (this.oldBounds == null || !this.oldBounds.equals((Object)rectangle)) {
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)rectangle);
            this.oldBounds = rectangle;
        }
    }

    void refreshBounds() {
        ComponentModel componentModel = this.getCastedModel();
        AbstractBeanControl abstractBeanControl = (AbstractBeanControl)componentModel.getTarget();
        componentModel.intSetLocation(new Point((int)abstractBeanControl.getColumnPixels(), (int)abstractBeanControl.getLinePixels()));
        componentModel.intSetSize(new org.eclipse.draw2d.geometry.Dimension((int)abstractBeanControl.getSizePixels(), (int)abstractBeanControl.getLinesPixels()));
        WindowModel windowModel = this.getCastedModel().getParentWindow();
        this.refreshVarPixelProps(windowModel.getScreenProgram(), windowModel.isUnitPixel(), false);
    }

    void refreshVarPixelProps(ScreenProgram screenProgram, boolean bl, boolean bl2) {
        VariableType variableType;
        AbstractBeanControl abstractBeanControl = (AbstractBeanControl)this.getCastedModel().getTarget();
        if (abstractBeanControl.getLinesVariable() != null && (variableType = screenProgram.getProgramVariable(abstractBeanControl.getLinesVariable())) != null && PropertyDescriptorRegistry.canModify((VariableType)variableType)) {
            variableType.setValue(bl ? Integer.toString((int)abstractBeanControl.getLinesPixels()) : Float.toString(abstractBeanControl.getLines()));
        }
        if (abstractBeanControl.getSizeVariable() != null && (variableType = screenProgram.getProgramVariable(abstractBeanControl.getSizeVariable())) != null && PropertyDescriptorRegistry.canModify((VariableType)variableType)) {
            variableType.setValue(bl ? Integer.toString((int)abstractBeanControl.getSizePixels()) : Float.toString(abstractBeanControl.getSize()));
        }
        if (abstractBeanControl.getLineVariable() != null && (variableType = screenProgram.getProgramVariable(abstractBeanControl.getLineVariable())) != null && PropertyDescriptorRegistry.canModify((VariableType)variableType)) {
            variableType.setValue(bl ? Integer.toString((int)abstractBeanControl.calculateLinePixels()) : Float.toString(abstractBeanControl.calculateLine()));
        }
        if (abstractBeanControl.getColumnVariable() != null && (variableType = screenProgram.getProgramVariable(abstractBeanControl.getColumnVariable())) != null && PropertyDescriptorRegistry.canModify((VariableType)variableType)) {
            variableType.setValue(bl ? Integer.toString((int)abstractBeanControl.calculateColumnPixels()) : Float.toString(abstractBeanControl.calculateColumn()));
        }
    }

    void updateUI() {
        ComponentModel componentModel = this.getCastedModel();
        AbstractBeanControl abstractBeanControl = (AbstractBeanControl)componentModel.getTarget();
        abstractBeanControl.refreshComponent();
        SwingUtilities.updateComponentTreeUI(abstractBeanControl.getComponent());
        IFigure iFigure = this.getFigure();
        if (iFigure instanceof ImageFigure) {
            this.setImage((ImageFigure)iFigure, this.getAwtComponent());
        }
    }

    void update() {
        ComponentModel componentModel = this.getCastedModel();
        AbstractBeanControl abstractBeanControl = (AbstractBeanControl)componentModel.getTarget();
        abstractBeanControl.refreshComponent();
        IFigure iFigure = this.getFigure();
        if (iFigure instanceof ImageFigure) {
            this.setImage((ImageFigure)iFigure, this.getAwtComponent());
        }
    }

    void updateControlDecorations(String string) {
        if ("iscobolsp.showtaborder".equals(string)) {
            IFigure iFigure = this.getFigure();
            TabOrderable tabOrderable = this.getTabOrderable();
            if (iFigure instanceof ComponentImageFigure && tabOrderable != null) {
                boolean bl;
                ComponentImageFigure componentImageFigure = (ComponentImageFigure)iFigure;
                boolean bl2 = this.isForceShowTabOrder();
                boolean bl3 = bl = bl2 || IscobolScreenPainterPlugin.getBooleanFromStore((String)string);
                if (bl) {
                    componentImageFigure.setDisplayedTabOrder(tabOrderable.getTabOrder());
                } else {
                    componentImageFigure.setDisplayedTabOrder(0);
                }
            }
        } else if ("iscobolsp.showcontrolid".equals(string)) {
            IFigure iFigure = this.getFigure();
            Object object = this.getCastedModel().getTarget();
            if (iFigure instanceof ComponentImageFigure && object instanceof AbstractBeanControl) {
                ComponentImageFigure componentImageFigure = (ComponentImageFigure)iFigure;
                AbstractBeanControl abstractBeanControl = (AbstractBeanControl)object;
                boolean bl = IscobolScreenPainterPlugin.getBooleanFromStore((String)string);
                if (bl) {
                    String string2 = abstractBeanControl.getIdVariable();
                    if (string2 == null || string2.length() == 0) {
                        string2 = Integer.toString(abstractBeanControl.getId());
                    }
                    componentImageFigure.setDisplayedId(string2);
                } else {
                    componentImageFigure.setDisplayedId(null);
                }
            }
        } else if ("iscobolsp.showlockedicon".equals(string)) {
            IFigure iFigure = this.getFigure();
            Object object = this.getCastedModel().getTarget();
            if (iFigure instanceof ComponentImageFigure && object instanceof AbstractBeanControl) {
                ComponentImageFigure componentImageFigure = (ComponentImageFigure)iFigure;
                AbstractBeanControl abstractBeanControl = (AbstractBeanControl)object;
                boolean bl = IscobolScreenPainterPlugin.getBooleanFromStore((String)string);
                componentImageFigure.setDisplayedLocked(abstractBeanControl.isLock() && bl);
            }
        }
    }

    void setColorConstraint(ColorType colorType) {
        ComponentModel componentModel = this.getCastedModel();
        AbstractBeanControl abstractBeanControl = (AbstractBeanControl)componentModel.getTarget();
        abstractBeanControl.refreshComponent();
        IFigure iFigure = this.getFigure();
        if (iFigure instanceof ImageFigure) {
            this.setImage((ImageFigure)iFigure, this.getAwtComponent());
        }
    }

    void setFontConstraint(FontType fontType) {
        ComponentModel componentModel = this.getCastedModel();
        AbstractBeanControl abstractBeanControl = (AbstractBeanControl)componentModel.getTarget();
        abstractBeanControl.refreshComponent();
        IFigure iFigure = this.getFigure();
        if (iFigure instanceof ImageFigure) {
            this.setImage((ImageFigure)iFigure, this.getAwtComponent());
        }
    }

    public TabOrderable getTabOrderable() {
        return (TabOrderable)this.getCastedModel().getTarget();
    }

    public void setDisplayedTabOrder(int n) {
        ((ComponentImageFigure)this.getFigure()).setDisplayedTabOrder(n);
    }

    public void setSelected(int n) {
        if (n == 2) {
            TabPageEditPart[] tabPageEditPartArray = ComponentEditPart.getAncestorTabPages((EditPart)this);
            for (int i = 0; i < tabPageEditPartArray.length; ++i) {
                tabPageEditPartArray[i].makePageVisible();
            }
        }
        super.setSelected(n);
    }

    static TabPageEditPart getAncestorTabPage(EditPart editPart) {
        for (editPart = editPart.getParent(); editPart != null && !(editPart instanceof TabPageEditPart); editPart = editPart.getParent()) {
        }
        return (TabPageEditPart)editPart;
    }

    static TabPageEditPart[] getAncestorTabPages(EditPart editPart) {
        TabPageEditPart tabPageEditPart;
        ArrayList<TabPageEditPart> arrayList = new ArrayList<TabPageEditPart>();
        while ((tabPageEditPart = ComponentEditPart.getAncestorTabPage((EditPart)editPart)) != null) {
            arrayList.add(0, tabPageEditPart);
            editPart = tabPageEditPart;
        }
        return arrayList.toArray(new TabPageEditPart[arrayList.size()]);
    }

    public ScreenPainterModel getScreenPainterModel() {
        return this.getCastedModel();
    }
}

