/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.parts;

import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.AbstractFrame;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.model.FrameModel;
import com.iscobol.screenpainter.parts.ComponentEditPart;
import com.iscobol.screenpainter.parts.ScreenPainterMarqueeDragTracker;
import com.iscobol.screenpainter.parts.gui.BorderedFrameFigure;
import com.iscobol.screenpainter.policies.ChangeTitleDirectEditPolicy;
import com.iscobol.screenpainter.policies.ComponentDeletionEditPolicy;
import com.iscobol.screenpainter.policies.FrameXYLayoutEditPolicy;
import com.iscobol.screenpainter.policies.GuideEditPolicy;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;

public class FrameEditPart
extends ComponentEditPart {
    private Font lastFont;

    protected void createEditPolicies() {
        this.installEditPolicy((Object)"LayoutEditPolicy", (EditPolicy)new FrameXYLayoutEditPolicy());
        this.installEditPolicy((Object)"ComponentEditPolicy", (EditPolicy)new ComponentDeletionEditPolicy());
        this.installEditPolicy((Object)"Snap Helper Feedback", (EditPolicy)new GuideEditPolicy("iscobolsp.guides.snaptoguides.color"));
        this.installEditPolicy((Object)"DirectEditPolicy", (EditPolicy)new ChangeTitleDirectEditPolicy());
    }

    public Object getAdapter(Class clazz) {
        SnapToHelper snapToHelper = PluginUtilities.getScreenDesignerSnapToHelper((Class)clazz, (GraphicalEditPart)this);
        if (snapToHelper != null) {
            return snapToHelper;
        }
        return super.getAdapter(clazz);
    }

    protected void setImage(ImageFigure imageFigure, Component component) {
        this.updateControlDecorations(imageFigure, this.getCastedModel().getTarget());
    }

    private FrameModel getCastedModel() {
        return (FrameModel)this.getModel();
    }

    public void deactivate() {
        super.deactivate();
        if (this.lastFont != null) {
            this.lastFont.dispose();
        }
    }

    protected IFigure createFigure() {
        AbstractFrame abstractFrame = (AbstractFrame)this.getCastedModel().getTarget();
        BorderedFrameFigure borderedFrameFigure = new BorderedFrameFigure(abstractFrame);
        borderedFrameFigure.setLayoutManager((LayoutManager)new XYLayout());
        this.computeFont(borderedFrameFigure);
        this.updateControlDecorations((ImageFigure)borderedFrameFigure, (Object)abstractFrame);
        return borderedFrameFigure;
    }

    public DragTracker getDragTracker(Request request) {
        if (this.getSelected() != 0) {
            return super.getDragTracker(request);
        }
        return new ScreenPainterMarqueeDragTracker((AbstractGraphicalEditPart)this);
    }

    protected List getModelChildren() {
        return this.getCastedModel().getComponents();
    }

    private void computeFont(BorderedFrameFigure borderedFrameFigure) {
        AbstractFrame abstractFrame = (AbstractFrame)this.getCastedModel().getTarget();
        FontType fontType = abstractFrame.getFont(true);
        int n = 0;
        if (fontType.isBold()) {
            n |= 1;
        }
        if (fontType.isItalic()) {
            n |= 2;
        }
        if (this.lastFont != null) {
            this.lastFont.dispose();
        }
        this.lastFont = new Font((Device)Display.getDefault(), fontType.getName(), (int)fontType.getSize(), n);
        borderedFrameFigure.setFrameFont(this.lastFont);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("ComponentAdded".equals(string) || "ComponentRemoved".equals(string) || "Element.UpdateStructure".equals(string)) {
            this.refreshChildren();
        } else {
            this.refreshVisuals();
            BorderedFrameFigure borderedFrameFigure = (BorderedFrameFigure)this.getFigure();
            this.computeFont(borderedFrameFigure);
            this.updateControlDecorations((ImageFigure)borderedFrameFigure, this.getCastedModel().getTarget());
            borderedFrameFigure.repaint();
        }
    }

    void setColorConstraint(ColorType colorType) {
        super.setColorConstraint(colorType);
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            ComponentEditPart componentEditPart = (ComponentEditPart)listIterator.next();
            componentEditPart.setColorConstraint(colorType);
        }
        this.getFigure().repaint();
    }

    void updateUI() {
        super.updateUI();
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            ComponentEditPart componentEditPart = (ComponentEditPart)listIterator.next();
            componentEditPart.updateUI();
        }
        this.getFigure().repaint();
    }

    void update() {
        super.update();
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            ComponentEditPart componentEditPart = (ComponentEditPart)listIterator.next();
            componentEditPart.update();
        }
        this.getFigure().repaint();
    }

    void updateControlDecorations(String string) {
        super.updateControlDecorations(string);
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            ComponentEditPart componentEditPart = (ComponentEditPart)listIterator.next();
            componentEditPart.updateControlDecorations(string);
        }
    }

    void setFontConstraint(FontType fontType) {
        super.setFontConstraint(fontType);
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            ComponentEditPart componentEditPart = (ComponentEditPart)listIterator.next();
            componentEditPart.setFontConstraint(fontType);
        }
        this.computeFont((BorderedFrameFigure)this.getFigure());
        this.getFigure().repaint();
    }

    void refreshBounds() {
        super.refreshBounds();
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            ComponentEditPart componentEditPart = (ComponentEditPart)listIterator.next();
            componentEditPart.refreshBounds();
        }
    }

    void refreshVarPixelProps(ScreenProgram screenProgram, boolean bl, boolean bl2) {
        super.refreshVarPixelProps(screenProgram, bl, bl2);
        if (bl2) {
            ListIterator listIterator = this.getChildren().listIterator();
            while (listIterator.hasNext()) {
                ComponentEditPart componentEditPart = (ComponentEditPart)listIterator.next();
                componentEditPart.refreshVarPixelProps(screenProgram, bl, bl2);
            }
        }
    }
}

