/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.parts;

import com.iscobol.screenpainter.parts.IscobolMarqueeDragTracker;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.SharedCursors;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.AbstractTool;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;

public abstract class IscobolMarqueeDragTracker
extends AbstractTool
implements DragTracker {
    static final int DEFAULT_MODE = 0;
    static final int TOGGLE_MODE = 1;
    static final int APPEND_MODE = 2;
    private Figure marqueeRectangleFigure;
    private ArrayList allChildren = new ArrayList();
    private ArrayList selectedEditParts;
    private int mode;
    private AbstractGraphicalEditPart selectionRoot;
    private static final Request MARQUEE_REQUEST = new Request((Object)"selection");

    public IscobolMarqueeDragTracker(AbstractGraphicalEditPart abstractGraphicalEditPart) {
        this.selectionRoot = abstractGraphicalEditPart;
        this.setDefaultCursor(SharedCursors.CROSS);
        this.setUnloadWhenFinished(false);
    }

    private void calculateNewSelection(ArrayList arrayList, ArrayList arrayList2) {
        Rectangle rectangle = this.getMarqueeSelectionRectangle();
        ArrayList arrayList3 = this.getAllChildren();
        int n = arrayList3.size();
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            GraphicalEditPart graphicalEditPart = (GraphicalEditPart)arrayList3.get(i);
            IFigure iFigure = graphicalEditPart.getFigure();
            if (!graphicalEditPart.isSelectable() || graphicalEditPart.getTargetEditPart(MARQUEE_REQUEST) != graphicalEditPart || !this.isFigureVisible(iFigure) || !iFigure.isShowing()) continue;
            Rectangle rectangle2 = iFigure.getBounds().getCopy();
            iFigure.translateToAbsolute((Translatable)rectangle2);
            boolean bl2 = rectangle.intersects(rectangle2);
            if (!bl2) continue;
            bl = false;
            if (graphicalEditPart.getSelected() == 0 || this.mode != 1) {
                arrayList.add(graphicalEditPart);
                continue;
            }
            arrayList2.add(graphicalEditPart);
        }
        if (bl && this.isSelectable(this.selectionRoot)) {
            if (this.selectionRoot.getSelected() == 0 || this.mode != 1) {
                arrayList.add(this.selectionRoot);
            } else {
                arrayList2.add(this.selectionRoot);
            }
        }
    }

    protected abstract boolean isSelectable(AbstractGraphicalEditPart var1);

    public void deactivate() {
        if (this.isInState(4)) {
            this.eraseMarqueeFeedback();
            this.eraseTargetFeedback();
        }
        super.deactivate();
        this.allChildren.clear();
        this.setState(0x40000000);
    }

    private void eraseMarqueeFeedback() {
        if (this.marqueeRectangleFigure != null) {
            this.removeFeedback((IFigure)this.marqueeRectangleFigure);
            this.marqueeRectangleFigure = null;
        }
    }

    private void eraseTargetFeedback() {
        if (this.selectedEditParts == null) {
            return;
        }
        for (EditPart editPart : this.selectedEditParts) {
            editPart.eraseTargetFeedback(MARQUEE_REQUEST);
        }
    }

    private ArrayList getAllChildren() {
        if (this.allChildren.isEmpty()) {
            List list = this.selectionRoot.getChildren();
            for (int i = 0; i < list.size(); ++i) {
                GraphicalEditPart graphicalEditPart = (GraphicalEditPart)list.get(i);
                this.allChildren.add(graphicalEditPart);
            }
        }
        return this.allChildren;
    }

    protected String getCommandName() {
        return "selection";
    }

    private IFigure getMarqueeFeedbackFigure() {
        if (this.marqueeRectangleFigure == null) {
            this.marqueeRectangleFigure = new MarqueeRectangleFigure(null);
            this.addFeedback((IFigure)this.marqueeRectangleFigure);
        }
        return this.marqueeRectangleFigure;
    }

    private Rectangle getMarqueeSelectionRectangle() {
        return new Rectangle(this.getStartLocation(), this.getLocation());
    }

    protected boolean handleButtonDown(int n) {
        if (!this.isGraphicalViewer()) {
            return true;
        }
        if (n != 1) {
            this.setState(8);
            this.handleInvalidInput();
        }
        if (this.stateTransition(1, 4)) {
            this.mode = this.getCurrentInput().isModKeyDown(SWT.MOD1) ? 1 : (this.getCurrentInput().isShiftKeyDown() ? 2 : 0);
        }
        return true;
    }

    protected void handleFinished() {
    }

    protected boolean handleButtonUp(int n) {
        if (this.stateTransition(4, 0x40000000)) {
            this.eraseTargetFeedback();
            this.eraseMarqueeFeedback();
            this.performMarqueeSelect();
        }
        this.handleFinished();
        return true;
    }

    protected boolean handleDragInProgress() {
        if (this.isInState(6)) {
            this.showMarqueeFeedback();
            this.eraseTargetFeedback();
            this.selectedEditParts = new ArrayList();
            this.calculateNewSelection(this.selectedEditParts, new ArrayList());
            this.showTargetFeedback();
        }
        return true;
    }

    protected boolean handleFocusLost() {
        if (this.isInState(6)) {
            this.handleFinished();
            return true;
        }
        return false;
    }

    protected boolean handleInvalidInput() {
        this.eraseTargetFeedback();
        this.eraseMarqueeFeedback();
        return true;
    }

    protected boolean handleKeyDown(KeyEvent keyEvent) {
        if (super.handleKeyDown(keyEvent)) {
            return true;
        }
        if (this.getCurrentViewer().getKeyHandler() != null) {
            return this.getCurrentViewer().getKeyHandler().keyPressed(keyEvent);
        }
        return false;
    }

    private boolean isFigureVisible(IFigure iFigure) {
        Rectangle rectangle = iFigure.getBounds().getCopy();
        for (IFigure iFigure2 = iFigure.getParent(); !rectangle.isEmpty() && iFigure2 != null; iFigure2 = iFigure2.getParent()) {
            iFigure2.translateToParent((Translatable)rectangle);
            rectangle.intersect(iFigure2.getBounds());
        }
        return !rectangle.isEmpty();
    }

    private boolean isGraphicalViewer() {
        return this.getCurrentViewer() instanceof GraphicalViewer;
    }

    protected boolean isViewerImportant(EditPartViewer editPartViewer) {
        return editPartViewer instanceof GraphicalViewer;
    }

    private void performMarqueeSelect() {
        EditPartViewer editPartViewer = this.getCurrentViewer();
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.calculateNewSelection(arrayList, arrayList2);
        if (this.mode != 0) {
            arrayList.addAll(0, editPartViewer.getSelectedEditParts());
            arrayList.removeAll(arrayList2);
        }
        editPartViewer.setSelection((ISelection)new StructuredSelection(arrayList.toArray()));
    }

    public void setViewer(EditPartViewer editPartViewer) {
        if (editPartViewer == this.getCurrentViewer()) {
            return;
        }
        super.setViewer(editPartViewer);
        if (editPartViewer instanceof GraphicalViewer) {
            this.setDefaultCursor(SharedCursors.CROSS);
        } else {
            this.setDefaultCursor(SharedCursors.NO);
        }
    }

    private void showMarqueeFeedback() {
        Rectangle rectangle = this.getMarqueeSelectionRectangle().getCopy();
        this.getMarqueeFeedbackFigure().translateToRelative((Translatable)rectangle);
        this.getMarqueeFeedbackFigure().setBounds(rectangle);
    }

    private void showTargetFeedback() {
        for (EditPart editPart : this.selectedEditParts) {
            editPart.showTargetFeedback(MARQUEE_REQUEST);
        }
    }
}

