/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.parts;

import com.iscobol.reportdesigner.beans.ReportLabel;
import com.iscobol.reportdesigner.beans.types.Justification;
import com.iscobol.reportdesigner.model.ReportComponentModel;
import com.iscobol.reportdesigner.parts.ReportComponentEditPart;
import com.iscobol.reportdesigner.parts.ReportDesignerEditPart;
import com.iscobol.reportdesigner.parts.ReportEditPart;
import com.iscobol.reportdesigner.parts.ReportSectionEditPart;
import com.iscobol.reportdesigner.parts.gui.ReportComponentFigure;
import com.iscobol.screenpainter.beans.AbstractButton;
import com.iscobol.screenpainter.beans.AbstractLabel;
import com.iscobol.screenpainter.beans.AbstractPushButton;
import com.iscobol.screenpainter.model.ComponentModel;
import com.iscobol.screenpainter.model.MenuModel;
import com.iscobol.screenpainter.parts.ComponentEditPart;
import com.iscobol.screenpainter.parts.IscobolScreenPainterEditPart;
import com.iscobol.screenpainter.parts.MenuEditPart;
import com.iscobol.screenpainter.parts.RibbonEditPart;
import com.iscobol.screenpainter.parts.ScreenDesignerEditPart;
import com.iscobol.screenpainter.parts.ScreenSectionEditPart;
import com.iscobol.screenpainter.parts.ToolbarEditPart;
import com.iscobol.screenpainter.parts.WindowEditPart;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToGuides;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;

public class IscobolSnapToGuides
extends SnapToGuides {
    private Request lastRequest;
    private GraphicalEditPart rootGraphicalEditPart;
    private boolean report;

    public IscobolSnapToGuides(GraphicalEditPart graphicalEditPart) {
        super(graphicalEditPart);
        if (this.container instanceof ScreenDesignerEditPart || this.container instanceof ScreenSectionEditPart) {
            for (EditPart editPart = this.container.getParent(); editPart != null; editPart = editPart.getParent()) {
                if (!(editPart instanceof WindowEditPart)) continue;
                this.rootGraphicalEditPart = (WindowEditPart)editPart;
                break;
            }
        } else if (this.container instanceof ReportDesignerEditPart) {
            for (EditPart editPart = this.container.getParent(); editPart != null; editPart = editPart.getParent()) {
                if (!(editPart instanceof ReportEditPart)) continue;
                this.rootGraphicalEditPart = (ReportEditPart)editPart;
                break;
            }
            this.report = true;
        }
    }

    protected final int[] getHorizontalGuides() {
        if (this.horizontalGuides == null) {
            this.horizontalGuides = this.getGuides(true);
        }
        return this.horizontalGuides;
    }

    protected final int[] getVerticalGuides() {
        if (this.verticalGuides == null) {
            this.verticalGuides = this.getGuides(false);
        }
        return this.verticalGuides;
    }

    private List<GraphicalEditPart> getAllEditParts() {
        ArrayList<GraphicalEditPart> arrayList = new ArrayList<GraphicalEditPart>();
        List list = this.container.getRoot().getChildren();
        for (EditPart editPart : list) {
            if (!(editPart instanceof GraphicalEditPart)) continue;
            this.getAllEditParts(arrayList, (GraphicalEditPart)editPart);
        }
        return arrayList;
    }

    private void getAllEditParts(List<GraphicalEditPart> list, GraphicalEditPart graphicalEditPart) {
        if (graphicalEditPart instanceof IscobolScreenPainterEditPart) {
            list.add(graphicalEditPart);
        }
        List list2 = graphicalEditPart.getChildren();
        for (EditPart editPart : list2) {
            if (!(editPart instanceof GraphicalEditPart)) continue;
            this.getAllEditParts(list, (GraphicalEditPart)editPart);
        }
    }

    private boolean isAllowedType(EditPart editPart) {
        if (this.report) {
            return !(editPart instanceof ReportEditPart) && !(editPart instanceof ReportSectionEditPart);
        }
        return !(editPart instanceof WindowEditPart) && !(editPart instanceof MenuEditPart) && !(editPart instanceof ToolbarEditPart) && !(editPart instanceof RibbonEditPart);
    }

    private int[] getGuides(boolean bl) {
        Object object;
        List list = this.getAllEditParts();
        TreeSet treeSet = new TreeSet();
        EditPart editPart = null;
        if (this.lastRequest instanceof ChangeBoundsRequest) {
            object = (ChangeBoundsRequest)this.lastRequest;
            if (object.getEditParts().size() > 0) {
                editPart = (EditPart)object.getEditParts().get(0);
            }
        } else if (this.lastRequest instanceof CreateRequest && (object = (CreateRequest)this.lastRequest).getNewObject() instanceof MenuModel) {
            return new int[0];
        }
        if (!this.isAllowedType(editPart)) {
            return new int[0];
        }
        for (GraphicalEditPart graphicalEditPart : list) {
            this.addPositions((EditPart)graphicalEditPart, treeSet, bl, editPart);
        }
        object = new int[treeSet.size()];
        int n = 0;
        for (Integer n2 : treeSet) {
            object[n++] = (ChangeBoundsRequest)n2;
        }
        return object;
    }

    protected void addPositions(EditPart editPart, Set<Integer> set, boolean bl, EditPart editPart2) {
        if (editPart == editPart2 || !this.isAllowedType(editPart)) {
            return;
        }
        GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
        Rectangle rectangle = graphicalEditPart.getFigure().getBounds();
        graphicalEditPart.getFigure().translateToAbsolute((Translatable)rectangle);
        this.rootGraphicalEditPart.getFigure().translateToRelative((Translatable)rectangle);
        if (bl) {
            set.add(rectangle.y);
            set.add(rectangle.y + rectangle.height - 1);
        } else {
            set.add(rectangle.x);
            set.add(rectangle.x + rectangle.width - 1);
        }
        if (graphicalEditPart instanceof ComponentEditPart) {
            ComponentModel componentModel = (ComponentModel)((ComponentEditPart)graphicalEditPart).getModel();
            block0 : switch (componentModel.getType()) {
                case 105: {
                    AbstractLabel abstractLabel = (AbstractLabel)componentModel.getTarget();
                    JLabel jLabel = (JLabel)abstractLabel.getComponent();
                    Dimension dimension = jLabel.getPreferredSize();
                    if (dimension.width >= rectangle.width && dimension.height >= rectangle.height) break;
                    switch (abstractLabel.getOrientation().getValue()) {
                        default: {
                            if (bl) {
                                set.add(rectangle.y + dimension.height - 1);
                                break block0;
                            }
                            set.add(rectangle.x + dimension.width - 1);
                            break block0;
                        }
                        case 1: {
                            int n = (rectangle.width - dimension.width) / 2;
                            if (bl) {
                                set.add(rectangle.y + dimension.height - 1);
                                break block0;
                            }
                            set.add(rectangle.x + n);
                            set.add(rectangle.x + n + dimension.width - 1);
                            break block0;
                        }
                        case 2: {
                            if (bl) {
                                set.add(rectangle.y + dimension.height - 1);
                                break block0;
                            }
                            set.add(rectangle.x + rectangle.width - dimension.width);
                            break block0;
                        }
                        case 6: 
                        case 7: {
                            int n = (rectangle.width - dimension.width) / 2;
                            if (bl) {
                                set.add(rectangle.y + rectangle.height - dimension.height);
                                break block0;
                            }
                            set.add(rectangle.x + n);
                            set.add(rectangle.x + n + dimension.width - 1);
                            break block0;
                        }
                        case 3: 
                        case 4: {
                            int n = (rectangle.width - dimension.width) / 2;
                            if (bl) {
                                set.add(rectangle.y + dimension.height - 1);
                                break block0;
                            }
                            set.add(rectangle.x + n);
                            set.add(rectangle.x + n + dimension.width - 1);
                            break block0;
                        }
                        case 5: 
                    }
                    int n = (rectangle.width - dimension.width) / 2;
                    int n2 = (rectangle.height - dimension.height) / 2;
                    if (bl) {
                        set.add(rectangle.y + n2);
                        set.add(rectangle.y + n2 + dimension.height - 1);
                        break;
                    }
                    set.add(rectangle.x + n);
                    set.add(rectangle.x + n + dimension.width - 1);
                    break;
                }
                case 103: 
                case 104: {
                    AbstractButton abstractButton = (AbstractButton)componentModel.getTarget();
                    JToggleButton jToggleButton = (JToggleButton)abstractButton.getComponent();
                    Dimension dimension = jToggleButton.getPreferredSize();
                    if (dimension.width >= rectangle.width && dimension.height >= rectangle.height) break;
                    int n = (rectangle.height - dimension.height) / 2;
                    if (bl) {
                        set.add(rectangle.y + n);
                        set.add(rectangle.y + n + dimension.height - 1);
                        break;
                    }
                    set.add(rectangle.x + dimension.width - 1);
                    break;
                }
                case 102: {
                    AbstractPushButton abstractPushButton = (AbstractPushButton)componentModel.getTarget();
                    JButton jButton = (JButton)abstractPushButton.getComponent();
                    Dimension dimension = jButton.getPreferredSize();
                    if (dimension.width >= rectangle.width && dimension.height >= rectangle.height) break;
                    switch (abstractPushButton.getAlignment().getValue()) {
                        case 7: {
                            int n = (rectangle.width - dimension.width) / 2;
                            if (bl) {
                                set.add(rectangle.y + rectangle.height - dimension.height);
                                break block0;
                            }
                            set.add(rectangle.x + n);
                            set.add(rectangle.x + n + dimension.width - 1);
                            break block0;
                        }
                        case 6: {
                            if (bl) {
                                set.add(rectangle.y + rectangle.height - dimension.height);
                                break block0;
                            }
                            set.add(rectangle.x + dimension.width - 1);
                            break block0;
                        }
                        case 8: {
                            if (bl) {
                                set.add(rectangle.y + rectangle.height - dimension.height);
                                break block0;
                            }
                            set.add(rectangle.x + rectangle.width - dimension.width);
                            break block0;
                        }
                        case 4: {
                            int n = (rectangle.width - dimension.width) / 2;
                            int n3 = (rectangle.height - dimension.height) / 2;
                            if (bl) {
                                set.add(rectangle.y + n3);
                                set.add(rectangle.y + n3 + dimension.height - 1);
                                break block0;
                            }
                            set.add(rectangle.x + n);
                            set.add(rectangle.x + n + dimension.width - 1);
                            break block0;
                        }
                        case 3: {
                            int n = (rectangle.height - dimension.height) / 2;
                            if (bl) {
                                set.add(rectangle.y + n);
                                set.add(rectangle.y + n + dimension.height - 1);
                                break block0;
                            }
                            set.add(rectangle.x + dimension.width - 1);
                            break block0;
                        }
                        case 5: {
                            int n = (rectangle.height - dimension.height) / 2;
                            if (bl) {
                                set.add(rectangle.y + n);
                                set.add(rectangle.y + n + dimension.height - 1);
                                break block0;
                            }
                            set.add(rectangle.x + rectangle.width - dimension.width);
                            break block0;
                        }
                        case 1: {
                            int n = (rectangle.width - dimension.width) / 2;
                            if (bl) {
                                set.add(rectangle.y + dimension.height - 1);
                                break block0;
                            }
                            set.add(rectangle.x + n);
                            set.add(rectangle.x + n + dimension.width - 1);
                            break block0;
                        }
                        case 0: {
                            if (bl) {
                                set.add(rectangle.y + dimension.height - 1);
                                break block0;
                            }
                            set.add(rectangle.x + dimension.width - 1);
                            break block0;
                        }
                        case 2: {
                            if (bl) {
                                set.add(rectangle.y + dimension.height - 1);
                                break block0;
                            }
                            set.add(rectangle.x + rectangle.width - dimension.width);
                        }
                    }
                }
            }
        } else if (graphicalEditPart instanceof ReportComponentEditPart) {
            ReportComponentEditPart reportComponentEditPart = (ReportComponentEditPart)graphicalEditPart;
            ReportComponentFigure reportComponentFigure = (ReportComponentFigure)reportComponentEditPart.getFigure();
            org.eclipse.draw2d.geometry.Dimension dimension = reportComponentFigure.getPrefSize();
            ReportComponentModel reportComponentModel = (ReportComponentModel)reportComponentEditPart.getModel();
            block23 : switch (reportComponentModel.getType()) {
                case 507: {
                    Justification justification = ((ReportLabel)reportComponentModel.getTarget()).getJustification();
                    switch (justification.getValue()) {
                        default: {
                            if (bl) {
                                set.add(rectangle.y + dimension.height - 1);
                                break block23;
                            }
                            set.add(rectangle.x + dimension.width - 1);
                            break block23;
                        }
                        case 0: {
                            int n = (rectangle.width - dimension.width) / 2;
                            if (bl) {
                                set.add(rectangle.y + dimension.height - 1);
                                break block23;
                            }
                            set.add(rectangle.x + n);
                            set.add(rectangle.x + n + dimension.width - 1);
                            break block23;
                        }
                        case 2: 
                    }
                    if (bl) {
                        set.add(rectangle.y + dimension.height - 1);
                        break;
                    }
                    set.add(rectangle.x + rectangle.width - dimension.width);
                    break;
                }
                case 503: 
                case 509: {
                    if (bl) {
                        set.add(rectangle.y + dimension.height - 1);
                        break;
                    }
                    set.add(rectangle.x + dimension.width - 1);
                }
            }
        }
    }

    public int snapRectangle(Request request, int n, PrecisionRectangle precisionRectangle, PrecisionRectangle precisionRectangle2) {
        this.lastRequest = request;
        return super.snapRectangle(request, n, precisionRectangle, precisionRectangle2);
    }
}

