/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.parts;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.beans.AbstractRibbon;
import com.iscobol.screenpainter.model.RibbonModel;
import com.iscobol.screenpainter.model.WindowModel;
import com.iscobol.screenpainter.parts.ComponentEditPart;
import com.iscobol.screenpainter.parts.TabControlEditPart;
import com.iscobol.screenpainter.policies.BaseConstrainedLayoutEditPolicy;
import com.iscobol.screenpainter.policies.RibbonEditPolicy;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.graphics.RGB;

public class RibbonEditPart
extends TabControlEditPart {
    private int oldHeight;

    protected List getModelChildren() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getCastedModel().getOnHeaderButtons());
        arrayList.addAll(super.getModelChildren());
        return arrayList;
    }

    public void activate() {
        super.activate();
        if (this.getParent() != null) {
            WindowModel windowModel = (WindowModel)this.getParent().getParent().getModel();
            windowModel.addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public void deactivate() {
        if (this.getParent() != null) {
            WindowModel windowModel = (WindowModel)this.getParent().getParent().getModel();
            windowModel.removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.deactivate();
    }

    protected void createEditPolicies() {
        this.installEditPolicy((Object)"ComponentEditPolicy", (EditPolicy)new RibbonEditPolicy());
        this.installEditPolicy((Object)"LayoutEditPolicy", (EditPolicy)new BaseConstrainedLayoutEditPolicy());
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        AbstractRibbon abstractRibbon = (AbstractRibbon)this.getCastedModel().getTarget();
        if (propertyChangeEvent.getSource() instanceof WindowModel) {
            if (string.equals("Component.Size")) {
                abstractRibbon.setConstraints(0, 0, ((WindowModel)propertyChangeEvent.getSource()).getScreenSize().width, abstractRibbon.GetLinesPixels());
                this.refreshOnHeaderButtons();
                super.propertyChange(propertyChangeEvent);
            }
        } else if ("pop up menu".equals(string)) {
            if (propertyChangeEvent.getNewValue() != null) {
                abstractRibbon.setHeader(true);
            } else if (!this.getCastedModel().hasOnHeaderComponents()) {
                abstractRibbon.setHeader(false);
            }
            this.getCastedModel().fireToobarHeightPropertyChange();
        } else if ("HComponentAdded".equals(string)) {
            abstractRibbon.setHeader(true);
            this.getCastedModel().fireToobarHeightPropertyChange();
            this.refreshChildren();
            this.refreshOnHeaderButtons();
        } else if ("HComponentRemoved".equals(string)) {
            if (!this.getCastedModel().hasOnHeaderComponents()) {
                abstractRibbon.setHeader(false);
            }
            this.getCastedModel().fireToobarHeightPropertyChange();
            this.refreshChildren();
            this.refreshOnHeaderButtons();
        } else if ("RibbonHeader.UpdateStructure".equals(string)) {
            this.refreshChildren();
            this.refreshOnHeaderButtons();
        } else {
            super.propertyChange(propertyChangeEvent);
            if (string.equals("Element.UpdateStructure") || string.equals("TabPageAdded") || string.equals("TabPageRemoved")) {
                this.refreshOnHeaderButtons();
            }
        }
    }

    protected IFigure createFigure() {
        IFigure iFigure = super.createFigure();
        Color color = this.getAwtComponent().getBackground();
        iFigure.setBackgroundColor(IscobolScreenPainterPlugin.getDefault().getColorProvider().getColor(new RGB(color.getRed(), color.getGreen(), color.getBlue())));
        return iFigure;
    }

    void refreshOnHeaderButtons() {
        for (EditPart editPart : this.getChildren()) {
            if (!(editPart instanceof ComponentEditPart)) continue;
            ((ComponentEditPart)editPart).refreshVisuals();
        }
    }

    public void refreshVisuals() {
        int n;
        if (this.tcLayout != null) {
            this.tcLayout.setMargin(this.getMargin());
        }
        if (this.oldHeight != (n = this.getCastedModel().getToolbarHeight())) {
            GridData gridData = new GridData(768);
            gridData.heightHint = n;
            ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)gridData);
            this.oldHeight = n;
        }
    }

    private RibbonModel getCastedModel() {
        return (RibbonModel)this.getModel();
    }

    protected int getMargin() {
        return this.getCastedModel().getMargin();
    }
}

