/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.parts;

import com.iscobol.screenpainter.beans.TabOrderable;
import com.iscobol.screenpainter.model.ComponentModel;
import com.iscobol.screenpainter.model.ModelElement;
import com.iscobol.screenpainter.model.RibbonHeaderModel;
import com.iscobol.screenpainter.model.RibbonModel;
import com.iscobol.screenpainter.model.ScreenPainterModel;
import com.iscobol.screenpainter.parts.RibbonHeaderTreeEditPart;
import com.iscobol.screenpainter.parts.ScreenDesignerEditPart;
import com.iscobol.screenpainter.parts.TabOrderableEditPart;
import com.iscobol.screenpainter.policies.ToolbarDeletionEditPolicy;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.swt.graphics.Image;

public class RibbonTreeEditPart
extends AbstractTreeEditPart
implements PropertyChangeListener,
ScreenDesignerEditPart,
TabOrderableEditPart {
    RibbonTreeEditPart(RibbonModel ribbonModel) {
        super((Object)ribbonModel);
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy((Object)"ComponentEditPolicy", (EditPolicy)new ToolbarDeletionEditPolicy());
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected List getModelChildren() {
        ArrayList<RibbonHeaderModel> arrayList = new ArrayList<RibbonHeaderModel>();
        if (this.getCastedModel().getHeaderComponentCount() > 0) {
            arrayList.add(new RibbonHeaderModel(this.getCastedModel()));
        }
        arrayList.addAll(this.getCastedModel().getPages());
        return arrayList;
    }

    private RibbonModel getCastedModel() {
        return (RibbonModel)this.getModel();
    }

    protected Image getImage() {
        return this.getCastedModel().getIcon();
    }

    private EditPart getEditPartForChild(Object object) {
        return (EditPart)this.getViewer().getEditPartRegistry().get(object);
    }

    protected String getText() {
        return this.getCastedModel().toString();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("TabPageAdded".equals(string)) {
            RibbonModel ribbonModel = this.getCastedModel();
            int n = ribbonModel.getPages().indexOf(propertyChangeEvent.getNewValue());
            if (ribbonModel.getHeaderComponentCount() > 0) {
                ++n;
            }
            this.addChild(this.createChild(propertyChangeEvent.getNewValue()), n);
        } else if ("TabPageRemoved".equals(string)) {
            this.removeChild(this.getEditPartForChild(propertyChangeEvent.getNewValue()));
        } else if ("HComponentAdded".equals(string)) {
            ComponentModel componentModel = (ComponentModel)propertyChangeEvent.getNewValue();
            if (componentModel.isOnRibbonHeader() && componentModel.getOnPageButton() == null) {
                RibbonModel ribbonModel = this.getCastedModel();
                if (ribbonModel.getHeaderComponentCount() == 1) {
                    this.addChild(this.createChild((Object)new RibbonHeaderModel(ribbonModel)), 0);
                } else {
                    RibbonHeaderTreeEditPart ribbonHeaderTreeEditPart = (RibbonHeaderTreeEditPart)this.getChildren().get(0);
                    int n = ribbonModel.getHeaderComponents().indexOf(propertyChangeEvent.getNewValue());
                    ribbonHeaderTreeEditPart.addChild(this.createChild(propertyChangeEvent.getNewValue()), n);
                }
            }
        } else if ("HComponentRemoved".equals(string)) {
            ComponentModel componentModel = (ComponentModel)propertyChangeEvent.getNewValue();
            if (componentModel.isOnRibbonHeader() && componentModel.getOnPageButton() == null) {
                RibbonModel ribbonModel = this.getCastedModel();
                if (ribbonModel.getHeaderComponentCount() == 0) {
                    this.removeChild((EditPart)((AbstractEditPart)this.getChildren().get(0)));
                } else {
                    RibbonHeaderTreeEditPart ribbonHeaderTreeEditPart = (RibbonHeaderTreeEditPart)this.getChildren().get(0);
                    ribbonHeaderTreeEditPart.removeChild(this.getEditPartForChild(propertyChangeEvent.getNewValue()));
                }
            }
        } else if ("Element.UpdateStructure".equals(string)) {
            this.refreshChildren();
        } else {
            this.refreshVisuals();
        }
    }

    public String toString() {
        return this.getCastedModel().toString();
    }

    public ScreenPainterModel getScreenPainterModel() {
        return this.getCastedModel();
    }

    public TabOrderable getTabOrderable() {
        return (TabOrderable)this.getCastedModel().getTarget();
    }

    public void setDisplayedTabOrder(int n) {
    }
}

