/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.parts;

import com.iscobol.screenpainter.model.MenuModel;
import com.iscobol.screenpainter.model.ModelElement;
import com.iscobol.screenpainter.model.ScreenSectionModel;
import com.iscobol.screenpainter.model.StatusbarModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.editparts.AbstractTreeEditPart;
import org.eclipse.swt.graphics.Image;

public class ScreenSectionTreeEditPart
extends AbstractTreeEditPart
implements PropertyChangeListener {
    ScreenSectionTreeEditPart(ScreenSectionModel screenSectionModel) {
        super((Object)screenSectionModel);
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected void createEditPolicies() {
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected Image getImage() {
        return this.getCastedModel().getIcon();
    }

    public String getText() {
        return this.toString();
    }

    private ScreenSectionModel getCastedModel() {
        return (ScreenSectionModel)this.getModel();
    }

    private EditPart getEditPartForChild(Object object) {
        EditPart editPart = (EditPart)this.getViewer().getEditPartRegistry().get(object);
        return editPart;
    }

    protected List getModelChildren() {
        LinkedList<StatusbarModel> linkedList = new LinkedList<StatusbarModel>();
        List list = this.getCastedModel().getMenus();
        linkedList.addAll(this.getCastedModel().getComponents());
        linkedList.addAll(list);
        if (this.getCastedModel().getStatusBar() != null) {
            linkedList.add(this.getCastedModel().getStatusBar());
        }
        return linkedList;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        Object object = propertyChangeEvent.getNewValue();
        ScreenSectionModel screenSectionModel = this.getCastedModel();
        if ("ComponentAdded".equals(string)) {
            if (object instanceof MenuModel) {
                int n = screenSectionModel.getMenus().indexOf(object);
                this.addChild(this.createChild(object), screenSectionModel.getComponents().size() + n);
            } else {
                int n = screenSectionModel.getComponents().indexOf(object);
                this.addChild(this.createChild(object), n);
            }
        } else if ("ComponentRemoved".equals(string)) {
            this.removeChild(this.getEditPartForChild(propertyChangeEvent.getNewValue()));
        } else if ("Element.UpdateStructure".equals(string)) {
            this.refreshChildren();
        } else {
            this.refreshVisuals();
        }
    }

    public String toString() {
        return "Component list";
    }
}

