/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.parts;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.TabOrderable;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.model.ModelElement;
import com.iscobol.screenpainter.model.ScreenPainterModel;
import com.iscobol.screenpainter.model.TabControlModel;
import com.iscobol.screenpainter.model.TabPageModel;
import com.iscobol.screenpainter.model.WindowModel;
import com.iscobol.screenpainter.parts.ComponentEditPart;
import com.iscobol.screenpainter.parts.ScreenPainterMarqueeDragTracker;
import com.iscobol.screenpainter.parts.TabOrderableEditPart;
import com.iscobol.screenpainter.parts.TabbedPaneEditPart;
import com.iscobol.screenpainter.parts.gui.ComponentImageFigure;
import com.iscobol.screenpainter.policies.ComponentXYLayoutEditPolicy;
import com.iscobol.screenpainter.policies.GuideEditPolicy;
import com.iscobol.screenpainter.policies.TabPageDeletionEditPolicy;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.SimpleRaisedBorder;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class TabPageEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
TabOrderableEditPart {
    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public Object getAdapter(Class clazz) {
        SnapToHelper snapToHelper = PluginUtilities.getScreenDesignerSnapToHelper((Class)clazz, (GraphicalEditPart)this);
        if (snapToHelper != null) {
            return snapToHelper;
        }
        return super.getAdapter(clazz);
    }

    protected void createEditPolicies() {
        this.installEditPolicy((Object)"LayoutEditPolicy", (EditPolicy)new ComponentXYLayoutEditPolicy());
        this.installEditPolicy((Object)"ComponentEditPolicy", (EditPolicy)new TabPageDeletionEditPolicy());
        this.installEditPolicy((Object)"Snap Helper Feedback", (EditPolicy)new GuideEditPolicy("iscobolsp.guides.snaptoguides.color"));
    }

    public DragTracker getDragTracker(Request request) {
        if (this.getSelected() != 0) {
            return super.getDragTracker(request);
        }
        return new ScreenPainterMarqueeDragTracker((AbstractGraphicalEditPart)this);
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected IFigure createFigure() {
        ComponentImageFigure componentImageFigure = new ComponentImageFigure((Object)this.getTabOrderable());
        componentImageFigure.setLayoutManager((LayoutManager)new XYLayout());
        componentImageFigure.setBorder((Border)new SimpleRaisedBorder());
        this.updateTabOrder((Figure)componentImageFigure);
        return componentImageFigure;
    }

    protected void updateFigure(Figure figure) {
        this.updateTabOrder(figure);
    }

    boolean isForceShowTabOrder() {
        WindowModel windowModel = this.getCastedModel().getParentWindow();
        return windowModel != null ? windowModel.isForceShowTabOrder() : false;
    }

    private void updateTabOrder(Figure figure) {
        boolean bl = this.isForceShowTabOrder();
        boolean bl2 = bl || IscobolScreenPainterPlugin.getBooleanFromStore((String)"iscobolsp.showtaborder");
        ((ComponentImageFigure)figure).setDisplayedTabOrder(bl2 ? this.getTabOrderable().getTabOrder() : 0);
    }

    public void setSelected(int n) {
        if (n == 2) {
            TabPageEditPart[] tabPageEditPartArray = ComponentEditPart.getAncestorTabPages((EditPart)this);
            for (int i = 0; i < tabPageEditPartArray.length; ++i) {
                tabPageEditPartArray[i].makePageVisible();
            }
            this.makePageVisible();
        }
        super.setSelected(n);
    }

    protected void makePageVisible() {
        TabbedPaneEditPart tabbedPaneEditPart = (TabbedPaneEditPart)this.getParent();
        TabControlModel tabControlModel = (TabControlModel)tabbedPaneEditPart.getModel();
        List list = tabControlModel.getPages();
        int n = list.indexOf(this.getModel());
        if (n >= 0) {
            tabbedPaneEditPart.selectPage(n);
        }
    }

    private TabPageModel getCastedModel() {
        return (TabPageModel)this.getModel();
    }

    protected List getModelChildren() {
        return this.getCastedModel().getComponents();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("ComponentAdded".equals(string) || "ComponentRemoved".equals(string) || "Element.UpdateStructure".equals(string)) {
            this.refreshChildren();
        } else {
            this.refreshVisuals();
            this.updateFigure((Figure)this.getFigure());
            this.getFigure().repaint();
        }
    }

    void refreshBounds() {
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            ComponentEditPart componentEditPart = (ComponentEditPart)listIterator.next();
            componentEditPart.refreshBounds();
        }
    }

    void refreshVarPixelProps(ScreenProgram screenProgram, boolean bl) {
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            ComponentEditPart componentEditPart = (ComponentEditPart)listIterator.next();
            componentEditPart.refreshVarPixelProps(screenProgram, bl, true);
        }
    }

    void setColorConstraint(ColorType colorType) {
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            ComponentEditPart componentEditPart = (ComponentEditPart)listIterator.next();
            componentEditPart.setColorConstraint(colorType);
        }
    }

    void updateUI() {
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            ComponentEditPart componentEditPart = (ComponentEditPart)listIterator.next();
            componentEditPart.updateUI();
        }
    }

    void update() {
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            ComponentEditPart componentEditPart = (ComponentEditPart)listIterator.next();
            componentEditPart.update();
        }
    }

    void updateControlDecorations(String string) {
        ComponentImageFigure componentImageFigure = this.getChildren().listIterator();
        while (componentImageFigure.hasNext()) {
            ComponentEditPart componentEditPart = (ComponentEditPart)componentImageFigure.next();
            componentEditPart.updateControlDecorations(string);
        }
        if ("iscobolsp.showtaborder".equals(string)) {
            boolean bl;
            componentImageFigure = (ComponentImageFigure)this.getFigure();
            TabOrderable tabOrderable = this.getTabOrderable();
            boolean bl2 = this.isForceShowTabOrder();
            boolean bl3 = bl = bl2 || IscobolScreenPainterPlugin.getBooleanFromStore((String)string);
            if (bl) {
                componentImageFigure.setDisplayedTabOrder(tabOrderable.getTabOrder());
            } else {
                componentImageFigure.setDisplayedTabOrder(0);
            }
        }
    }

    void setFontConstraint(FontType fontType) {
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            ComponentEditPart componentEditPart = (ComponentEditPart)listIterator.next();
            componentEditPart.setFontConstraint(fontType);
        }
        this.updateFigure((Figure)this.getFigure());
    }

    protected void refreshVisuals() {
        this.setLayoutConstraint((EditPart)this, this.getFigure(), this.getCastedModel().getTarget());
    }

    public TabOrderable getTabOrderable() {
        return (TabOrderable)this.getCastedModel().getTarget();
    }

    public void setDisplayedTabOrder(int n) {
        ((ComponentImageFigure)this.getFigure()).setDisplayedTabOrder(n);
    }

    public ScreenPainterModel getScreenPainterModel() {
        return this.getCastedModel();
    }
}

