/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.parts;

import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.model.TabControlModel;
import com.iscobol.screenpainter.parts.ComponentEditPart;
import com.iscobol.screenpainter.parts.TabPageEditPart;
import com.iscobol.screenpainter.policies.BaseConstrainedLayoutEditPolicy;
import com.iscobol.screenpainter.policies.TabControlEditPolicy;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.gef.EditPolicy;

public abstract class TabbedPaneEditPart
extends ComponentEditPart {
    protected List getModelChildren() {
        return this.getCastedModel().getPages();
    }

    protected void createEditPolicies() {
        int n;
        switch (this.getCastedModel().getType()) {
            default: {
                n = 302;
                break;
            }
            case 12: {
                n = 303;
                break;
            }
            case 14: {
                n = 305;
            }
        }
        this.installEditPolicy((Object)"ComponentEditPolicy", (EditPolicy)new TabControlEditPolicy(n));
        this.installEditPolicy((Object)"LayoutEditPolicy", (EditPolicy)new BaseConstrainedLayoutEditPolicy());
    }

    public abstract void selectPage(int var1);

    private TabControlModel getCastedModel() {
        return (TabControlModel)this.getModel();
    }

    void setColorConstraint(ColorType colorType) {
        super.setColorConstraint(colorType);
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            TabPageEditPart tabPageEditPart = (TabPageEditPart)listIterator.next();
            tabPageEditPart.setColorConstraint(colorType);
        }
    }

    void updateUI() {
        super.updateUI();
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            TabPageEditPart tabPageEditPart = (TabPageEditPart)listIterator.next();
            tabPageEditPart.updateUI();
        }
    }

    void update() {
        super.update();
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            TabPageEditPart tabPageEditPart = (TabPageEditPart)listIterator.next();
            tabPageEditPart.update();
        }
    }

    void updateControlDecorations(String string) {
        super.updateControlDecorations(string);
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            Object e = listIterator.next();
            if (!(e instanceof TabPageEditPart)) continue;
            ((TabPageEditPart)e).updateControlDecorations(string);
        }
    }

    void setFontConstraint(FontType fontType) {
        super.setFontConstraint(fontType);
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            TabPageEditPart tabPageEditPart = (TabPageEditPart)listIterator.next();
            tabPageEditPart.setFontConstraint(fontType);
        }
    }

    void refreshBounds() {
        super.refreshBounds();
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            TabPageEditPart tabPageEditPart = (TabPageEditPart)listIterator.next();
            tabPageEditPart.refreshBounds();
        }
    }

    void refreshVarPixelProps(ScreenProgram screenProgram, boolean bl, boolean bl2) {
        super.refreshVarPixelProps(screenProgram, bl, bl2);
        if (bl2) {
            ListIterator listIterator = this.getChildren().listIterator();
            while (listIterator.hasNext()) {
                TabPageEditPart tabPageEditPart = (TabPageEditPart)listIterator.next();
                tabPageEditPart.refreshVarPixelProps(screenProgram, bl);
            }
        }
    }
}

