/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.parts;

import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.IToolbar;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.model.IToolbarModel;
import com.iscobol.screenpainter.model.ModelElement;
import com.iscobol.screenpainter.model.ToolbarContainerModel;
import com.iscobol.screenpainter.parts.RibbonEditPart;
import com.iscobol.screenpainter.parts.ToolbarEditPart;
import com.iscobol.screenpainter.policies.ToolbarLayoutEditPolicy;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class ToolbarContainerEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener {
    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected void createEditPolicies() {
        this.installEditPolicy((Object)"LayoutEditPolicy", (EditPolicy)new ToolbarLayoutEditPolicy());
    }

    protected void refreshVisuals() {
        GridData gridData = new GridData(768);
        gridData.heightHint = this.getCastedModel().getHeight();
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)gridData);
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected IFigure createFigure() {
        Panel panel = new Panel();
        panel.setBorder((Border)new MarginBorder(new Insets(0, 0, 0, 0)));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        panel.setLayoutManager((LayoutManager)gridLayout);
        return panel;
    }

    ToolbarContainerModel getCastedModel() {
        return (ToolbarContainerModel)this.getModel();
    }

    protected List getModelChildren() {
        return this.getCastedModel().getToolbars();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("ToolbarAdded".equals(string) || "ToolbarRemoved".equals(string) || "Element.UpdateStructure".equals(string)) {
            this.refreshChildren();
            this.refreshVisuals();
        } else if ("Toolbar.Height".equals(string)) {
            this.refreshVisuals();
        }
    }

    void refreshBounds() {
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            IToolbarModel iToolbarModel = (IToolbarModel)editPart.getModel();
            IToolbar iToolbar = (IToolbar)iToolbarModel.getTarget();
            iToolbarModel.setToolbarHeight(iToolbar.GetLinesPixels());
            if (editPart instanceof ToolbarEditPart) {
                ((ToolbarEditPart)editPart).refreshBounds();
                continue;
            }
            ((RibbonEditPart)editPart).refreshBounds();
        }
    }

    void refreshVarPixelProps(ScreenProgram screenProgram, boolean bl) {
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            if (editPart instanceof ToolbarEditPart) {
                ((ToolbarEditPart)editPart).refreshVarPixelProps(screenProgram, bl, true);
                continue;
            }
            ((RibbonEditPart)editPart).refreshVarPixelProps(screenProgram, bl, true);
        }
    }

    void setColorConstraint(ColorType colorType) {
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            if (editPart instanceof ToolbarEditPart) {
                ((ToolbarEditPart)editPart).setColorConstraint(colorType);
                continue;
            }
            ((RibbonEditPart)editPart).setColorConstraint(colorType);
        }
    }

    void updateUI() {
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            if (editPart instanceof ToolbarEditPart) {
                ((ToolbarEditPart)editPart).updateUI();
                continue;
            }
            ((RibbonEditPart)editPart).updateUI();
        }
    }

    void update() {
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            if (editPart instanceof ToolbarEditPart) {
                ((ToolbarEditPart)editPart).update();
                continue;
            }
            ((RibbonEditPart)editPart).update();
        }
    }

    void updateControlDecorations(String string) {
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            if (editPart instanceof ToolbarEditPart) {
                ((ToolbarEditPart)editPart).updateControlDecorations(string);
                continue;
            }
            ((RibbonEditPart)editPart).updateControlDecorations(string);
        }
    }
}

