/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.parts;

import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.model.ModelElement;
import com.iscobol.screenpainter.model.ScreenPainterModel;
import com.iscobol.screenpainter.model.WindowModel;
import com.iscobol.screenpainter.parts.ScreenDesignerEditPart;
import com.iscobol.screenpainter.parts.ScreenSectionEditPart;
import com.iscobol.screenpainter.parts.ToolbarContainerEditPart;
import com.iscobol.screenpainter.parts.gui.ScreenBorder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class WindowEditPart
extends AbstractGraphicalEditPart
implements PropertyChangeListener,
ScreenDesignerEditPart {
    private ScreenBorder frameBorder = new ScreenBorder();

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            ((ModelElement)this.getModel()).addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected void createEditPolicies() {
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            ((ModelElement)this.getModel()).removePropertyChangeListener((PropertyChangeListener)this);
        }
    }

    protected AbstractBeanWindow getControl() {
        return (AbstractBeanWindow)this.getCastedModel().getTarget();
    }

    protected IFigure createFigure() {
        Figure figure = new Figure();
        this.figure = figure;
        AbstractBeanWindow abstractBeanWindow = this.getControl();
        this.frameBorder.setHasTitleBar(this.hasTitleBar(abstractBeanWindow));
        figure.setBorder((Border)this.frameBorder);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        figure.setLayoutManager((LayoutManager)gridLayout);
        this.refreshBorder();
        return figure;
    }

    private boolean hasTitleBar(AbstractBeanWindow abstractBeanWindow) {
        return abstractBeanWindow.getWindowType().getValue() != 8 && !abstractBeanWindow.isUndecorated() && (abstractBeanWindow.getHasTitleBar() || abstractBeanWindow.getTitle() != null && abstractBeanWindow.getTitle().length() > 0);
    }

    protected void refreshBorder() {
        AbstractBeanWindow abstractBeanWindow = this.getControl();
        this.frameBorder.setHasTitleBar(this.hasTitleBar(abstractBeanWindow));
        this.frameBorder.setLabel(abstractBeanWindow.getTitle() != null ? abstractBeanWindow.getTitle() : "");
        this.getFigure().repaint();
    }

    public WindowModel getCastedModel() {
        return (WindowModel)this.getModel();
    }

    protected List getModelChildren() {
        return Arrays.asList(this.getCastedModel().getToolbarContainer(), this.getCastedModel().getScreenSection());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if ("Component.Size".equals(string) || "Toolbar.Height".equals(string) || "ToolbarAdded".equals(string) || "ToolbarRemoved".equals(string)) {
            this.refreshVisuals();
        } else if ("cell-width".equals(string) || "cell-height".equals(string) || "cell".equals(string) || "cell measure".equals(string) && this.getCastedModel().isCell() || "cell measuring font".equals(string) && this.getCastedModel().isMeasuringControlFont() || "cell measuring control".equals(string) && this.getCastedModel().isMeasuringControlFont() || "cell measuring style".equals(string) && this.getCastedModel().isMeasuringControlFont()) {
            this.refreshBounds();
        } else if ("color".equals(string) || "background-color".equals(string) || "foreground-color".equals(string)) {
            this.setColorConstraint((ColorType)propertyChangeEvent.getNewValue());
        } else if ("background intensity".equals(string)) {
            AbstractBeanWindow abstractBeanWindow;
            ColorType colorType;
            int n = (Integer)propertyChangeEvent.getNewValue();
            if (!(n != 1 && n != 2 || (colorType = (ColorType)(abstractBeanWindow = (AbstractBeanWindow)this.getCastedModel().getTarget()).getColor().clone()) == null || colorType.isDisabled())) {
                if (n == 1) {
                    colorType.setBackHigh(true);
                } else {
                    colorType.setBackLow(true);
                }
                this.setColorConstraint(colorType);
            }
        } else if ("unit".equals(string)) {
            this.refreshVarPixelProps();
        } else if ("control font".equals(string)) {
            if (!this.getCastedModel().isCell()) {
                this.refreshBounds();
            }
            this.setFontConstraint((FontType)propertyChangeEvent.getNewValue());
        } else if ("iscobolsp.updateui".equals(string)) {
            this.updateUI();
            this.refreshVisuals();
            this.refreshBorder();
        } else if ("iscobolsp.update".equals(string)) {
            this.update();
            this.refreshVisuals();
        } else if ("iscobolsp.updatescreen".equals(string)) {
            this.refreshBounds();
            this.refreshVarPixelProps();
            AbstractBeanWindow abstractBeanWindow = (AbstractBeanWindow)this.getCastedModel().getTarget();
            this.setColorConstraint(abstractBeanWindow.getColor());
            this.setFontConstraint(abstractBeanWindow.getFont());
        } else if ("iscobolsp.showcontrolid".equals(string) || "iscobolsp.showtaborder".equals(string) || "iscobolsp.showlockedicon".equals(string)) {
            this.updateControlDecorations(string);
            this.refreshVisuals();
        } else {
            if ("lock".equals(string)) {
                this.updateLock();
            }
            this.refreshVisuals();
            this.refreshBorder();
        }
    }

    void updateLock() {
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            if (!(editPart instanceof ScreenSectionEditPart)) continue;
            ((ScreenSectionEditPart)editPart).updateLock(this.getControl().isLock());
        }
    }

    void refreshVarPixelProps() {
        AbstractBeanWindow abstractBeanWindow = (AbstractBeanWindow)this.getCastedModel().getTarget();
        boolean bl = abstractBeanWindow.getUnit().getValue() == 1;
        ScreenProgram screenProgram = this.getCastedModel().getParentWindow().getScreenProgram();
        this.refreshVarPixelProps(abstractBeanWindow, screenProgram, bl);
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            if (editPart instanceof ScreenSectionEditPart) {
                ((ScreenSectionEditPart)editPart).refreshVarPixelProps(screenProgram, bl);
                continue;
            }
            if (!(editPart instanceof ToolbarContainerEditPart)) continue;
            ((ToolbarContainerEditPart)editPart).refreshVarPixelProps(screenProgram, bl);
        }
    }

    public ScreenSectionEditPart getScreenSectionEditPart() {
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            if (!(editPart instanceof ScreenSectionEditPart)) continue;
            return (ScreenSectionEditPart)editPart;
        }
        return null;
    }

    public ToolbarContainerEditPart getToolbarContainerEditPart() {
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            if (!(editPart instanceof ToolbarContainerEditPart)) continue;
            return (ToolbarContainerEditPart)editPart;
        }
        return null;
    }

    void refreshVarPixelProps(AbstractBeanWindow abstractBeanWindow, ScreenProgram screenProgram, boolean bl) {
        VariableType variableType;
        if (abstractBeanWindow.getLinesVariable() != null && (variableType = screenProgram.getProgramVariable(abstractBeanWindow.getLinesVariable())) != null && !variableType.isExtVar() && variableType.getLevelAsInt() != 78) {
            variableType.setValue(bl ? Integer.toString(abstractBeanWindow.getLinesPixels()) : Float.toString(abstractBeanWindow.getLines()));
        }
        if (abstractBeanWindow.getSizeVariable() != null && (variableType = screenProgram.getProgramVariable(abstractBeanWindow.getSizeVariable())) != null && !variableType.isExtVar() && variableType.getLevelAsInt() != 78) {
            variableType.setValue(bl ? Integer.toString(abstractBeanWindow.getSizePixels()) : Float.toHexString(abstractBeanWindow.getSize()));
        }
    }

    void refreshBounds() {
        AbstractBeanWindow abstractBeanWindow = (AbstractBeanWindow)this.getCastedModel().getTarget();
        this.getCastedModel().setScreenSize(new Dimension(abstractBeanWindow.getSizePixels(), abstractBeanWindow.getLinesPixels()));
        this.refreshVarPixelProps(abstractBeanWindow, this.getCastedModel().getParentWindow().getScreenProgram(), this.getCastedModel().isUnitPixel());
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            if (editPart instanceof ScreenSectionEditPart) {
                ((ScreenSectionEditPart)editPart).refreshBounds();
                continue;
            }
            if (!(editPart instanceof ToolbarContainerEditPart)) continue;
            ((ToolbarContainerEditPart)editPart).refreshBounds();
        }
    }

    void setColorConstraint(ColorType colorType) {
        AbstractBeanWindow abstractBeanWindow = (AbstractBeanWindow)this.getCastedModel().getTarget();
        this.getCastedModel().setScreenSize(new Dimension(abstractBeanWindow.getSizePixels(), abstractBeanWindow.getLinesPixels()));
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            if (editPart instanceof ScreenSectionEditPart) {
                ((ScreenSectionEditPart)editPart).setColorConstraint(colorType);
                continue;
            }
            if (!(editPart instanceof ToolbarContainerEditPart)) continue;
            ((ToolbarContainerEditPart)editPart).setColorConstraint(colorType);
        }
    }

    void updateUI() {
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            if (editPart instanceof ScreenSectionEditPart) {
                ((ScreenSectionEditPart)editPart).updateUI();
                continue;
            }
            if (!(editPart instanceof ToolbarContainerEditPart)) continue;
            ((ToolbarContainerEditPart)editPart).updateUI();
        }
    }

    void update() {
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            if (editPart instanceof ScreenSectionEditPart) {
                ((ScreenSectionEditPart)editPart).update();
                continue;
            }
            if (!(editPart instanceof ToolbarContainerEditPart)) continue;
            ((ToolbarContainerEditPart)editPart).update();
        }
    }

    void updateControlDecorations(String string) {
        if ("iscobolsp.showlockedicon".equals(string)) {
            this.updateLock();
        }
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            if (editPart instanceof ScreenSectionEditPart) {
                ((ScreenSectionEditPart)editPart).updateControlDecorations(string);
                continue;
            }
            if (!(editPart instanceof ToolbarContainerEditPart)) continue;
            ((ToolbarContainerEditPart)editPart).updateControlDecorations(string);
        }
    }

    void setFontConstraint(FontType fontType) {
        AbstractBeanWindow abstractBeanWindow = (AbstractBeanWindow)this.getCastedModel().getTarget();
        this.getCastedModel().setScreenSize(new Dimension(abstractBeanWindow.getSizePixels(), abstractBeanWindow.getLinesPixels()));
        ListIterator listIterator = this.getChildren().listIterator();
        while (listIterator.hasNext()) {
            EditPart editPart = (EditPart)listIterator.next();
            if (!(editPart instanceof ScreenSectionEditPart)) continue;
            ((ScreenSectionEditPart)editPart).setFontConstraint(fontType);
        }
    }

    protected void refreshVisuals() {
        WindowModel windowModel = this.getCastedModel();
        Dimension dimension = windowModel.getScreenSize();
        dimension.height += windowModel.getToolbarContainer().getHeight();
        dimension.height += windowModel.getHeightInset();
        dimension.width += windowModel.getWidthInset();
        ((GraphicalEditPart)this.getParent()).setLayoutConstraint((EditPart)this, this.getFigure(), (Object)new Rectangle(windowModel.getLocation(), dimension));
    }

    public ScreenPainterModel getScreenPainterModel() {
        return this.getCastedModel();
    }
}

