/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.parts.gui;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.beans.AbstractFrame;
import com.iscobol.screenpainter.beans.IscobolBeanConstants;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.parts.gui.ComponentImageFigure;
import com.iscobol.screenpainter.util.ColorPalette;
import com.iscobol.screenpainter.util.ColorProvider;
import java.awt.Color;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.RGB;

public class BorderedFrameFigure
extends ComponentImageFigure {
    static final int STYLE_VERTICAL = 9;
    static final int STYLE_HORIZONTAL = 10;
    static final int STYLE_BOX = 11;
    static final int STYLE_3D_NORMAL = 0;
    static final int STYLE_3D_RAISED = 4;
    static final int STYLE_3D_LOWERED = 5;
    static final int STYLE_3D_ENGRAVED = 6;
    static final int STYLE_3D_RIMMED = 7;
    static final int TITLE_TOP_LEFT = 1;
    static final int TITLE_TOP_CENTER = 2;
    static final int TITLE_TOP_RIGHT = 3;
    static final int TITLE_BOTTOM_LEFT = 4;
    static final int TITLE_BOTTOM_CENTER = 5;
    static final int TITLE_BOTTOM_RIGHT = 6;
    static final int TITLE_FULL_CENTER = 7;
    private AbstractFrame frame;
    private Font font;

    public BorderedFrameFigure(AbstractFrame abstractFrame) {
        super((Object)abstractFrame);
        this.frame = abstractFrame;
    }

    public Font getFrameFont() {
        return this.font;
    }

    public void setFrameFont(Font font) {
        this.font = font;
    }

    boolean hasFillColors() {
        ForegroundColorType foregroundColorType = this.frame.getFillColor();
        if (foregroundColorType != null && foregroundColorType.getForegroundColor(this.frame.getPalette()) != null) {
            return true;
        }
        foregroundColorType = this.frame.getFillColor2();
        return foregroundColorType != null && foregroundColorType.getForegroundColor(this.frame.getPalette()) != null;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.hasFillColors()) {
            this.paintFrame(graphics);
        }
    }

    public void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.hasFillColors()) {
            this.paintFrame(graphics);
        }
        super.paintDecorations(graphics);
    }

    protected void paintDecorations(Graphics graphics) {
    }

    private void paintFrame(Graphics graphics) {
        int n;
        int n2;
        ColorProvider colorProvider = IscobolScreenPainterPlugin.getDefault().getColorProvider();
        ColorPalette colorPalette = this.frame.getPalette();
        Color color = this.frame.getComponent().getForeground();
        org.eclipse.swt.graphics.Color color2 = colorProvider.getColor(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
        color = this.frame.getComponent().getBackground();
        org.eclipse.swt.graphics.Color color3 = colorProvider.getColor(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
        org.eclipse.swt.graphics.Color color4 = color2;
        Rectangle rectangle = this.getBounds();
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n3 = fontMetrics.getHeight();
        int n4 = 0;
        int n5 = rectangle.width - n4 - 1;
        int n6 = this.frame.getTitlePosition().getValue();
        boolean bl = this.frame.isFullHeight() || n6 == 7;
        int n7 = bl ? 1 : 1 + n3 / 2;
        switch (n6) {
            default: {
                n2 = n7 - 1;
                n = rectangle.height - n2 - 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 1;
                n = rectangle.height - n2 - n7;
            }
        }
        Rectangle rectangle2 = null;
        Rectangle rectangle3 = null;
        int n8 = this.frame.getFillPercent().getValue();
        if (n8 < 100) {
            if (n8 > 0) {
                int n9;
                if (n > n5) {
                    n9 = n * (100 - n8) / 100;
                    rectangle2 = new Rectangle(rectangle.x + n4, rectangle.y + n2 + n9, n5, n - n9);
                    rectangle3 = new Rectangle(rectangle.x + n4, rectangle.y + n2, n5, n9);
                } else {
                    n9 = n5 * n8 / 100;
                    rectangle2 = new Rectangle(rectangle.x + n4, rectangle.y + n2, n9, n);
                    rectangle3 = new Rectangle(rectangle.x + n4 + n9, rectangle.y + n2, n5 - n9, n);
                }
            } else {
                rectangle3 = new Rectangle(rectangle.x + n4, rectangle.y + n2, n5, n);
            }
        } else {
            rectangle2 = new Rectangle(rectangle.x + n4, rectangle.y + n2, n5, n);
        }
        org.eclipse.swt.graphics.Color color5 = null;
        ForegroundColorType foregroundColorType = this.frame.getFillColor();
        if (foregroundColorType != null && (color = foregroundColorType.getForegroundColor(colorPalette)) != null) {
            color5 = colorProvider.getColor(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
        }
        if (color5 != null && rectangle2 != null) {
            graphics.setBackgroundColor(color5);
            graphics.fillRectangle(rectangle2);
        }
        org.eclipse.swt.graphics.Color color6 = null;
        foregroundColorType = this.frame.getFillColor2();
        if (foregroundColorType != null && (color = foregroundColorType.getForegroundColor(colorPalette)) != null) {
            color6 = colorProvider.getColor(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
        }
        if (color6 != null && rectangle3 != null) {
            graphics.setBackgroundColor(color6);
            graphics.fillRectangle(rectangle3);
        }
        int n10 = 0;
        if (this.frame.isHeavy()) {
            n10 = 1;
        } else if (this.frame.isVeryHeavy()) {
            n10 = 2;
        }
        org.eclipse.swt.graphics.Color color7 = ColorConstants.gray;
        foregroundColorType = this.frame.getLowColor();
        if (foregroundColorType != null && (color = foregroundColorType.getForegroundColor(colorPalette)) != null) {
            color7 = colorProvider.getColor(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
        }
        org.eclipse.swt.graphics.Color color8 = ColorConstants.white;
        foregroundColorType = this.frame.getHighColor();
        if (foregroundColorType != null && (color = foregroundColorType.getForegroundColor(colorPalette)) != null) {
            color8 = colorProvider.getColor(new RGB(color.getRed(), color.getGreen(), color.getBlue()));
        }
        Rectangle rectangle4 = this.frame.isTransparent() ? this.drawTitle(graphics, fontMetrics, n3, n6, color4, color3) : null;
        if (this.frame.isRaised()) {
            for (int i = 0; i <= n10; ++i) {
                if (this.frame.isAlternate() && i != 0 && i != n10) continue;
                graphics.setForegroundColor(color7);
                this.drawLine(graphics, rectangle4, rectangle.x + n4 + i, rectangle.y + n2 + n - i, rectangle.x + n4 + n5 - i, rectangle.y + n2 + n - i);
                this.drawLine(graphics, rectangle4, rectangle.x + n4 + n5 - i, rectangle.y + n2 + i, rectangle.x + n4 + n5 - i, rectangle.y + n2 + n - i);
                graphics.setForegroundColor(color8);
                this.drawLine(graphics, rectangle4, rectangle.x + n4 + i, rectangle.y + n2 + i, rectangle.x + n4 + n5 - i, rectangle.y + n2 + i);
                this.drawLine(graphics, rectangle4, rectangle.x + n4 + i, rectangle.y + n2 + i, rectangle.x + n4 + i, rectangle.y + n2 + n - i);
            }
        } else if (this.frame.isLowered()) {
            for (int i = 0; i <= n10; ++i) {
                if (this.frame.isAlternate() && i != 0 && i != n10) continue;
                graphics.setForegroundColor(color8);
                this.drawLine(graphics, rectangle4, rectangle.x + n4 + i, rectangle.y + n2 + n - i, rectangle.x + n4 + n5 - i, rectangle.y + n2 + n - i);
                this.drawLine(graphics, rectangle4, rectangle.x + n4 + n5 - i, rectangle.y + n2 + i, rectangle.x + n4 + n5 - i, rectangle.y + n2 + n - i);
                graphics.setForegroundColor(color7);
                this.drawLine(graphics, rectangle4, rectangle.x + n4 + i, rectangle.y + n2 + i, rectangle.x + n4 + n5 - i, rectangle.y + n2 + i);
                this.drawLine(graphics, rectangle4, rectangle.x + n4 + i, rectangle.y + n2 + i, rectangle.x + n4 + i, rectangle.y + n2 + n - i);
            }
        } else if (this.frame.isEngraved()) {
            int n11 = 0;
            graphics.setForegroundColor(color7);
            this.drawLine(graphics, rectangle4, rectangle.x + n4 + n11, rectangle.y + n2 + n11, rectangle.x + n4 + n5 - n11, rectangle.y + n2 + n11);
            this.drawLine(graphics, rectangle4, rectangle.x + n4 + n11, rectangle.y + n2 + n11, rectangle.x + n4 + n11, rectangle.y + n2 + n - n11);
            graphics.setForegroundColor(color8);
            this.drawLine(graphics, rectangle4, rectangle.x + n4 + n11, rectangle.y + n2 + n - n11, rectangle.x + n4 + n5 - n11, rectangle.y + n2 + n - n11);
            this.drawLine(graphics, rectangle4, rectangle.x + n4 + n5 - n11, rectangle.y + n2 + n11, rectangle.x + n4 + n5 - n11, rectangle.y + n2 + n - n11);
            n11 = n10 + 1;
            graphics.setForegroundColor(color7);
            this.drawLine(graphics, rectangle4, rectangle.x + n4 + n11, rectangle.y + n2 + n - n11, rectangle.x + n4 + n5 - n11, rectangle.y + n2 + n - n11);
            this.drawLine(graphics, rectangle4, rectangle.x + n4 + n5 - n11, rectangle.y + n2 + n11, rectangle.x + n4 + n5 - n11, rectangle.y + n2 + n - n11);
            graphics.setForegroundColor(color8);
            this.drawLine(graphics, rectangle4, rectangle.x + n4 + n11, rectangle.y + n2 + n11, rectangle.x + n4 + n5 - n11, rectangle.y + n2 + n11);
            this.drawLine(graphics, rectangle4, rectangle.x + n4 + n11, rectangle.y + n2 + n11, rectangle.x + n4 + n11, rectangle.y + n2 + n - n11);
            if (this.frame.isAlternate()) {
                graphics.setForegroundColor(color4);
                for (n11 = 1; n11 < n10 + 1; ++n11) {
                    this.drawRectangle(graphics, rectangle4, rectangle.x + n4 + n11, rectangle.y + n2 + n11, n5 - (n11 << 1), n - (n11 << 1));
                }
            }
        } else if (this.frame.isRimmed()) {
            int n12 = 0;
            graphics.setForegroundColor(color8);
            this.drawLine(graphics, rectangle4, rectangle.x + n4 + n12, rectangle.y + n2 + n12, rectangle.x + n4 + n5 - n12, rectangle.y + n2 + n12);
            this.drawLine(graphics, rectangle4, rectangle.x + n4 + n12, rectangle.y + n2 + n12, rectangle.x + n4 + n12, rectangle.y + n2 + n - n12);
            graphics.setForegroundColor(color7);
            this.drawLine(graphics, rectangle4, rectangle.x + n4 + n12, rectangle.y + n2 + n - n12, rectangle.x + n4 + n5 - n12, rectangle.y + n2 + n - n12);
            this.drawLine(graphics, rectangle4, rectangle.x + n4 + n5 - n12, rectangle.y + n2 + n12, rectangle.x + n4 + n5 - n12, rectangle.y + n2 + n - n12);
            n12 = n10 + 1;
            graphics.setForegroundColor(color8);
            this.drawLine(graphics, rectangle4, rectangle.x + n4 + n12, rectangle.y + n2 + n - n12, rectangle.x + n4 + n5 - n12, rectangle.y + n2 + n - n12);
            this.drawLine(graphics, rectangle4, rectangle.x + n4 + n5 - n12, rectangle.y + n2 + n12, rectangle.x + n4 + n5 - n12, rectangle.y + n2 + n - n12);
            graphics.setForegroundColor(color7);
            this.drawLine(graphics, rectangle4, rectangle.x + n4 + n12, rectangle.y + n2 + n12, rectangle.x + n4 + n5 - n12, rectangle.y + n2 + n12);
            this.drawLine(graphics, rectangle4, rectangle.x + n4 + n12, rectangle.y + n2 + n12, rectangle.x + n4 + n12, rectangle.y + n2 + n - n12);
            if (this.frame.isAlternate()) {
                graphics.setForegroundColor(color4);
                for (n12 = 1; n12 < n10 + 1; ++n12) {
                    this.drawRectangle(graphics, rectangle4, rectangle.x + n4 + n12, rectangle.y + n2 + n12, n5 - (n12 << 1), n - (n12 << 1));
                }
            }
        } else {
            graphics.setForegroundColor(color4);
            for (int i = 0; i <= n10; ++i) {
                if (this.frame.isAlternate() && i != 0 && i != n10) continue;
                this.drawRectangle(graphics, rectangle4, rectangle.x + n4 + i, rectangle.y + n2 + i, n5 - (i << 1), n - (i << 1));
            }
        }
        if (!this.frame.isTransparent()) {
            this.drawTitle(graphics, fontMetrics, n3, n6, color4, color3);
            super.paintDecorations(graphics);
        }
    }

    private Rectangle drawTitle(Graphics graphics, FontMetrics fontMetrics, int n, int n2, org.eclipse.swt.graphics.Color color, org.eclipse.swt.graphics.Color color2) {
        Rectangle rectangle = null;
        if (this.frame.getTitle() != null && this.frame.getTitle().length() > 0) {
            int n3;
            int n4;
            int n5 = 10;
            StringBuilder stringBuilder = new StringBuilder(this.frame.getTitle());
            int n6 = IscobolBeanConstants.getMnemonicIdx((StringBuilder)stringBuilder);
            String string = " " + stringBuilder + " ";
            int n7 = fontMetrics.getAverageCharWidth() * string.length() + 1;
            int n8 = fontMetrics.getDescent() + fontMetrics.getAscent();
            switch (n2) {
                default: {
                    n4 = n5 - 1;
                    n3 = n - n8;
                    break;
                }
                case 2: {
                    n4 = this.bounds.width / 2 - n7 / 2 - 1;
                    n3 = n - n8;
                    break;
                }
                case 3: {
                    n4 = this.bounds.width - n7 - n5 - 1;
                    n3 = n - n8;
                    break;
                }
                case 4: {
                    n4 = n5 - 1;
                    n3 = this.bounds.height - n8;
                    break;
                }
                case 5: {
                    n4 = this.bounds.width / 2 - n7 / 2 - 1;
                    n3 = this.bounds.height - n8;
                    break;
                }
                case 6: {
                    n4 = this.bounds.width - n7 - n5 - 1;
                    n3 = this.bounds.height - n8;
                    break;
                }
                case 7: {
                    n4 = this.bounds.width / 2 - n7 / 2 - 1;
                    n3 = this.bounds.height / 2 - n / 2 - 1;
                }
            }
            rectangle = new Rectangle(this.bounds.x + n4, this.bounds.y + n3 - n + n8, n7, n);
            if (n2 != 7 && !this.frame.isTransparent()) {
                graphics.setBackgroundColor(color2);
                graphics.fillRectangle(this.bounds.x + n4, this.bounds.y + n3 - n + n8, n7, n);
            }
            graphics.setForegroundColor(color);
            graphics.drawString(string, this.bounds.x + n4, this.bounds.y + n3);
            if (n6 >= 0) {
                int n9 = n4 + fontMetrics.getAverageCharWidth() * string.substring(0, n6).length();
                graphics.drawLine(this.bounds.x + n9, this.bounds.y + n3 + 2, this.bounds.x + n9 + fontMetrics.getAverageCharWidth(), this.bounds.y + n3 + 2);
            }
        }
        return rectangle;
    }

    private void drawRectangle(Graphics graphics, Rectangle rectangle, int n, int n2, int n3, int n4) {
        if (rectangle != null) {
            this.drawLine(graphics, rectangle, n, n2, n + n3 - 1, n2);
            this.drawLine(graphics, rectangle, n, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
            this.drawLine(graphics, rectangle, n, n2 + 1, n, n2 + n4 - 2);
            this.drawLine(graphics, rectangle, n + n3 - 1, n2 + 1, n + n3 - 1, n2 + n4 - 2);
        } else {
            graphics.drawRectangle(n, n2, n3, n4);
        }
    }

    private void drawLine(Graphics graphics, Rectangle rectangle, int n, int n2, int n3, int n4) {
        Rectangle rectangle2 = rectangle != null ? rectangle.getIntersection(new Rectangle(n, n2, n3 - n + 1, n4 - n2 + 1)) : null;
        if (rectangle2 != null && !rectangle2.isEmpty()) {
            if (n == n3) {
                graphics.drawLine(n, n2, n3, rectangle2.y - 1);
                graphics.drawLine(n, rectangle2.y + rectangle2.height, n3, n4);
            } else {
                graphics.drawLine(n, n2, rectangle2.x - 1, n4);
                graphics.drawLine(rectangle2.x + rectangle2.width, n2, n3, n4);
            }
        } else {
            graphics.drawLine(n, n2, n3, n4);
        }
    }
}

