/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.parts.gui;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.TabOrderable;
import com.iscobol.screenpainter.parts.gui.ComponentImageFigure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.ImageFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.Image;

public class ComponentImageFigure
extends ImageFigure {
    private static final int MIN_NUM_WIDTH = 5;
    private static final int MIN_NUM_HEIGHT = 5;
    private static final int PAD = 10;
    private int displayedTabOrder;
    private String displayedId;
    private boolean displayedLocked;
    private boolean wd2Unsupported;
    private Dimension origSize;
    private FontMetrics fm;
    private TooltipFigure tooltip;
    private Object target;
    private static final Font controlNumberFont = IscobolScreenPainterPlugin.getDefault().getFontProvider().getFont(new FontData("Courier New", 8, 1));

    public ComponentImageFigure(Object object) {
        this(object, false);
    }

    public ComponentImageFigure(Object object, boolean bl) {
        this.target = object;
        this.wd2Unsupported = bl;
        this.setAlignment(1);
        this.tooltip = new TooltipFigure(this);
        this.setToolTip((IFigure)this.tooltip);
        this.updateTooltip();
    }

    public int getDisplayedTabOrder() {
        return this.displayedTabOrder;
    }

    public void setDisplayedTabOrder(int n) {
        this.displayedTabOrder = n;
        this.updateTooltip();
        this.repaint();
    }

    public String getDisplayedId() {
        return this.displayedId;
    }

    public void setDisplayedId(String string) {
        this.displayedId = string;
        this.updateTooltip();
        this.repaint();
    }

    public boolean getDisplayedLocked() {
        return this.displayedLocked;
    }

    public void setDisplayedLocked(boolean bl) {
        this.displayedLocked = bl;
        this.repaint();
    }

    private void updateTooltip() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.target instanceof TabOrderable) {
            stringBuilder.append("Tab Order = ");
            stringBuilder.append(((TabOrderable)this.target).getTabOrder());
            if (this.target instanceof AbstractBeanControl) {
                AbstractBeanControl abstractBeanControl = (AbstractBeanControl)this.target;
                String string = abstractBeanControl.getIdVariable();
                if (string == null || string.length() == 0) {
                    string = Integer.toString(abstractBeanControl.getId());
                }
                stringBuilder.append(", ID = ");
                stringBuilder.append(string);
            }
        }
        this.tooltip.setMessage(stringBuilder.length() > 0 ? stringBuilder.toString() : null);
    }

    public void paintFigure(Graphics graphics) {
        if (this.wd2Unsupported) {
            Rectangle rectangle = this.getBounds();
            graphics.fillRectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.drawString("WD2 unsupported", rectangle.x, rectangle.y);
        } else {
            super.paintFigure(graphics);
            this.paintDecorations(graphics);
        }
    }

    protected void paintDecorations(Graphics graphics) {
        graphics.setFont(controlNumberFont);
        this.fm = graphics.getFontMetrics();
        int[] nArray = this.adjustSize(this.getBounds());
        if (this.displayedTabOrder > 0) {
            this.paintTabOrder(graphics, nArray);
        }
        if (this.displayedId != null) {
            this.paintControlId(graphics, nArray);
        }
        if (this.displayedLocked) {
            this.paintLocked(graphics, nArray);
        }
    }

    protected void paintLocked(Graphics graphics, int[] nArray) {
        if (this.displayedLocked) {
            Point point = this.getLocation();
            Dimension dimension = this.getSize();
            Image image = IscobolScreenPainterPlugin.getDefault().getImageProvider().lockedImage;
            graphics.drawImage(image, point.x, point.y + dimension.height - image.getBounds().height);
        }
    }

    protected void paintTabOrder(Graphics graphics, int[] nArray) {
        if (this.displayedTabOrder > 0) {
            String string = Integer.toString(this.displayedTabOrder);
            graphics.setBackgroundColor(IscobolScreenPainterPlugin.getColorFromStore((String)"iscobolsp.showtaborderbg"));
            graphics.setForegroundColor(IscobolScreenPainterPlugin.getColorFromStore((String)"iscobolsp.showtaborderfg"));
            Point point = this.getLocation();
            Dimension dimension = this.getSize();
            int n = nArray[0] + 10;
            int n2 = nArray[0] + nArray[1] + 20 - dimension.width;
            if (n2 > 0) {
                n -= n2 / 2;
                n = Math.max(5, n);
                if (nArray[1] > 0 && (n2 = 5 - dimension.width + n) > 0) {
                    n -= n2;
                }
            }
            int n3 = Math.min(nArray[0] + 10, n);
            int n4 = Math.min(dimension.height, nArray[nArray.length - 1]);
            graphics.fillRectangle(point.x, point.y, n3, n4);
            graphics.drawString(string, point.x + 5, point.y);
        }
    }

    protected void paintControlId(Graphics graphics, int[] nArray) {
        if (this.displayedId != null) {
            String string = this.displayedId;
            graphics.setBackgroundColor(IscobolScreenPainterPlugin.getColorFromStore((String)"iscobolsp.showcontrolidbg"));
            graphics.setForegroundColor(IscobolScreenPainterPlugin.getColorFromStore((String)"iscobolsp.showcontrolidfg"));
            Point point = this.getLocation();
            Dimension dimension = this.getSize();
            int n = nArray[1] + 10;
            int n2 = nArray[0] + nArray[1] + 20 - dimension.width;
            if (n2 > 0) {
                n -= n2 / 2;
                n = Math.max(5, n);
                if (nArray[0] > 0 && (n2 = 5 - dimension.width + n) > 0) {
                    n -= n2;
                }
            }
            int n3 = Math.min(nArray[1] + 10, n);
            int n4 = point.x + dimension.width - n3;
            int n5 = Math.min(dimension.height, nArray[nArray.length - 1]);
            graphics.fillRectangle(n4, point.y, n3, n5);
            graphics.drawString(string, n4 + 5, point.y);
        }
    }

    private int[] adjustSize(Rectangle rectangle) {
        String string;
        int[] nArray = new int[4];
        int n = 0;
        int n2 = 0;
        if (this.displayedTabOrder > 0) {
            string = Integer.toString(this.displayedTabOrder);
            nArray[0] = string.length() * this.fm.getAverageCharWidth();
            n += 5;
            n2 = 5;
        }
        if (this.displayedId != null) {
            nArray[1] = this.displayedId.length() * this.fm.getAverageCharWidth();
            n += 5;
            n2 = 5;
        }
        if (this.displayedLocked) {
            nArray[2] = 1;
            n = Math.max(5, n);
            n2 += 5;
        }
        nArray[3] = this.fm.getHeight();
        string = new Rectangle(rectangle);
        if (this.origSize != null) {
            rectangle.setSize(this.origSize);
        }
        rectangle.width = Math.max(n, rectangle.width);
        rectangle.height = Math.max(n2, rectangle.height);
        super.setBounds(rectangle);
        if (!string.getSize().equals((Object)rectangle.getSize())) {
            this.invalidate();
            this.fireFigureMoved();
            this.repaint();
        }
        return nArray;
    }

    public void setBounds(Rectangle rectangle) {
        this.origSize = rectangle.getSize();
        if (this.fm != null) {
            this.adjustSize(rectangle);
        } else {
            super.setBounds(rectangle);
        }
    }
}

