/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.parts.gui;

import com.iscobol.screenpainter.beans.TabPage;
import com.iscobol.screenpainter.beans.types.TabOrientation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.geometry.Rectangle;

public class TabControlLayout
extends StackLayout {
    private int margin;
    private TabOrientation tOrientation = new TabOrientation(0);
    private TabPage selectedPage;
    private Map<IFigure, Object> constraints = new HashMap();

    public void layout(IFigure iFigure) {
        Rectangle rectangle = iFigure.getClientArea();
        switch (this.tOrientation.getValue()) {
            case 0: {
                rectangle.y += this.margin;
                rectangle.height -= this.margin;
                break;
            }
            case 3: {
                rectangle.height -= this.margin;
                break;
            }
            case 1: {
                rectangle.x += this.margin;
                rectangle.width -= this.margin;
                break;
            }
            case 2: {
                rectangle.width -= this.margin;
            }
        }
        List list = iFigure.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            IFigure iFigure2 = (IFigure)list.get(i);
            Rectangle rectangle2 = rectangle;
            if (this.selectedPage != null) {
                Object object = this.getConstraint(iFigure2);
                if (object instanceof Rectangle) {
                    iFigure2.setVisible(true);
                    rectangle2 = (Rectangle)object;
                } else if (object == this.selectedPage) {
                    iFigure2.setVisible(true);
                } else {
                    iFigure2.setVisible(false);
                }
            } else {
                iFigure2.setVisible(true);
            }
            iFigure2.setBounds(rectangle2);
        }
    }

    public Object getConstraint(IFigure iFigure) {
        return this.constraints.get(iFigure);
    }

    public void setConstraint(IFigure iFigure, Object object) {
        if (object != null) {
            this.constraints.put(iFigure, object);
        }
    }

    public TabPage getSelectedPage() {
        return this.selectedPage;
    }

    public void setSelectedPage(TabPage tabPage) {
        this.selectedPage = tabPage;
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int n) {
        this.margin = n;
    }

    public TabOrientation getTabOrientation() {
        return this.tOrientation;
    }

    public void setTabOrientation(TabOrientation tabOrientation) {
        this.tOrientation = tabOrientation;
    }
}

