/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.policies;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import java.util.Map;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.GraphicalEditPolicy;
import org.eclipse.swt.graphics.Color;

public class GuideEditPolicy
extends GraphicalEditPolicy {
    private IFigure[] guide = new IFigure[2];
    private Integer[] location = new Integer[2];
    private String guideColorProp;

    public GuideEditPolicy(String string) {
        this.guideColorProp = string;
    }

    public void eraseTargetFeedback(Request request) {
        for (int i = 0; i < this.guide.length; ++i) {
            if (this.guide[i] != null) {
                this.removeFeedback(this.guide[i]);
            }
            this.guide[i] = null;
            this.location[i] = null;
        }
    }

    void highlightGuide(Integer n, Color color, int n2) {
        if (n == null) {
            if (this.guide[n2] != null) {
                this.removeFeedback(this.guide[n2]);
                this.guide[n2] = null;
            }
            this.location[n2] = n;
            return;
        }
        int n3 = n;
        PrecisionPoint precisionPoint = new PrecisionPoint(n3, n3);
        IFigure iFigure = ((GraphicalEditPart)this.getHost()).getContentPane();
        iFigure.translateToParent((Translatable)precisionPoint);
        iFigure.translateToAbsolute((Translatable)precisionPoint);
        if (this.location[n2] == null || !this.location[n2].equals(n)) {
            this.location[n2] = n;
            if (this.guide[n2] != null) {
                this.removeFeedback(this.guide[n2]);
                this.guide[n2] = null;
            }
            Figure figure = new Figure();
            figure.setBackgroundColor(color);
            figure.setOpaque(true);
            this.guide[n2] = figure;
            this.addFeedback((IFigure)figure);
            figure.translateToRelative((Translatable)precisionPoint);
            n3 = n2 % 2 == 0 ? (int)Math.round(precisionPoint.preciseX()) : (int)Math.round(precisionPoint.preciseY());
            Rectangle rectangle = this.getFeedbackLayer().getBounds().getCopy();
            if (n2 % 2 == 1) {
                rectangle.height = 1;
                rectangle.y = n3;
            } else {
                rectangle.x = n3;
                rectangle.width = 1;
            }
            figure.setBounds(rectangle);
        } else {
            IFigure iFigure2 = this.guide[n2];
            Rectangle rectangle = iFigure2.getBounds().getCopy();
            Rectangle rectangle2 = this.getFeedbackLayer().getBounds();
            if (n2 % 2 == 1) {
                rectangle.x = rectangle2.x;
                rectangle.width = rectangle2.width;
            } else {
                rectangle.y = rectangle2.y;
                rectangle.height = rectangle2.height;
            }
            iFigure2.setBounds(rectangle);
        }
    }

    public void showTargetFeedback(Request request) {
        if (request.getType().equals("move") || request.getType().equals("resize") || request.getType().equals("clone") || request.getType().equals("add children") || request.getType().equals("create child")) {
            Map map = request.getExtendedData();
            Integer n = (Integer)map.get("SnapToGuides.VerticalAttachment");
            n = n == null || n != 0 ? (Integer)map.get("SnapToGuides.VerticalGuide") : null;
            Color color = IscobolScreenPainterPlugin.getColorFromStore((String)this.guideColorProp);
            this.highlightGuide(n, color, 0);
            n = (Integer)map.get("SnapToGuides.HorizontalAttachment");
            n = n == null || n != 0 ? (Integer)map.get("SnapToGuides.HorizontalGuide") : null;
            this.highlightGuide(n, color, 1);
        }
    }
}

