/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.preferences;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.types.Alphabet;
import com.iscobol.screenpainter.beans.types.AlphabetList;
import com.iscobol.screenpainter.beans.types.FileEntry;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.ScreenProgramAdapter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.gef.ui.actions.Clipboard;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PropertyPage;

public class AlphabetPropertyPage
extends PropertyPage {
    private Tree alphabetTree;
    private Button addBtn;
    private Button removeBtn;
    private Button editBtn;
    private Button upBtn;
    private Button downBtn;
    private Button importCopyBtn;
    private Button linkCopyBtn;
    private Button removeCopyBtn;
    private ScreenProgram screenProgram;
    private AlphabetList alphabetList;
    private IProject project;

    protected Control createContents(Composite composite) {
        FileEntry[] fileEntryArray;
        this.screenProgram = ((ScreenProgramAdapter)this.getElement()).getScreenProgram();
        this.alphabetList = this.screenProgram.getAlphabets();
        this.project = this.screenProgram.getProject();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Alphabet list");
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.alphabetTree = new Tree(composite2, 2050);
        gridData = new GridData(1808);
        gridData.widthHint = 500;
        gridData.heightHint = 400;
        gridData.verticalSpan = 8;
        this.alphabetTree.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData();
        gridData2.widthHint = 180;
        gridData2.verticalAlignment = 128;
        this.importCopyBtn = new Button(composite2, 8);
        this.importCopyBtn.setText("Import Copy File");
        this.importCopyBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.importCopyBtn.setLayoutData((Object)gridData2);
        this.linkCopyBtn = new Button(composite2, 8);
        this.linkCopyBtn.setText("Link Copy File");
        this.linkCopyBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.linkCopyBtn.setLayoutData((Object)gridData2);
        this.removeCopyBtn = new Button(composite2, 8);
        this.removeCopyBtn.setText("Remove Copy File");
        this.removeCopyBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeCopyBtn.setLayoutData((Object)gridData2);
        this.removeCopyBtn.setEnabled(false);
        this.addBtn = new Button(composite2, 8);
        this.addBtn.setText("Add");
        this.addBtn.setLayoutData((Object)gridData2);
        this.editBtn = new Button(composite2, 8);
        this.editBtn.setText("Edit");
        this.editBtn.setLayoutData((Object)gridData2);
        this.editBtn.setEnabled(false);
        this.removeBtn = new Button(composite2, 8);
        this.removeBtn.setText("Remove");
        this.removeBtn.setLayoutData((Object)gridData2);
        this.removeBtn.setEnabled(false);
        this.upBtn = new Button(composite2, 8);
        this.upBtn.setText("Up");
        this.upBtn.setLayoutData((Object)gridData2);
        this.upBtn.setEnabled(false);
        this.downBtn = new Button(composite2, 8);
        this.downBtn.setText("Down");
        this.downBtn.setLayoutData((Object)gridData2);
        this.downBtn.setEnabled(false);
        FileEntry[] fileEntryArray2 = fileEntryArray = this.alphabetList.getFileEntries();
        int n = fileEntryArray2.length;
        for (int i = 0; i < n; ++i) {
            FileEntry fileEntry = fileEntryArray2[i];
            TreeItem treeItem = this.createCopyItem(fileEntry);
            Alphabet[] alphabetArray = PluginUtilities.analyzeAlphabet((String)fileEntry.getPath(), null, (String[])fileEntry.getOptions(), (IProject)this.project);
            if (alphabetArray == null) continue;
            for (Alphabet alphabet : alphabetArray) {
                this.createAlphabetItem(alphabet, treeItem, -1);
            }
        }
        for (FileEntry fileEntry : fileEntryArray2 = this.alphabetList.getAlphabets()) {
            this.createAlphabetItem((Alphabet)fileEntry, null, -1);
        }
        this.alphabetTree.addListener(35, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.alphabetTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.upBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.downBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.noDefaultAndApplyButton();
        return composite2;
    }

    private void swap(int n, int n2) {
        this.alphabetTree.setRedraw(false);
        TreeItem treeItem = this.alphabetTree.getItem(n);
        TreeItem treeItem2 = this.alphabetTree.getItem(n2);
        Alphabet alphabet = (Alphabet)treeItem.getData();
        String string = treeItem.getText();
        treeItem.setData(treeItem2.getData());
        treeItem.setText(treeItem2.getText());
        treeItem2.setData((Object)alphabet);
        treeItem2.setText(string);
        this.alphabetTree.setRedraw(true);
    }

    private TreeItem createAlphabetItem(Alphabet alphabet, TreeItem treeItem, int n) {
        TreeItem treeItem2 = treeItem != null ? (n >= 0 && n < treeItem.getItemCount() ? new TreeItem(treeItem, 0, n) : new TreeItem(treeItem, 0)) : (n >= 0 && n < this.alphabetTree.getItemCount() ? new TreeItem(this.alphabetTree, 0, n) : new TreeItem(this.alphabetTree, 0));
        treeItem2.setText(alphabet.getName());
        treeItem2.setData((Object)alphabet);
        if (treeItem != null) {
            treeItem2.setForeground(this.alphabetTree.getDisplay().getSystemColor(3));
        }
        return treeItem2;
    }

    private TreeItem createCopyItem(FileEntry fileEntry) {
        TreeItem treeItem = new TreeItem(this.alphabetTree, 0);
        treeItem.setText("Copy " + fileEntry.getPath());
        treeItem.setData((Object)fileEntry);
        treeItem.setForeground(this.alphabetTree.getDisplay().getSystemColor(3));
        treeItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/copy.gif"));
        return treeItem;
    }

    private void showContextMenu(int n, int n2) {
        Menu menu = new Menu((Decorations)this.alphabetTree.getShell(), 8);
        MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText("Copy");
        menuItem.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        menuItem.setEnabled(this.alphabetTree.getSelectionCount() > 0);
        MenuItem menuItem2 = new MenuItem(menu, 8);
        menuItem2.setText("Paste");
        menuItem2.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        menuItem2.setEnabled(Clipboard.getDefault().getContents() instanceof List);
        menu.setLocation(n, n2);
        menu.setVisible(true);
        while (!menu.isDisposed() && menu.isVisible()) {
            if (this.alphabetTree.getDisplay().readAndDispatch()) continue;
            this.alphabetTree.getDisplay().sleep();
        }
        menu.dispose();
    }

    public void setValid(boolean bl) {
        super.setValid(bl);
    }

    public boolean isValid() {
        return super.isValid();
    }

    public boolean performOk() {
        TreeItem[] treeItemArray = this.alphabetTree.getItems();
        ArrayList<Alphabet> arrayList = new ArrayList<Alphabet>();
        ArrayList<FileEntry> arrayList2 = new ArrayList<FileEntry>();
        for (TreeItem treeItem : treeItemArray) {
            if (treeItem.getData() instanceof FileEntry) {
                arrayList2.add((FileEntry)treeItem.getData());
                continue;
            }
            arrayList.add((Alphabet)treeItem.getData());
        }
        this.alphabetList.setFileEntries(arrayList2.toArray(new FileEntry[arrayList2.size()]));
        this.alphabetList.setAlphabets(arrayList.toArray(new Alphabet[arrayList.size()]));
        PluginUtilities.markEditorDirtyOrSave((ScreenProgram)this.screenProgram);
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    private boolean isAlreadyDefined(TreeItem treeItem, TreeItem treeItem2, String string) {
        return this.findItem(treeItem, treeItem2, string) != null;
    }

    private TreeItem findItem(TreeItem treeItem, TreeItem treeItem2, String string) {
        TreeItem[] treeItemArray;
        for (TreeItem treeItem3 : treeItemArray = treeItem != null ? treeItem.getItems() : this.alphabetTree.getItems()) {
            if (treeItem3.getItemCount() > 0) {
                TreeItem treeItem4 = this.findItem(treeItem3, treeItem2, string);
                if (treeItem4 == null) continue;
                return treeItem4;
            }
            if (treeItem3 == treeItem2 || !(treeItem3.getData() instanceof Alphabet) || !((Alphabet)treeItem3.getData()).getName().equals(string)) continue;
            return treeItem3;
        }
        return null;
    }

    private FileEntry getFileEntry(TreeItem treeItem) {
        if (treeItem.getData() instanceof FileEntry) {
            return (FileEntry)treeItem.getData();
        }
        if (treeItem.getParentItem() != null) {
            return (FileEntry)treeItem.getParentItem().getData();
        }
        return null;
    }

    private void addAlphabet(TreeItem treeItem, Alphabet alphabet) {
        int n;
        boolean bl = this.isAlreadyDefined(null, treeItem, alphabet.getName());
        if (bl) {
            n = 1;
            String string = alphabet.getName() + n;
            while (this.isAlreadyDefined(null, treeItem, string)) {
                string = alphabet.getName() + ++n;
            }
            alphabet.setName(string);
        }
        n = -1;
        if (treeItem != null) {
            n = this.alphabetTree.indexOf(treeItem) + 1;
        }
        this.createAlphabetItem(alphabet, null, n);
    }

    static /* synthetic */ IProject access$000(AlphabetPropertyPage alphabetPropertyPage) {
        return alphabetPropertyPage.project;
    }

    static /* synthetic */ TreeItem access$100(AlphabetPropertyPage alphabetPropertyPage, Alphabet alphabet, TreeItem treeItem, int n) {
        return alphabetPropertyPage.createAlphabetItem(alphabet, treeItem, n);
    }

    static /* synthetic */ TreeItem access$200(AlphabetPropertyPage alphabetPropertyPage, FileEntry fileEntry) {
        return alphabetPropertyPage.createCopyItem(fileEntry);
    }

    static /* synthetic */ Tree access$300(AlphabetPropertyPage alphabetPropertyPage) {
        return alphabetPropertyPage.alphabetTree;
    }

    static /* synthetic */ void access$400(AlphabetPropertyPage alphabetPropertyPage, int n, int n2) {
        alphabetPropertyPage.showContextMenu(n, n2);
    }

    static /* synthetic */ FileEntry access$500(AlphabetPropertyPage alphabetPropertyPage, TreeItem treeItem) {
        return alphabetPropertyPage.getFileEntry(treeItem);
    }

    static /* synthetic */ Button access$600(AlphabetPropertyPage alphabetPropertyPage) {
        return alphabetPropertyPage.removeCopyBtn;
    }

    static /* synthetic */ Button access$700(AlphabetPropertyPage alphabetPropertyPage) {
        return alphabetPropertyPage.removeBtn;
    }

    static /* synthetic */ Button access$800(AlphabetPropertyPage alphabetPropertyPage) {
        return alphabetPropertyPage.editBtn;
    }

    static /* synthetic */ Button access$900(AlphabetPropertyPage alphabetPropertyPage) {
        return alphabetPropertyPage.upBtn;
    }

    static /* synthetic */ Button access$1000(AlphabetPropertyPage alphabetPropertyPage) {
        return alphabetPropertyPage.downBtn;
    }

    static /* synthetic */ void access$1100(AlphabetPropertyPage alphabetPropertyPage, TreeItem treeItem, Alphabet alphabet) {
        alphabetPropertyPage.addAlphabet(treeItem, alphabet);
    }

    static /* synthetic */ TreeItem access$1200(AlphabetPropertyPage alphabetPropertyPage, TreeItem treeItem, TreeItem treeItem2, String string) {
        return alphabetPropertyPage.findItem(treeItem, treeItem2, string);
    }

    static /* synthetic */ void access$1300(AlphabetPropertyPage alphabetPropertyPage, int n, int n2) {
        alphabetPropertyPage.swap(n, n2);
    }
}

