/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.preferences;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.preferences.DataDesignerPreferencePage;
import com.iscobol.screenpainter.util.ColorProvider;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DataDesignerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Table copyColorsTable;
    private TableEditor copyColorsTableEditor;
    private BooleanFieldEditor reloadCopiesWhenOpen;
    private Button addBtn;
    private Button removeBtn;

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(IscobolScreenPainterPlugin.getDefault().getPreferenceStore());
    }

    private void showErrorBox(String string) {
        MessageBox messageBox = new MessageBox(this.getShell(), 33);
        messageBox.setText(this.getTitle());
        messageBox.setMessage(string);
        messageBox.open();
    }

    private boolean checkRGB(RGB rGB, TableItem tableItem) {
        boolean bl = true;
        TableItem[] tableItemArray = this.copyColorsTable.getItems();
        for (int i = 0; i < tableItemArray.length && bl; ++i) {
            RGB rGB2;
            if (tableItemArray[i] == tableItem || !(rGB2 = tableItemArray[i].getForeground(1).getRGB()).equals((Object)rGB)) continue;
            bl = false;
        }
        return bl;
    }

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setText("Copy File Color Patterns");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        group.setLayout((Layout)gridLayout);
        this.copyColorsTable = new Table((Composite)group, 67584);
        this.copyColorsTable.setLinesVisible(true);
        this.copyColorsTable.setHeaderVisible(true);
        this.copyColorsTableEditor = new TableEditor(this.copyColorsTable);
        this.copyColorsTableEditor.grabHorizontal = true;
        TableCursor tableCursor = new TableCursor(this.copyColorsTable, 0);
        tableCursor.setBackground(this.copyColorsTable.getBackground());
        tableCursor.setForeground(this.copyColorsTable.getForeground());
        tableCursor.setVisible(false);
        this.createColumn("Level", 50);
        this.createColumn("Text Color", 150);
        GridData gridData = new GridData();
        gridData.heightHint = 250;
        gridData.verticalSpan = 2;
        this.copyColorsTable.setLayoutData((Object)gridData);
        this.addBtn = new Button((Composite)group, 8);
        this.addBtn.setText("Add");
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        gridData.widthHint = 70;
        this.addBtn.setLayoutData((Object)gridData);
        this.removeBtn = new Button((Composite)group, 8);
        this.removeBtn.setText("Remove");
        gridData = new GridData();
        gridData.verticalAlignment = 128;
        gridData.widthHint = 70;
        this.removeBtn.setLayoutData((Object)gridData);
        String string = IscobolScreenPainterPlugin.getStringFromStore((String)"iscobol.copybook.colors");
        this.loadColors(string);
        this.reloadCopiesWhenOpen = new BooleanFieldEditor("iscoboldd.reloadlinkedcopies", "Reload linked copies when opening a Screen Program or FD/SL", composite2);
        this.reloadCopiesWhenOpen.setPage((DialogPage)this);
        this.reloadCopiesWhenOpen.setPreferenceStore(this.getPreferenceStore());
        this.reloadCopiesWhenOpen.load();
        this.copyColorsTable.addListener(3, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        this.addBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        return composite2;
    }

    private void loadColors(String string) {
        this.copyColorsTable.removeAll();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        ColorProvider colorProvider = IscobolScreenPainterPlugin.getDefault().getColorProvider();
        int n = stringTokenizer.countTokens();
        for (int i = 0; i < n; ++i) {
            StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), ",");
            int n2 = Integer.parseInt(stringTokenizer2.nextToken());
            int n3 = Integer.parseInt(stringTokenizer2.nextToken());
            int n4 = Integer.parseInt(stringTokenizer2.nextToken());
            RGB rGB = new RGB(n2, n3, n4);
            TableItem tableItem = new TableItem(this.copyColorsTable, 0);
            tableItem.setText(0, Integer.toString(i + 1));
            tableItem.setText(1, "data-item");
            tableItem.setForeground(1, colorProvider.getColor(rGB));
        }
    }

    private void createColumn(String string, int n) {
        TableColumn tableColumn = new TableColumn(this.copyColorsTable, 0);
        tableColumn.setWidth(n);
        tableColumn.setText(string);
        tableColumn.setResizable(false);
        tableColumn.setMoveable(false);
    }

    private int[] getItemForLocation(int n, int n2) {
        TableItem[] tableItemArray = this.copyColorsTable.getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            for (int j = 0; j < this.copyColorsTable.getColumnCount(); ++j) {
                if (!tableItemArray[i].getBounds(j).contains(n, n2)) continue;
                return new int[]{i, j};
            }
        }
        return null;
    }

    private void handleCopyColorsTableSelectionEvent(TableItem tableItem) {
        ColorEditor colorEditor = new ColorEditor(this, (Composite)this.copyColorsTable, tableItem);
        4 var3_3 = new /* Unavailable Anonymous Inner Class!! */;
        colorEditor.addListener(16, (Listener)var3_3);
        colorEditor.addListener(31, (Listener)var3_3);
        this.copyColorsTableEditor.setEditor((Control)colorEditor, tableItem, 1);
        colorEditor.setBackground(tableItem.getForeground(1));
        colorEditor.setFocus();
    }

    public boolean isValid() {
        return super.isValid();
    }

    protected void performDefaults() {
        String string = this.getPreferenceStore().getDefaultString("iscobol.copybook.colors");
        this.loadColors(string);
        this.reloadCopiesWhenOpen.loadDefault();
        super.performDefaults();
    }

    public boolean performOk() {
        StringBuilder stringBuilder = new StringBuilder();
        TableItem[] tableItemArray = this.copyColorsTable.getItems();
        for (int i = 0; i < tableItemArray.length; ++i) {
            RGB rGB = tableItemArray[i].getForeground(1).getRGB();
            stringBuilder.append(rGB.red);
            stringBuilder.append(',');
            stringBuilder.append(rGB.green);
            stringBuilder.append(',');
            stringBuilder.append(rGB.blue);
            if (i >= tableItemArray.length - 1) continue;
            stringBuilder.append(';');
        }
        this.getPreferenceStore().setValue("iscobol.copybook.colors", stringBuilder.toString());
        this.reloadCopiesWhenOpen.store();
        return super.performOk();
    }

    static /* synthetic */ boolean access$000(DataDesignerPreferencePage dataDesignerPreferencePage, RGB rGB, TableItem tableItem) {
        return dataDesignerPreferencePage.checkRGB(rGB, tableItem);
    }

    static /* synthetic */ void access$100(DataDesignerPreferencePage dataDesignerPreferencePage, String string) {
        dataDesignerPreferencePage.showErrorBox(string);
    }

    static /* synthetic */ int[] access$200(DataDesignerPreferencePage dataDesignerPreferencePage, int n, int n2) {
        return dataDesignerPreferencePage.getItemForLocation(n, n2);
    }

    static /* synthetic */ Table access$300(DataDesignerPreferencePage dataDesignerPreferencePage) {
        return dataDesignerPreferencePage.copyColorsTable;
    }

    static /* synthetic */ void access$400(DataDesignerPreferencePage dataDesignerPreferencePage, TableItem tableItem) {
        dataDesignerPreferencePage.handleCopyColorsTableSelectionEvent(tableItem);
    }
}

