/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.preferences;

import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.AbstractBeanControl;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.beans.AbstractInputField;
import com.iscobol.screenpainter.beans.AbstractTabbedPane;
import com.iscobol.screenpainter.beans.ComponentsContainer;
import com.iscobol.screenpainter.beans.IToolbar;
import com.iscobol.screenpainter.beans.TabPage;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.ScreenProgramAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeMap;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PropertyPage;

public class ExternalParagraphsPropertyPage
extends PropertyPage {
    private ScreenProgram screenProgram;
    private Tree extParsTree;

    protected Control createContents(Composite composite) {
        this.screenProgram = ((ScreenProgramAdapter)this.getElement()).getScreenProgram();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        GridData gridData = new GridData(1808);
        group.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)group, 0);
        label.setText("Check the external paragraph(s)");
        this.extParsTree = new Tree((Composite)group, 2084);
        gridData = new GridData(1808);
        gridData.widthHint = 400;
        gridData.heightHint = 300;
        this.extParsTree.setLayoutData((Object)gridData);
        String[] stringArray = this.getControlParagraphs();
        for (int i = 0; i < stringArray.length; ++i) {
            TreeItem treeItem = new TreeItem(this.extParsTree, 0);
            treeItem.setText(stringArray[i]);
            treeItem.setChecked(this.screenProgram.isExternalParagraph(stringArray[i]));
        }
        this.noDefaultAndApplyButton();
        return composite2;
    }

    private String[] getControlParagraphs() {
        AbstractBeanWindow[] abstractBeanWindowArray = this.screenProgram.getScreenSections();
        TreeMap treeMap = new TreeMap(PluginUtilities.ignoreCaseComparator);
        for (int i = 0; i < abstractBeanWindowArray.length; ++i) {
            this.getControlParagraphs(abstractBeanWindowArray[i], treeMap);
        }
        String[] stringArray = new String[treeMap.size()];
        treeMap.values().toArray(stringArray);
        Arrays.sort(stringArray, PluginUtilities.ignoreCaseComparator);
        return stringArray;
    }

    private void getControlParagraphs(AbstractBeanWindow abstractBeanWindow, TreeMap treeMap) {
        String string = abstractBeanWindow.getEventProcedure();
        if (string != null && string.length() > 0) {
            treeMap.put(string, string);
        }
        if ((string = abstractBeanWindow.getExceptionProcedure()) != null && string.length() > 0) {
            treeMap.put(string, string);
        }
        IToolbar[] iToolbarArray = abstractBeanWindow.getToolbars();
        for (int i = 0; i < iToolbarArray.length; ++i) {
            this.getControlParagraphs(iToolbarArray[i], treeMap);
        }
        this.getControlParagraphs((ComponentsContainer)abstractBeanWindow, treeMap);
    }

    private void getControlParagraphs(ComponentsContainer componentsContainer, TreeMap treeMap) {
        AbstractBeanControl[] abstractBeanControlArray = componentsContainer.getComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            this.getControlParagraphs(abstractBeanControlArray[i], treeMap);
        }
    }

    private void getControlParagraphs(IToolbar iToolbar, TreeMap treeMap) {
        AbstractBeanControl[] abstractBeanControlArray = iToolbar.getToolbarComponents();
        for (int i = 0; i < abstractBeanControlArray.length; ++i) {
            this.getControlParagraphs(abstractBeanControlArray[i], treeMap);
        }
    }

    private void getControlParagraphs(AbstractBeanControl abstractBeanControl, TreeMap treeMap) {
        AbstractInputField abstractInputField;
        if (abstractBeanControl instanceof AbstractInputField) {
            abstractInputField = (AbstractInputField)abstractBeanControl;
            String string = abstractInputField.getEventProcedure();
            if (string != null && string.length() > 0) {
                treeMap.put(string, string);
            }
            if ((string = abstractInputField.getExceptionProcedure()) != null && string.length() > 0) {
                treeMap.put(string, string);
            }
        }
        if (abstractBeanControl instanceof AbstractTabbedPane) {
            abstractInputField = (AbstractTabbedPane)abstractBeanControl;
            TabPage[] tabPageArray = abstractInputField.getPages();
            for (int i = 0; i < tabPageArray.length; ++i) {
                this.getControlParagraphs((ComponentsContainer)tabPageArray[i], treeMap);
            }
        } else if (abstractBeanControl instanceof ComponentsContainer) {
            this.getControlParagraphs((ComponentsContainer)abstractBeanControl, treeMap);
        }
    }

    public boolean performOk() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TreeItem[] treeItemArray = this.extParsTree.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            if (!treeItemArray[i].getChecked()) continue;
            arrayList.add(treeItemArray[i].getText());
        }
        this.screenProgram.setExternalParagraphs(arrayList.toArray(new String[arrayList.size()]));
        PluginUtilities.markEditorDirtyOrSave((ScreenProgram)this.screenProgram);
        return super.performOk();
    }
}

