/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.preferences;

import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.ScreenProgramAdapter;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PropertyPage;

public class ExternalVariablesPropertyPage
extends PropertyPage {
    private ScreenProgram screenProgram;
    private Tree extVarsTree;

    protected Control createContents(Composite composite) {
        this.screenProgram = ((ScreenProgramAdapter)this.getElement()).getScreenProgram();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        GridData gridData = new GridData(1808);
        group.setLayoutData((Object)gridData);
        gridLayout = new GridLayout();
        group.setLayout((Layout)gridLayout);
        Label label = new Label((Composite)group, 0);
        label.setText("Check the external variable(s)");
        this.extVarsTree = new Tree((Composite)group, 2084);
        gridData = new GridData(1808);
        gridData.widthHint = 400;
        gridData.heightHint = 300;
        this.extVarsTree.setLayoutData((Object)gridData);
        String[] stringArray = this.getControlVariables();
        for (int i = 0; i < stringArray.length; ++i) {
            TreeItem treeItem = new TreeItem(this.extVarsTree, 0);
            treeItem.setText(stringArray[i]);
            treeItem.setChecked(this.screenProgram.isExternalVariable(stringArray[i]));
        }
        this.noDefaultAndApplyButton();
        return composite2;
    }

    private String[] getControlVariables() {
        VariableType[] variableTypeArray = this.screenProgram.getResourceRegistry().getVariables(false);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < variableTypeArray.length; ++i) {
            if (variableTypeArray[i].isFiller()) continue;
            arrayList.add(variableTypeArray[i].getName());
        }
        Collections.sort(arrayList, PluginUtilities.ignoreCaseComparator);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public boolean performOk() {
        ArrayList<String> arrayList = new ArrayList<String>();
        TreeItem[] treeItemArray = this.extVarsTree.getItems();
        for (int i = 0; i < treeItemArray.length; ++i) {
            if (!treeItemArray[i].getChecked()) continue;
            arrayList.add(treeItemArray[i].getText());
        }
        this.screenProgram.setExternalVariables(arrayList.toArray(new String[arrayList.size()]));
        PluginUtilities.markEditorDirtyOrSave((ScreenProgram)this.screenProgram);
        return super.performOk();
    }
}

