/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.preferences;

import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.ScreenProgramAdapter;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProgramGeneralPropertyPage
extends PropertyPage {
    private Text prognameTxt;
    private Text releaseTxt;
    private Combo screenCmb;
    private String mainScreen;
    private Text remarksTxt;
    private String remarks;
    private Text compDirTxt;
    private String compilerDirectives;
    private int programIdClause;
    private Button progIdNormalBtn;
    private Button progIdResidentBtn;
    private Button progIdInitialBtn;
    private boolean promptWhenProgramExits;
    private Button promptWPEBtn;

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        ScreenProgramAdapter screenProgramAdapter = (ScreenProgramAdapter)this.getElement();
        ScreenProgram screenProgram = screenProgramAdapter.getScreenProgram();
        IFile iFile = screenProgram.getFile();
        String string = iFile.getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        gridLayout.verticalSpacing = 10;
        composite2.setLayout((Layout)gridLayout);
        Label label = new Label(composite2, 0);
        label.setText("Program name:");
        this.prognameTxt = new Text(composite2, 2048);
        this.prognameTxt.setText(string);
        GridData gridData = new GridData();
        gridData.widthHint = 150;
        this.prognameTxt.setLayoutData((Object)gridData);
        this.prognameTxt.setEditable(false);
        label = new Label(composite2, 0);
        label.setText("isCOBOL Release:");
        this.releaseTxt = new Text(composite2, 2048);
        this.releaseTxt.setText(screenProgram.getIscobolRelease());
        gridData = new GridData();
        gridData.widthHint = 150;
        this.releaseTxt.setLayoutData((Object)gridData);
        this.releaseTxt.setEditable(false);
        label = new Label(composite2, 0);
        label.setText(ISPBundle.getString((String)"main_screen_lbl") + ":");
        this.screenCmb = new Combo(composite2, 2056);
        AbstractBeanWindow[] abstractBeanWindowArray = screenProgram.getScreenSections();
        String string2 = screenProgram.getMainScreen();
        int n2 = -1;
        for (int i = 0; i < abstractBeanWindowArray.length; ++i) {
            String string3 = abstractBeanWindowArray[i].getName();
            this.screenCmb.add(string3);
            if (string2 == null || !string2.equalsIgnoreCase(string3)) continue;
            this.mainScreen = string3;
            n2 = i;
        }
        this.screenCmb.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData();
        gridData.widthHint = 200;
        gridData.horizontalSpan = 3;
        this.screenCmb.setLayoutData((Object)gridData);
        if (n2 >= 0) {
            this.screenCmb.select(n2);
        } else if (abstractBeanWindowArray.length > 0) {
            this.screenCmb.select(0);
            this.mainScreen = abstractBeanWindowArray[0].getName();
        }
        label = new Label(composite2, 0);
        label.setText("Description (Generated under Remarks as comment)");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.remarks = screenProgram.getRemarks();
        this.remarksTxt = new Text(composite2, 2818);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.heightHint = 100;
        this.remarksTxt.setLayoutData((Object)gridData);
        if (this.remarks != null) {
            this.remarksTxt.setText(this.remarks);
        }
        this.remarksTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        label = new Label(composite2, 0);
        label.setText("Compiler Directives (Generated at the beginning of the program)");
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        label.setLayoutData((Object)gridData);
        this.compilerDirectives = screenProgram.getCompilerDirectives();
        this.compDirTxt = new Text(composite2, 2818);
        gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        gridData.heightHint = 100;
        this.compDirTxt.setLayoutData((Object)gridData);
        if (this.compilerDirectives != null) {
            this.compDirTxt.setText(this.compilerDirectives);
        }
        this.compDirTxt.addModifyListener((ModifyListener)new /* Unavailable Anonymous Inner Class!! */);
        Group group = new Group(composite2, 0);
        group.setText("Program-Id");
        gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        group.setLayout((Layout)gridLayout);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        group.setLayoutData((Object)gridData);
        this.programIdClause = screenProgram.getProgramIdClause();
        this.progIdNormalBtn = new Button((Composite)group, 16);
        this.progIdNormalBtn.setText("None");
        this.progIdInitialBtn = new Button((Composite)group, 16);
        this.progIdInitialBtn.setText("Is Initial Program");
        this.progIdResidentBtn = new Button((Composite)group, 16);
        this.progIdResidentBtn.setText("Is Resident Program");
        switch (this.programIdClause) {
            default: {
                this.progIdNormalBtn.setSelection(true);
                break;
            }
            case 1: {
                this.progIdInitialBtn.setSelection(true);
                break;
            }
            case 2: {
                this.progIdResidentBtn.setSelection(true);
            }
        }
        this.progIdNormalBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.progIdInitialBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.progIdResidentBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.promptWhenProgramExits = screenProgram.getPromptWhenProgramExits();
        this.promptWPEBtn = new Button(composite2, 32);
        gridData = new GridData();
        gridData.horizontalSpan = 4;
        this.promptWPEBtn.setLayoutData((Object)gridData);
        this.promptWPEBtn.setText("Prompt when program exits");
        this.promptWPEBtn.setSelection(this.promptWhenProgramExits);
        this.promptWPEBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.noDefaultAndApplyButton();
        return composite2;
    }

    public void setValid(boolean bl) {
        super.setValid(bl);
    }

    public boolean isValid() {
        return super.isValid();
    }

    public boolean performOk() {
        ScreenProgramAdapter screenProgramAdapter = (ScreenProgramAdapter)this.getElement();
        ScreenProgram screenProgram = screenProgramAdapter.getScreenProgram();
        if (this.mainScreen != null) {
            screenProgram.setMainScreen(this.mainScreen);
        }
        if (this.remarks != null) {
            screenProgram.setRemarks(this.remarks);
        }
        if (this.compilerDirectives != null) {
            screenProgram.setCompilerDirectives(this.compilerDirectives);
        }
        screenProgram.setProgramIdClause(this.programIdClause);
        screenProgram.setPromptWhenProgramExits(this.promptWhenProgramExits);
        PluginUtilities.markEditorDirtyOrSave((ScreenProgram)screenProgram);
        return super.performOk();
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    static /* synthetic */ String access$002(ProgramGeneralPropertyPage programGeneralPropertyPage, String string) {
        programGeneralPropertyPage.mainScreen = string;
        return programGeneralPropertyPage.mainScreen;
    }

    static /* synthetic */ Combo access$100(ProgramGeneralPropertyPage programGeneralPropertyPage) {
        return programGeneralPropertyPage.screenCmb;
    }

    static /* synthetic */ String access$202(ProgramGeneralPropertyPage programGeneralPropertyPage, String string) {
        programGeneralPropertyPage.remarks = string;
        return programGeneralPropertyPage.remarks;
    }

    static /* synthetic */ Text access$300(ProgramGeneralPropertyPage programGeneralPropertyPage) {
        return programGeneralPropertyPage.remarksTxt;
    }

    static /* synthetic */ String access$402(ProgramGeneralPropertyPage programGeneralPropertyPage, String string) {
        programGeneralPropertyPage.compilerDirectives = string;
        return programGeneralPropertyPage.compilerDirectives;
    }

    static /* synthetic */ Text access$500(ProgramGeneralPropertyPage programGeneralPropertyPage) {
        return programGeneralPropertyPage.compDirTxt;
    }

    static /* synthetic */ int access$602(ProgramGeneralPropertyPage programGeneralPropertyPage, int n) {
        programGeneralPropertyPage.programIdClause = n;
        return programGeneralPropertyPage.programIdClause;
    }

    static /* synthetic */ boolean access$702(ProgramGeneralPropertyPage programGeneralPropertyPage, boolean bl) {
        programGeneralPropertyPage.promptWhenProgramExits = bl;
        return programGeneralPropertyPage.promptWhenProgramExits;
    }

    static /* synthetic */ Button access$800(ProgramGeneralPropertyPage programGeneralPropertyPage) {
        return programGeneralPropertyPage.promptWPEBtn;
    }
}

