/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.preferences;

import com.iscobol.plugins.editor.util.ProjectClassLoader;
import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.types.FileEntry;
import com.iscobol.screenpainter.beans.types.Repository;
import com.iscobol.screenpainter.util.PluginUtilities;
import com.iscobol.screenpainter.util.adapters.ScreenProgramAdapter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.PropertyPage;

public class RepositoryPropertyPage
extends PropertyPage {
    private Tree repTree;
    private Button addBtn;
    private Button editBtn;
    private Button removeBtn;
    private Button removeAllBtn;
    private Button importCopyBtn;
    private Button linkCopyBtn;
    private Button removeCopyBtn;
    private ScreenProgram screenProgram;
    private IProject project;
    private Repository repository;

    protected Control createContents(Composite composite) {
        FileEntry[] fileEntryArray;
        this.screenProgram = ((ScreenProgramAdapter)this.getElement()).getScreenProgram();
        this.repository = this.screenProgram.getResourceRegistry().getRepository();
        this.project = this.screenProgram.getProject();
        String string = PluginUtilities.getCurrentSettingMode((IResource)this.project);
        ProjectClassLoader projectClassLoader = PluginUtilities.getClassLoader((IProject)this.project, (String)string);
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite2.setLayout((Layout)gridLayout);
        this.repTree = new Tree(composite2, 2050);
        GridData gridData = new GridData(1808);
        gridData.verticalSpan = 7;
        gridData.widthHint = 500;
        gridData.heightHint = 400;
        this.repTree.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData();
        gridData2.widthHint = 180;
        this.importCopyBtn = new Button(composite2, 8);
        this.importCopyBtn.setText("Import Copy File");
        this.importCopyBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.importCopyBtn.setLayoutData((Object)gridData2);
        this.linkCopyBtn = new Button(composite2, 8);
        this.linkCopyBtn.setText("Link Copy File");
        this.linkCopyBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.linkCopyBtn.setLayoutData((Object)gridData2);
        this.removeCopyBtn = new Button(composite2, 8);
        this.removeCopyBtn.setText("Remove Copy File");
        this.removeCopyBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeCopyBtn.setLayoutData((Object)gridData2);
        this.removeCopyBtn.setEnabled(false);
        this.addBtn = new Button(composite2, 8);
        this.addBtn.setText("Add");
        this.addBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addBtn.setLayoutData((Object)gridData2);
        this.editBtn = new Button(composite2, 8);
        this.editBtn.setText("Edit");
        this.editBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.editBtn.setLayoutData((Object)gridData2);
        this.editBtn.setEnabled(false);
        this.removeBtn = new Button(composite2, 8);
        this.removeBtn.setText("Remove");
        this.removeBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.removeBtn.setLayoutData((Object)gridData2);
        this.removeBtn.setEnabled(false);
        this.removeAllBtn = new Button(composite2, 8);
        this.removeAllBtn.setText("Remove All");
        this.removeAllBtn.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        gridData = new GridData();
        gridData.widthHint = gridData2.widthHint;
        gridData.verticalAlignment = 128;
        this.removeAllBtn.setLayoutData((Object)gridData);
        this.repTree.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        for (FileEntry fileEntry : fileEntryArray = this.repository.getFileEntries()) {
            TreeItem treeItem = this.createCopyItem(fileEntry);
            Repository.Entry[] entryArray = PluginUtilities.analyzeRepository((String)fileEntry.getPath(), null, (String[])fileEntry.getOptions(), (IProject)this.project);
            if (entryArray == null) continue;
            this.loadEntries(entryArray, treeItem);
        }
        FileEntry[] fileEntryArray2 = this.repository.getEntries();
        this.loadEntries((Repository.Entry[])fileEntryArray2, null);
        this.noDefaultAndApplyButton();
        return composite2;
    }

    private void loadEntries(Repository.Entry[] entryArray, TreeItem treeItem) {
        for (Repository.Entry entry : entryArray) {
            TreeItem treeItem2 = treeItem != null ? new TreeItem(treeItem, 0) : new TreeItem(this.repTree, 0);
            treeItem2.setText("class " + entry.getCobolClassName() + " as \"" + entry.getClassName() + "\"");
            treeItem2.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/repository.gif"));
            treeItem2.setData((Object)entry);
            if (treeItem == null) continue;
            treeItem2.setForeground(this.repTree.getDisplay().getSystemColor(3));
        }
    }

    private TreeItem createCopyItem(FileEntry fileEntry) {
        TreeItem treeItem = new TreeItem(this.repTree, 0);
        treeItem.setText("Copy " + fileEntry.getPath());
        treeItem.setData((Object)fileEntry);
        treeItem.setForeground(this.repTree.getDisplay().getSystemColor(3));
        treeItem.setImage(IscobolScreenPainterPlugin.getDefault().getImageProvider().getImage("/copy.gif"));
        return treeItem;
    }

    private TreeItem findItem(String string) {
        return this.findItem(this.repTree.getItems(), string);
    }

    private TreeItem findItem(TreeItem[] treeItemArray, String string) {
        for (TreeItem treeItem : treeItemArray) {
            if (treeItem.getData() instanceof Repository.Entry) {
                if (!((Repository.Entry)treeItem.getData()).getCobolClassName().equalsIgnoreCase(string)) continue;
                return treeItem;
            }
            TreeItem treeItem2 = this.findItem(treeItem.getItems(), string);
            if (treeItem2 == null) continue;
            return treeItem2;
        }
        return null;
    }

    private FileEntry getFileEntry(TreeItem treeItem) {
        if (treeItem.getData() instanceof FileEntry) {
            return (FileEntry)treeItem.getData();
        }
        if (treeItem.getParentItem() != null) {
            return (FileEntry)treeItem.getParentItem().getData();
        }
        return null;
    }

    public boolean performOk() {
        TreeItem[] treeItemArray = this.repTree.getItems();
        ArrayList<Repository.Entry> arrayList = new ArrayList<Repository.Entry>();
        LinkedHashMap<FileEntry, TreeMap> linkedHashMap = new LinkedHashMap<FileEntry, TreeMap>();
        for (TreeItem treeItem : treeItemArray) {
            if (treeItem.getData() instanceof FileEntry) {
                FileEntry fileEntry = (FileEntry)treeItem.getData();
                TreeMap treeMap = Repository.createEntryMap();
                for (TreeItem treeItem2 : treeItem.getItems()) {
                    Repository.Entry entry = (Repository.Entry)treeItem2.getData();
                    treeMap.put(entry.getCobolClassName(), entry);
                }
                linkedHashMap.put(fileEntry, treeMap);
                continue;
            }
            arrayList.add((Repository.Entry)treeItem.getData());
        }
        this.repository.setFileEntries(linkedHashMap, this.project);
        this.repository.setEntries(arrayList.toArray(new Repository.Entry[arrayList.size()]));
        PluginUtilities.markEditorDirtyOrSave((ScreenProgram)this.screenProgram);
        return super.performOk();
    }

    static /* synthetic */ IProject access$200(RepositoryPropertyPage repositoryPropertyPage) {
        return repositoryPropertyPage.project;
    }

    static /* synthetic */ void access$300(RepositoryPropertyPage repositoryPropertyPage, Repository.Entry[] entryArray, TreeItem treeItem) {
        repositoryPropertyPage.loadEntries(entryArray, treeItem);
    }

    static /* synthetic */ TreeItem access$400(RepositoryPropertyPage repositoryPropertyPage, FileEntry fileEntry) {
        return repositoryPropertyPage.createCopyItem(fileEntry);
    }

    static /* synthetic */ Tree access$500(RepositoryPropertyPage repositoryPropertyPage) {
        return repositoryPropertyPage.repTree;
    }

    static /* synthetic */ TreeItem access$600(RepositoryPropertyPage repositoryPropertyPage, String string) {
        return repositoryPropertyPage.findItem(string);
    }

    static /* synthetic */ FileEntry access$700(RepositoryPropertyPage repositoryPropertyPage, TreeItem treeItem) {
        return repositoryPropertyPage.getFileEntry(treeItem);
    }

    static /* synthetic */ Button access$800(RepositoryPropertyPage repositoryPropertyPage) {
        return repositoryPropertyPage.removeCopyBtn;
    }

    static /* synthetic */ Button access$900(RepositoryPropertyPage repositoryPropertyPage) {
        return repositoryPropertyPage.removeBtn;
    }

    static /* synthetic */ Button access$1000(RepositoryPropertyPage repositoryPropertyPage) {
        return repositoryPropertyPage.editBtn;
    }
}

