/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.preferences;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.ScreenProgramEditor;
import com.iscobol.screenpainter.beans.AbstractBeanWindow;
import com.iscobol.screenpainter.beans.types.Choice;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.ParagraphType;
import com.iscobol.screenpainter.preferences.ISPPreferenceInitializer;
import com.iscobol.screenpainter.preferences.ProjectSettingWindow;
import com.iscobol.screenpainter.propertysheet.PropertySheetContainer;
import com.iscobol.screenpainter.propertysheet.PropertySheetTable;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class ScreenPainterPropertyPage
extends PropertyPage
implements PropertySheetContainer {
    private PropertySheetTable propertyTable;
    private ProjectSettingWindow target = new ProjectSettingWindow();
    private ProjectSettingWindow targetDefault = new ProjectSettingWindow();
    private Button showOnlyWd2SupportedBtn;
    private boolean showOnlyWd2Supported;
    private boolean dirty;

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        Group group = new Group(composite2, 0);
        group.setText("Screen Font/Color/Cell settings");
        group.setLayout((Layout)new GridLayout());
        IProject iProject = (IProject)PluginUtilities.castOrAdapt((Object)this.getElement(), IProject.class);
        try {
            ProjectSettingWindow.loadProperties((IProject)iProject, (AbstractBeanWindow)this.target);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.propertyTable = new PropertySheetTable((Composite)group, 0, (PropertySheetContainer)this, null, null, true, 200, 200);
        GridData gridData = new GridData(1808);
        this.propertyTable.setLayoutData((Object)gridData);
        this.showOnlyWd2SupportedBtn = new Button(composite2, 32);
        this.showOnlyWd2SupportedBtn.setText("Show only supported features in WD2");
        String string = PluginUtilities.getPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobolsp.showonlywd2supported");
        this.showOnlyWd2Supported = "true".equals(string);
        this.showOnlyWd2SupportedBtn.setSelection(this.showOnlyWd2Supported);
        this.propertyTable.loadTable(new Object[]{this.target});
        return composite2;
    }

    protected void performDefaults() {
        ISPPreferenceInitializer.initialize((Object)this.targetDefault, (String)"Screen", (IPreferenceStore)IscobolScreenPainterPlugin.getDefault().getPreferenceStore(), null);
        this.applyValues((AbstractBeanWindow)this.targetDefault, (AbstractBeanWindow)this.target);
        this.propertyTable.loadTable(new Object[]{this.target});
        this.showOnlyWd2SupportedBtn.setSelection(false);
        this.dirty = true;
    }

    public boolean performOk() {
        String string;
        IPreferenceStore iPreferenceStore = IscobolScreenPainterPlugin.getDefault().getPreferenceStore();
        int n = iPreferenceStore.contains(string = "iscobol.ApplyPrjScreenProps") ? iPreferenceStore.getInt(string) : iPreferenceStore.getDefaultInt(string);
        boolean bl = false;
        IProject iProject = (IProject)PluginUtilities.castOrAdapt((Object)this.getElement(), IProject.class);
        PluginUtilities.setPersistentProperty((IResource)iProject, (String)"Default", (String)"iscobolsp.showonlywd2supported", (String)Boolean.toString(this.showOnlyWd2SupportedBtn.getSelection()));
        this.saveProperties();
        if (this.dirty) {
            if (n == 2) {
                MessageDialogWithToggle messageDialogWithToggle = MessageDialogWithToggle.open((int)3, (Shell)this.getShell(), (String)"Save Properties", (String)"Apply the changes to the programs already created in the project?", (String)"Remember my decision", (boolean)false, (IPreferenceStore)iPreferenceStore, (String)string, (int)0);
                boolean bl2 = bl = messageDialogWithToggle.getReturnCode() == 2;
                if (messageDialogWithToggle.getToggleState()) {
                    int n2 = bl ? 0 : 1;
                    iPreferenceStore.setValue(string, n2);
                }
            } else if (n == 0) {
                bl = true;
            }
            if (bl) {
                this.applyChangesToScreenPrograms(iProject);
            }
        }
        this.dirty = false;
        if (this.showOnlyWd2Supported != this.showOnlyWd2SupportedBtn.getSelection()) {
            for (MessageDialogWithToggle messageDialogWithToggle : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences()) {
                ScreenProgramEditor screenProgramEditor;
                IProject iProject2;
                IEditorPart iEditorPart = messageDialogWithToggle.getEditor(false);
                if (!(iEditorPart instanceof ScreenProgramEditor) || (iProject2 = (screenProgramEditor = (ScreenProgramEditor)iEditorPart).getScreenProgram().getProject()) == null || !iProject2.equals(iProject)) continue;
                screenProgramEditor.closeEditor(true);
            }
        }
        return super.performOk();
    }

    private void applyChangesToScreenPrograms(IProject iProject) {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.getShell());
        try {
            progressMonitorDialog.run(true, true, (IRunnableWithProgress)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private IFile[] getScreenProgramFiles(IProject iProject) {
        try {
            IContainer iContainer = PluginUtilities.getScreenFolder((IProject)iProject);
            if (iContainer != null) {
                ArrayList<IFile> arrayList = new ArrayList<IFile>();
                IResource[] iResourceArray = iContainer.members();
                for (int i = 0; i < iResourceArray.length; ++i) {
                    IFile iFile;
                    if (iResourceArray[i].getType() != 1 || (iFile = (IFile)iResourceArray[i]).getFileExtension() == null || !iFile.getFileExtension().equals("isp")) continue;
                    arrayList.add(iFile);
                }
                return arrayList.toArray(new IFile[arrayList.size()]);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return new IFile[0];
    }

    private void applyChangesToScreenPrograms(IProject iProject, IProgressMonitor iProgressMonitor) {
        IFile[] iFileArray = this.getScreenProgramFiles(iProject);
        iProgressMonitor.beginTask("Apply changes...", iFileArray.length * 100);
        for (IFile iFile : iFileArray) {
            if (iProgressMonitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            iProgressMonitor.subTask("Update " + iFile.getName() + "...");
            ScreenProgram screenProgram = PluginUtilities.getScreenProgram((IFile)iFile);
            for (AbstractBeanWindow abstractBeanWindow : screenProgram.getScreenSections()) {
                this.applyValues((AbstractBeanWindow)this.target, abstractBeanWindow);
            }
            ScreenProgramEditor screenProgramEditor = PluginUtilities.findScreenProgramEditor((IFile)iFile);
            if (screenProgramEditor != null) {
                Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
            } else {
                screenProgram.save();
            }
            iProgressMonitor.worked(100);
        }
        iProgressMonitor.done();
    }

    private void applyValues(AbstractBeanWindow abstractBeanWindow, AbstractBeanWindow abstractBeanWindow2) {
        try {
            for (PropertyDescriptor propertyDescriptor : ProjectSettingWindow.pds) {
                Object object = propertyDescriptor.getReadMethod().invoke((Object)abstractBeanWindow, new Object[0]);
                propertyDescriptor.getWriteMethod().invoke((Object)abstractBeanWindow2, object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void saveProperties() {
        try {
            IProject iProject = (IProject)PluginUtilities.castOrAdapt((Object)this.getElement(), IProject.class);
            for (PropertyDescriptor propertyDescriptor : ProjectSettingWindow.pds) {
                String string;
                Object object = propertyDescriptor.getReadMethod().invoke((Object)this.target, new Object[0]);
                if (object != null) {
                    Object object2;
                    if (propertyDescriptor.getPropertyType() == FontType.class) {
                        object2 = (FontType)object;
                        string = this.saveFont((FontType)object2);
                    } else if (propertyDescriptor.getPropertyType() == ColorType.class) {
                        object2 = (ColorType)object;
                        string = this.saveColor((ColorType)object2);
                    } else if (Choice.class.isAssignableFrom(propertyDescriptor.getPropertyType())) {
                        object2 = (Choice)object;
                        string = String.valueOf(object2.getValue());
                    } else if (propertyDescriptor.getPropertyType() == Integer.TYPE) {
                        object2 = (Integer)object;
                        string = String.valueOf((Integer)object2);
                    } else if (propertyDescriptor.getPropertyType() == Boolean.TYPE) {
                        object2 = (Boolean)object;
                        string = String.valueOf((Boolean)object2);
                    } else {
                        string = object.toString();
                    }
                } else {
                    string = null;
                }
                PluginUtilities.setPersistentProperty((IResource)iProject, (String)"Default", (String)ProjectSettingWindow.getPersistentPropName((String)propertyDescriptor.getName()), string);
            }
            PluginUtilities.saveProjectOptions((IProject)iProject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String saveColor(ColorType colorType) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(colorType.getColor());
        stringBuilder.append(',');
        stringBuilder.append(colorType.getRgbBackground());
        stringBuilder.append(',');
        stringBuilder.append(colorType.getRgbForeground());
        return stringBuilder.toString();
    }

    private String saveFont(FontType fontType) {
        StringBuilder stringBuilder = new StringBuilder();
        if (fontType.getDisplayName() != null) {
            stringBuilder.append(fontType.getDisplayName());
        } else {
            stringBuilder.append(fontType.getName());
        }
        stringBuilder.append(',');
        stringBuilder.append(fontType.getName());
        stringBuilder.append(',');
        stringBuilder.append(fontType.getSize());
        stringBuilder.append(',');
        stringBuilder.append(fontType.getStyle());
        return stringBuilder.toString();
    }

    public void valueChanged(Object object, int n, String string, Object object2, Object object3) {
    }

    public void paragraphValueChanged(Object object, int n, String string, ParagraphType paragraphType, ParagraphType paragraphType2, boolean bl) {
    }

    public void setDirty(boolean bl) {
        this.dirty = bl;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public CommandStack getCommandStack() {
        return null;
    }

    static /* synthetic */ void access$000(ScreenPainterPropertyPage screenPainterPropertyPage, IProject iProject, IProgressMonitor iProgressMonitor) {
        screenPainterPropertyPage.applyChangesToScreenPrograms(iProject, iProgressMonitor);
    }
}

