/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.programimport;

import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.programimport.Errors;
import com.iscobol.screenpainter.programimport.GenericScreenObj;
import com.iscobol.screenpainter.programimport.InternalErrorException;
import com.iscobol.screenpainter.programimport.IsConsolePlugin;
import com.iscobol.screenpainter.programimport.Token;
import com.iscobol.screenpainter.programimport.TokenManager;
import java.util.Vector;
import org.eclipse.core.runtime.Status;

/*
 * Exception performing whole class analysis ignored.
 */
public class CellItemObj
extends GenericScreenObj {
    private String data = "";
    private String dataVar = "";
    private String font = "";
    private String fontVar = "";
    private String hiddenData = "";
    private String hiddenDataVar = "";
    private String bitmapHand = "";
    private String bitmap = "";
    private int bitmapWidt = 0;
    private int bitmapNumber = 0;
    private int x = 0;
    private int y = 0;
    private int cellProt = 0;
    private int color;
    private int divi = 0;
    private String colorVar = "";
    private TokenManager tm;
    private Vector lines;

    public CellItemObj(TokenManager tokenManager, Errors errors, Vector vector) throws InternalErrorException {
        super(tokenManager, errors, vector);
        this.tm = tokenManager;
        this.lines = vector;
        this.loadCell();
    }

    void loadCell() throws InternalErrorException {
        boolean bl = true;
        boolean bl2 = true;
        try {
            Token token = this.tm.getToken();
            while (token != null && bl && bl2) {
                switch (token.getToknum()) {
                    case 10009: {
                        if (token.getWord().equals("X")) {
                            this.x = this.tm.loadInt(false);
                            break;
                        }
                        if (token.getWord().equals("Y")) {
                            this.y = this.tm.loadInt(false);
                            break;
                        }
                        if (token.getWord().equals("DIVI")) {
                            this.divi = this.tm.loadInt(false);
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 44: {
                        break;
                    }
                    case 352: {
                        token = this.tm.getToken();
                        if (token != null && (token.getToknum() == 773 || token.getToknum() == 795)) {
                            this.dataVar = this.tm.loadVar(false);
                            break;
                        }
                        if (token.getToknum() == 61) {
                            this.tm.ungetToken();
                            this.data = this.tm.loadString(false);
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 299: {
                        token = this.tm.getToken();
                        if (token != null && token.getToknum() == 437) {
                            this.bitmapHand = this.tm.loadVar(false);
                            break;
                        }
                        if (token.getToknum() == 785) {
                            this.bitmapWidt = this.tm.loadInt(false);
                            break;
                        }
                        if (token.getToknum() == 653) {
                            this.bitmapNumber = this.tm.loadInt(false);
                            break;
                        }
                        if (token.getToknum() == 61) {
                            this.tm.ungetToken();
                            this.bitmap = this.tm.loadString(false);
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 405: {
                        token = this.tm.getToken();
                        if (token != null) {
                            if (token.getToknum() == 773) {
                                this.fontVar = this.tm.loadVar(false);
                                break;
                            }
                            if (token.getToknum() == 61) {
                                boolean bl3 = true;
                                this.tm.ungetToken();
                                this.font = this.tm.loadString(false);
                                if (this.font.toUpperCase().equals("TRADITIONAL") || this.font.toUpperCase().equals("FIXED") || this.font.toUpperCase().equals("LARGE") || this.font.toUpperCase().equals("SMALL") || this.font.toUpperCase().equals("MEDIUM") || this.font.toUpperCase().equals("DEFAULT")) {
                                    token = this.tm.getToken();
                                    if (token == null || token.getToknum() == 405) break;
                                    this.tm.ungetToken();
                                    break;
                                }
                                token = this.tm.getToken();
                                if (token != null && token.getToknum() == 405) {
                                    token = this.tm.getToken();
                                    if (token != null && token.getToknum() == 773) {
                                        this.fontVar = this.tm.loadVar(false);
                                        break;
                                    }
                                    while (bl3 && token != null && token.getToknum() != 44 && token.getToknum() != 41) {
                                        this.font = this.font + " " + token.getWord();
                                        token = this.tm.getToken();
                                        if (token == null || token.getToknum() != 405) continue;
                                        token = this.tm.getToken();
                                        if (token != null && token.getToknum() == 773) {
                                            this.fontVar = this.tm.loadVar(false);
                                            bl3 = false;
                                            continue;
                                        }
                                        this.tm.ungetToken();
                                    }
                                    token = this.tm.getToken();
                                    if (token == null || token.getToknum() != 44 && token.getToknum() != 41) break;
                                    this.tm.ungetToken();
                                    break;
                                }
                                if (token == null) break;
                                while (bl3 && token != null && token.getToknum() != 44 && token.getToknum() != 41) {
                                    this.font = this.font + " " + token.getWord();
                                    token = this.tm.getToken();
                                    if (token == null || token.getToknum() != 405) continue;
                                    token = this.tm.getToken();
                                    if (token != null && token.getToknum() == 773) {
                                        this.fontVar = this.tm.loadVar(false);
                                        bl3 = false;
                                        continue;
                                    }
                                    this.tm.ungetToken();
                                }
                                token = this.tm.getToken();
                                if (token == null || token.getToknum() != 44 && token.getToknum() != 41) break;
                                this.tm.ungetToken();
                                break;
                            }
                            bl = false;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 307: {
                        token = this.tm.getToken();
                        if (token != null && token.getWord().equals("PROTECTION")) {
                            this.cellProt = this.tm.loadInt(false);
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 319: {
                        token = this.tm.getToken();
                        if (token != null && (token.getToknum() == 773 || token.getToknum() == 795)) {
                            this.colorVar = this.tm.loadVar(false);
                            break;
                        }
                        if (token.getToknum() == 61) {
                            this.tm.ungetToken();
                            this.color = this.tm.loadInt(false);
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 443: {
                        token = this.tm.getToken();
                        if (token != null) {
                            if (token.getToknum() == 352) {
                                token = this.tm.getToken();
                                if (token != null && token.getToknum() == 773) {
                                    this.hiddenDataVar = this.tm.loadVar(false);
                                    break;
                                }
                                if (token.getToknum() == 61) {
                                    this.tm.ungetToken();
                                    this.hiddenData = this.tm.loadString(false);
                                    break;
                                }
                                bl = false;
                                break;
                            }
                            bl = false;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 41: {
                        bl2 = false;
                        break;
                    }
                    default: {
                        this.tm.ungetToken();
                        bl = false;
                    }
                }
                if (!bl || !bl2) continue;
                token = this.tm.getToken();
            }
            if (!bl && token != null) {
                IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + this.tm.getFileName(), 0, "CellItemObj Unexpected token: " + token.getWord() + " At line:" + token.getFLN(), null));
                token = this.tm.getTokNL();
                if (token != null) {
                    this.tm.ungetToken();
                }
            } else if (!bl) {
                IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + this.tm.getFileName(), 0, "CellItemObj Unexpected token:null!", null));
            }
        }
        catch (InternalErrorException internalErrorException) {
            throw internalErrorException;
        }
        catch (Exception exception) {
            throw new InternalErrorException("CellItem exception: " + exception + " on line " + this.lines.lastElement());
        }
    }

    void printDebug() {
        System.out.println("     ------>CellItem begin");
        System.out.println("     x [" + this.x + "]");
        System.out.println("     y [" + this.y + "]");
        System.out.println("     data [" + this.data + "]");
        System.out.println("     divi [" + this.divi + "]");
        System.out.println("     font [" + this.font + "]");
        System.out.println("     fontVar [" + this.fontVar + "]");
        System.out.println("     cellProt [" + this.cellProt + "]");
    }

    public String getData() {
        return this.data;
    }

    public String getDataVar() {
        return this.dataVar;
    }

    public int getDivider() {
        return this.divi;
    }

    public FontType getFont() {
        if (this.font.toUpperCase().equals("TRADITIONAL")) {
            return FontType.getStandardFont((String)"Traditional-Font");
        }
        if (this.font.toUpperCase().equals("FIXED")) {
            return FontType.getStandardFont((String)"Fixed-Font");
        }
        if (this.font.toUpperCase().equals("LARGE")) {
            return FontType.getStandardFont((String)"Large-Font");
        }
        if (this.font.toUpperCase().equals("SMALL")) {
            return FontType.getStandardFont((String)"Small-Font");
        }
        if (this.font.toUpperCase().equals("MEDIUM")) {
            return FontType.getStandardFont((String)"Medium-Font");
        }
        if (this.font.toUpperCase().equals("DEFAULT")) {
            return FontType.getStandardFont((String)"Default-Font");
        }
        if (this.font.equals("")) {
            return FontType.getStandardFont((String)"Default-Font");
        }
        FontType fontType = null;
        if (this.fontVar.equals("")) {
            this.fontVar = this.font.replace(' ', '-');
        }
        if (this.font.indexOf(47) < 0) {
            fontType = new FontType(this.font);
            fontType.setSize(9.0f);
        } else {
            this.tm.makeVar(this.fontVar);
            fontType = CellItemObj.getFont((String)this.font);
        }
        if (fontType != null) {
            fontType.setHandleName(this.fontVar);
        }
        return fontType;
    }

    public ColorType getColor() {
        return new ColorType(this.color);
    }

    public String getColorVar() {
        return this.colorVar;
    }

    public String getFontVar() {
        return this.fontVar;
    }

    public int getX() {
        return this.x;
    }

    public String getHiddenData() {
        return this.hiddenData;
    }

    public String getHiddenDataVar() {
        return this.hiddenDataVar;
    }

    public int getY() {
        return this.y;
    }

    public boolean getProt() {
        return this.cellProt != 0;
    }

    public String getBitmap() {
        return this.bitmap;
    }

    public String getBitmapHandle() {
        return this.bitmapHand;
    }

    public int getBitmapWidt() {
        return this.bitmapWidt;
    }

    public int getBitmapNumber() {
        return this.bitmapNumber;
    }
}

