/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.programimport;

import com.iscobol.filedesigner.FileDescriptor;
import com.iscobol.filedesigner.ScreenFD_SL;
import com.iscobol.screenpainter.beans.types.SettingTreeItem;
import com.iscobol.screenpainter.beans.types.SignClause;
import com.iscobol.screenpainter.beans.types.SpecialNamesClause;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.beans.types.VariableTypeList;
import com.iscobol.screenpainter.beans.types.VariableUsage;
import com.iscobol.screenpainter.programimport.Errors;
import com.iscobol.screenpainter.programimport.InternalErrorException;
import com.iscobol.screenpainter.programimport.IsConsolePlugin;
import com.iscobol.screenpainter.programimport.ProjectToken;
import com.iscobol.screenpainter.programimport.Token;
import com.iscobol.screenpainter.programimport.TokenManager;
import com.iscobol.screenpainter.programimport.Utilities;
import com.iscobol.screenpainter.programimport.WorkItem;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.runtime.Status;

public class FileDefinitionDlt
implements ProjectToken {
    private int m_ntype;
    private boolean m_bblockrecords;
    private boolean m_brecord;
    private boolean m_brecordfixed;
    private int m_nblockmax;
    private int m_nblockmin;
    private int m_nrecordmax;
    private int m_nrecordmin;
    private int m_bdata;
    private boolean m_bstandard = true;
    private boolean m_bexternal = true;
    private boolean m_blabel = true;
    private String m_strprefix;
    private String m_strcodeset;
    private String m_strfileidvalue;
    private String m_strxfdfile;
    private String m_strrecorddepend;
    private StringBuilder description = new StringBuilder();
    private Vector fields = new Vector();
    private Errors error;
    private TokenManager tm;
    private WorkItem lastField;
    private WorkItem lastAdded;
    private boolean positioned;
    private String actLin;
    private FileDescriptor fileDes;

    public FileDefinitionDlt(TokenManager tokenManager, Errors errors, Vector vector, ScreenFD_SL screenFD_SL, String string) throws InternalErrorException {
        this.fileDes = screenFD_SL.getFileDescriptor();
        VariableTypeList variableTypeList = screenFD_SL.getFdItems();
        this.tm = tokenManager;
        this.error = errors;
        this.fileDes = screenFD_SL.getFileDescriptor();
        this.loadFileDef(vector, string);
        this.loadFields(vector, (WorkItem)null, string);
        if (this.lastField != this.lastAdded && (this.lastAdded.children.isEmpty() || this.lastAdded.getLastElement() != this.lastField) && this.lastField.getLevel() != 78 && this.lastField.getLevel() != 66 && this.lastField.getLevel() != 88 && this.lastAdded.getLastChild() != this.lastField) {
            this.fields.add(this.lastField);
        }
        Enumeration enumeration = this.fields.elements();
        while (enumeration.hasMoreElements()) {
            WorkItem workItem = (WorkItem)enumeration.nextElement();
            VariableType variableType = this.setVariable(screenFD_SL, workItem, null);
            variableTypeList.addVariable(variableType);
        }
        try {
            this.tm.ungetToken();
        }
        catch (Exception exception) {
            throw new InternalErrorException("Exception in FileDefinitionDlt " + exception + " on line " + vector.lastElement());
        }
    }

    boolean loadFileDef(Vector vector, String string) throws InternalErrorException {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Token token = this.tm.getToken();
            int n = token.getFLN();
            while (token != null && bl) {
                switch (token.getToknum()) {
                    case 552: {
                        this.m_ntype = this.tm.loadInt();
                        break;
                    }
                    case 490: {
                        this.m_bblockrecords = this.tm.loadBool();
                        this.fileDes.setBlockRecords(this.m_bblockrecords);
                        this.fileDes.setUseBlockAttributes(true);
                        break;
                    }
                    case 491: {
                        this.m_bblockrecords = this.tm.loadBool();
                        break;
                    }
                    case 494: {
                        this.m_bdata = this.tm.loadInt();
                        break;
                    }
                    case 506: {
                        this.m_brecord = this.tm.loadBool();
                        this.fileDes.setUseRecordAttributes(true);
                        break;
                    }
                    case 507: {
                        this.m_brecordfixed = this.tm.loadBool();
                        break;
                    }
                    case 510: {
                        this.tm.loadBool();
                        break;
                    }
                    case 528: {
                        this.m_nblockmax = this.tm.loadInt();
                        this.fileDes.setBlockMaxSize(this.m_nblockmax);
                        break;
                    }
                    case 529: {
                        this.m_nblockmin = this.tm.loadInt();
                        this.fileDes.setBlockMinSize(this.m_nblockmin);
                        break;
                    }
                    case 544: {
                        this.m_nrecordmax = this.tm.loadInt();
                        this.fileDes.setRecordMaxSize(this.m_nrecordmax);
                        break;
                    }
                    case 545: {
                        this.m_nrecordmax = this.tm.loadInt();
                        this.fileDes.setRecordMinSize(this.m_nrecordmin);
                        break;
                    }
                    case 500: {
                        this.m_blabel = this.tm.loadBool();
                        this.fileDes.setLabelRecordStd(this.m_blabel);
                        this.fileDes.setUseLabelAttributes(true);
                        break;
                    }
                    case 497: {
                        this.m_bexternal = this.tm.loadBool();
                        this.fileDes.setExternal(this.m_bexternal);
                        break;
                    }
                    case 509: {
                        this.m_bstandard = this.tm.loadBool();
                        this.fileDes.setLabelRecordStd(this.m_bstandard);
                        break;
                    }
                    case 617: {
                        this.m_strprefix = this.tm.loadString();
                        break;
                    }
                    case 799: {
                        this.m_strcodeset = this.tm.loadString();
                        this.fileDes.setCodeSetName(this.m_strcodeset);
                        break;
                    }
                    case 610: {
                        this.m_strfileidvalue = this.tm.loadString();
                        this.fileDes.setValueFileId(this.m_strfileidvalue);
                        break;
                    }
                    case 629: {
                        this.m_strxfdfile = this.tm.loadString();
                        this.fileDes.setFileDirective(this.m_strxfdfile);
                        break;
                    }
                    case 623: {
                        this.m_strrecorddepend = this.tm.loadString();
                        this.fileDes.setRecordDepend(this.m_strrecorddepend);
                        break;
                    }
                    default: {
                        if (token.getToknum() == 123) break;
                        IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + string, 0, string + ": In FILE_DEFINITION Unexpected token: " + token.getWord() + " At line:" + token.getFLN(), null));
                        this.tm.loadString();
                    }
                }
                if (n != token.getFLN() && (stringBuilder = (StringBuilder)vector.lastElement()).toString().trim().equals("{{@FD_m_strDescription")) {
                    this.description = this.tm.getDescr(false);
                    this.fileDes.setComment(this.description.toString());
                    bl = false;
                }
                n = token.getFLN();
                if (!bl) continue;
                token = this.tm.getToken();
            }
        }
        catch (InternalErrorException internalErrorException) {
            throw internalErrorException;
        }
        catch (Exception exception) {
            throw new InternalErrorException("Exception in FileDefinitionDlt " + exception + " on line " + vector.lastElement());
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    WorkItem loadFields(Vector vector, WorkItem workItem, String string) throws InternalErrorException {
        WorkItem workItem2 = null;
        WorkItem workItem3 = null;
        boolean bl = true;
        try {
            Token token = this.tm.getToken();
            this.actLin = ((StringBuilder)vector.lastElement()).toString();
            while (bl && token != null && this.actLin.length() > 7 && this.actLin.substring(0, 7).equals("[FDITEM")) {
                if (workItem3 != null) {
                    workItem2 = workItem3;
                    workItem3 = null;
                } else {
                    workItem2 = new WorkItem(this.tm, this.error, vector);
                    this.positioned = false;
                    if (workItem2.getLevel() != 88 && workItem2.getLevel() != 78 && workItem2.getLevel() != 66) {
                        this.lastField = workItem2;
                    }
                }
                if (workItem2.getLevel() == 78) {
                    this.fields.add(workItem2);
                    this.lastAdded = workItem2;
                } else if (workItem2.getLevel() == 66) {
                    this.fields.add(workItem2);
                    this.lastAdded = workItem2;
                } else if (workItem2.getLevel() == 88) {
                    if (this.lastField != null) {
                        this.lastField.addChild(workItem2);
                    }
                } else {
                    if (workItem != null && workItem.getLevel() >= workItem2.getLevel()) {
                        return workItem2;
                    }
                    if (workItem2.getLevel() == 77 || workItem2.getLevel() == 1 && workItem2.havePic()) {
                        if (workItem != null) return workItem2;
                        this.fields.add(workItem2);
                        this.lastAdded = workItem2;
                    } else if (!workItem2.havePic()) {
                        if (workItem == null) {
                            this.fields.add(workItem2);
                            this.lastAdded = workItem2;
                            workItem3 = this.loadFields(vector, workItem2, string);
                        } else if (workItem.getLevel() < workItem2.getLevel()) {
                            workItem.addChild(workItem2);
                            workItem3 = this.loadFields(vector, workItem2, string);
                        } else if (workItem.getLevel() >= workItem2.getLevel()) {
                            return workItem2;
                        }
                    } else {
                        if (workItem == null) {
                            workItem = this.lastField;
                        }
                        workItem.addChild(workItem2);
                    }
                }
                if (this.positioned) continue;
                token = this.tm.getToken();
                this.actLin = ((StringBuilder)vector.lastElement()).toString();
                if (this.actLin.toString().trim().equals("@}}")) {
                    token = this.tm.getTokNL();
                    this.actLin = ((StringBuilder)vector.lastElement()).toString();
                }
                this.positioned = true;
            }
            this.tm.ungetToken();
            return null;
        }
        catch (InternalErrorException internalErrorException) {
            throw internalErrorException;
        }
        catch (Exception exception) {
            throw new InternalErrorException("Exception loadFields FileDefinitionDlt " + exception + " on line " + vector.lastElement());
        }
    }

    void loadVar(ScreenFD_SL screenFD_SL) {
        Enumeration enumeration = this.fields.elements();
        while (enumeration.hasMoreElements()) {
            WorkItem workItem = (WorkItem)enumeration.nextElement();
            this.setVariable(screenFD_SL, workItem, null);
        }
    }

    VariableType setVariable(ScreenFD_SL screenFD_SL, WorkItem workItem, VariableType variableType) {
        int n = workItem.getLevel();
        VariableType variableType2 = VariableType.newInstance((int)n);
        variableType2.setName(workItem.getName());
        variableType2.setInLinkage(false);
        if (!workItem.getPic().equals("PIC78")) {
            variableType2.setPicture(workItem.getPic());
        }
        variableType2.setValue(workItem.getValue());
        variableType2.setFalseValue(workItem.getFalseValue());
        variableType2.setRedefines(workItem.getRedefines());
        variableType2.setUsage(new VariableUsage(VariableUsage.acuUsage2IsUsage((int)workItem.getUsage())));
        if (workItem.getUsage() > 54) {
            IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter", 0, "In File Definition Unexpected usage:" + workItem.getUsage() + " for variable " + workItem.getName(), null));
        }
        variableType2.setStrRawPic(workItem.getStrRawPic());
        variableType2.setStrRawMin(workItem.getStrRawMin());
        variableType2.setStrRawMax(workItem.getStrRawMax());
        variableType2.setStrAlias(workItem.getStrAlias());
        variableType2.setNType(workItem.getNType());
        variableType2.setBlankWhenZero(workItem.getNBlank() != 0);
        int n2 = workItem.getNSpecial();
        n2 = n2 >= 0 && n2 < SpecialNamesClause.acu2is.length ? SpecialNamesClause.acu2is[n2] : 0;
        variableType2.setSpecialNames(new SpecialNamesClause(n2));
        variableType2.setExternal(workItem.getNExternal() != 0);
        variableType2.setBRedefines(workItem.getBRedefines());
        variableType2.setBValue(workItem.getBValue());
        variableType2.setBIndex(workItem.getBIndexed());
        Utilities.setOccurs((WorkItem)workItem, (VariableType)variableType2);
        variableType2.getOccurs().setFixed(workItem.getBFixed());
        variableType2.setSynchronized(workItem.getNSync() != 0);
        variableType2.setJustified(workItem.getNJustified() != 0);
        variableType2.setLstIndex(workItem.getLstIndex());
        Utilities.setCopyAttributes((WorkItem)workItem, (VariableType)variableType2);
        variableType2.setComment(workItem.getDesc());
        variableType2.setSign(new SignClause(workItem.getNSign()));
        if (workItem.getHaveXFD()) {
            variableType2.setXFDAttributes(workItem.getXFDAttribues());
        }
        int n3 = 0;
        Enumeration enumeration = workItem.children.elements();
        while (enumeration.hasMoreElements()) {
            WorkItem workItem2 = (WorkItem)enumeration.nextElement();
            variableType2.addChild(++n3, (SettingTreeItem)this.setVariable(screenFD_SL, workItem2, variableType2));
        }
        return variableType2;
    }
}

