/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.programimport;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class OptionList
implements Cloneable {
    public static final String CLO = "-clo=";
    public static final String CPO = "-cpo";
    public static final String CSO = "-cso";
    public static final String CWO = "-cwo";
    public static final String D = "-d";
    public static final String HELP = "-help";
    public static final String OD = "-od";
    public static final String V = "-v";
    private static Hashtable allOpts = new Hashtable();
    private static Hashtable directoryOpts = new Hashtable();
    private static Hashtable pathListOpts = new Hashtable();
    private Hashtable optArgs = new Hashtable();
    private String[] notOptArgs = new String[]{""};
    private int errorNum = 0;
    private String error;

    public Object clone() {
        OptionList optionList;
        try {
            optionList = (OptionList)super.clone();
            optionList.optArgs = (Hashtable)this.optArgs.clone();
            optionList.notOptArgs = (String[])this.notOptArgs.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            optionList = null;
        }
        return optionList;
    }

    public OptionList() {
        String[] stringArray = new String[]{"  "};
        this.addOptions(stringArray);
    }

    public OptionList(String[] stringArray) {
        this.addOptions(stringArray);
    }

    boolean hasErrors() {
        return this.error != null;
    }

    String getErrors() {
        return this.error;
    }

    int getErrorNum() {
        return this.errorNum;
    }

    public boolean addOption(String string) {
        boolean bl = true;
        int n = string.indexOf(61) + 1;
        if (string.charAt(0) == '#') {
            string = '-' + string.substring(1, string.length());
            if (n > 1) {
                this.optArgs.remove(string.substring(0, n).toLowerCase());
            } else {
                this.optArgs.remove(string.toLowerCase());
            }
        } else if (n > 1 && allOpts.containsKey(string.substring(0, n).toLowerCase())) {
            this.optArgs.put(string.substring(0, n).toLowerCase(), string.substring(n));
        } else if (allOpts.containsKey(string.toLowerCase())) {
            this.optArgs.put(string.toLowerCase(), "");
        } else {
            bl = false;
        }
        return bl;
    }

    public void addOptions(String[] stringArray) {
        this.addOptions(stringArray, false);
    }

    public void addOptions(String[] stringArray, boolean bl) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.addOption(stringArray[i]) || bl) continue;
            if (stringArray[i].startsWith("-")) {
                this.errorNum = 20;
                this.error = stringArray[i];
                continue;
            }
            vector.addElement(stringArray[i]);
        }
        if (!bl) {
            this.notOptArgs = vector.toArray(this.notOptArgs);
        }
    }

    public String getOption(String string) {
        return (String)this.optArgs.get(string.toLowerCase());
    }

    public int getOption(String string, int n) {
        int n2;
        String string2 = (String)this.optArgs.get(string.toLowerCase());
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (Exception exception) {
            n2 = n;
        }
        return n2;
    }

    public String[] getArgs() {
        return this.notOptArgs;
    }

    public String getAll() {
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration enumeration = this.optArgs.keys();
        if (enumeration.hasMoreElements()) {
            while (true) {
                Object k = enumeration.nextElement();
                stringBuilder.append(k + this.getOption((String)k));
                if (!enumeration.hasMoreElements()) break;
                stringBuilder.append(" ");
            }
        }
        return stringBuilder.toString();
    }

    public void help() {
        Vector<String> vector = new Vector<String>();
        Enumeration<Object> enumeration = allOpts.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = allOpts.get(k);
            vector.addElement((k.toString() + "       ").substring(0, 8) + v);
        }
        Collections.sort(vector);
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println(enumeration.nextElement());
        }
    }

    public static int getAllOptionCount() {
        return allOpts.size();
    }

    public static Enumeration getAllOptionKeys(boolean bl) {
        Enumeration<Object> enumeration = allOpts.keys();
        if (bl) {
            Vector vector = new Vector();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            Collections.sort(vector);
            enumeration = vector.elements();
        }
        return enumeration;
    }

    public static String getOptionDesc(String string) {
        return allOpts.get(string).toString();
    }

    public static boolean hasValue(String string) {
        return string.endsWith("=") && allOpts.get(string) != null;
    }

    public static boolean valueIsDirectory(String string) {
        return directoryOpts.get(string) != null;
    }

    public static boolean valueIsPath(String string) {
        return pathListOpts.get(string) != null;
    }

    static {
        allOpts.put(HELP, "Display this help and exits");
        allOpts.put(CLO, "Copy LINKAGE in specified directory");
        allOpts.put(CPO, "Copy PROCEDURE in specified directory");
        allOpts.put(CSO, "Copy SCREEN in specified directory");
        allOpts.put(CWO, "Copy WORKING in specified directory");
        allOpts.put(D, "Debugging mode");
        allOpts.put(OD, "Output directory");
        allOpts.put(V, "Version");
        directoryOpts.put(CLO, CLO);
        directoryOpts.put(CPO, CPO);
        directoryOpts.put(CSO, CSO);
        directoryOpts.put(CWO, CWO);
        directoryOpts.put(OD, OD);
    }
}

