/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.programimport;

import com.iscobol.screenpainter.IscobolScreenPainterPlugin;
import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.types.DataSet;
import com.iscobol.screenpainter.beans.types.FDAttributes;
import com.iscobol.screenpainter.beans.types.OpenLockMode;
import com.iscobol.screenpainter.beans.types.OpenMode;
import com.iscobol.screenpainter.programimport.DataContentAcb;
import com.iscobol.screenpainter.programimport.EmbeddingAcb;
import com.iscobol.screenpainter.programimport.EndOfProgramException;
import com.iscobol.screenpainter.programimport.Errors;
import com.iscobol.screenpainter.programimport.ImpAcb;
import com.iscobol.screenpainter.programimport.InternalErrorException;
import com.iscobol.screenpainter.programimport.IsConsolePlugin;
import com.iscobol.screenpainter.programimport.LinkageAcb;
import com.iscobol.screenpainter.programimport.ParagraphAcb;
import com.iscobol.screenpainter.programimport.ProjectToken;
import com.iscobol.screenpainter.programimport.ReportAcb;
import com.iscobol.screenpainter.programimport.ScreenAcb;
import com.iscobol.screenpainter.programimport.SelLayoutContentAcb;
import com.iscobol.screenpainter.programimport.Token;
import com.iscobol.screenpainter.programimport.TokenManager;
import com.iscobol.screenpainter.programimport.WorkItem;
import com.iscobol.screenpainter.programimport.WorkingAcb;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.runtime.Status;

public class ProgramAcb
implements ProjectToken {
    private String progName = "";
    private boolean dirtyAfterGen = false;
    private boolean quitConfirm = true;
    private boolean initProgram = false;
    private String mainScreenName = "";
    private String iconFilePath = "";
    private String beforeProgram = "";
    private String afterProgram = "";
    private String beforeInit = "";
    private String afterInit = "";
    private String beforeOpen = "";
    private String afterOpen = "";
    private String beforeClose = "";
    private String afterClose = "";
    private StringBuilder description = new StringBuilder();
    private WorkingAcb work;
    private LinkageAcb link;
    ScreenAcb screen;
    ReportAcb report;
    ParagraphAcb paragraph;
    DataContentAcb dataContent;
    SelLayoutContentAcb selLayoutContent;
    EmbeddingAcb embedding;
    private TokenManager tm;
    ImpAcb impAcb;
    boolean needMainScreen;

    public ProgramAcb(String string, TokenManager tokenManager, Errors errors, Vector vector, ScreenProgram screenProgram, ImpAcb impAcb) throws InternalErrorException {
        boolean bl = true;
        this.impAcb = impAcb;
        this.progName = string;
        this.tm = tokenManager;
        Token token = null;
        Token token2 = null;
        try {
            token = token2 = this.tm.getToken();
            while (token2 != null && bl) {
                if (token.getToknum() == 91 && token2.getToknum() == 687) {
                    bl = false;
                    continue;
                }
                token = token2;
                token2 = this.tm.getToken();
            }
            if (token2 == null) {
                throw new InternalErrorException("[PROGRAM_CONTENT] not found! on line " + vector.lastElement());
            }
            token2 = this.tm.getToken();
            if (token2 == null || token2.getToknum() != 93) {
                throw new InternalErrorException("[PROGRAM_CONTENT] not found! on line " + vector.lastElement());
            }
        }
        catch (InternalErrorException internalErrorException) {
            throw internalErrorException;
        }
        catch (Exception exception) {
            throw new InternalErrorException("Error " + exception + " on line " + vector.lastElement());
        }
        boolean bl2 = IscobolScreenPainterPlugin.getBooleanFromStore((String)"iscobol.progfile.ansi");
        boolean[] blArray = new boolean[]{bl2};
        this.loadProg(vector, screenProgram, blArray);
        if (this.tm.getIsTotem()) {
            this.loadBeforeAfterProg(vector, screenProgram);
        }
        if (screenProgram.getProgramNamingConvention() == 2 && bl2 != blArray[0]) {
            screenProgram.setFollowDefaultFlag(false);
        }
        this.work = new WorkingAcb(tokenManager, errors, vector, screenProgram, this.progName);
        this.tm.setWork(this.work);
        this.link = new LinkageAcb(tokenManager, errors, vector, screenProgram);
        this.dataContent = new DataContentAcb(tokenManager, errors, vector, screenProgram);
        this.selLayoutContent = new SelLayoutContentAcb(tokenManager, errors, vector, screenProgram);
        this.screen = new ScreenAcb(tokenManager, errors, vector, screenProgram, impAcb);
        if (((StringBuilder)vector.lastElement()).toString().trim().length() < 9 || !((StringBuilder)vector.lastElement()).toString().trim().equals("{{@PARAGRAPH:") && !((StringBuilder)vector.lastElement()).toString().trim().substring(0, 10).equals("[EXTERNAL_")) {
            this.report = new ReportAcb(tokenManager, errors, vector, screenProgram, impAcb);
        }
        if (this.tm.getIsTotem()) {
            this.embedding = new EmbeddingAcb(tokenManager, errors, vector, screenProgram);
        } else {
            this.loadBeforeParagraph(vector, screenProgram);
            this.paragraph = new ParagraphAcb(tokenManager, errors, vector, screenProgram);
        }
        this.loadBeforeAfterProg(vector, screenProgram);
        this.work.loadVar(screenProgram);
        this.link.loadVar(screenProgram);
    }

    boolean loadProg(Vector vector, ScreenProgram screenProgram, boolean[] blArray) throws InternalErrorException {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Token token = this.tm.getToken();
            int n = token.getFLN();
            while (token != null && bl) {
                switch (token.getToknum()) {
                    case 368: {
                        this.dirtyAfterGen = this.tm.loadBool();
                        break;
                    }
                    case 694: {
                        this.quitConfirm = this.tm.loadBool();
                        break;
                    }
                    case 455: {
                        this.initProgram = this.tm.loadBool();
                        if (!this.initProgram) break;
                        screenProgram.setProgramIdClause(1);
                        break;
                    }
                    case 485: {
                        this.mainScreenName = this.tm.loadString();
                        screenProgram.setMainScreen(this.mainScreenName);
                        break;
                    }
                    case 448: {
                        this.iconFilePath = this.tm.loadString();
                        break;
                    }
                    case 293: {
                        this.beforeProgram = this.tm.loadString();
                        screenProgram.setBeforeProgramProcedure(this.beforeProgram);
                        break;
                    }
                    case 273: {
                        this.afterProgram = this.tm.loadString();
                        screenProgram.setAfterProgramProcedure(this.afterProgram);
                        break;
                    }
                    case 291: {
                        this.beforeInit = this.tm.loadString();
                        screenProgram.setBeforeInitProcedure(this.beforeInit);
                        break;
                    }
                    case 271: {
                        this.afterInit = this.tm.loadString();
                        screenProgram.setAfterInitProcedure(this.afterInit);
                        break;
                    }
                    case 292: {
                        this.beforeOpen = this.tm.loadString();
                        screenProgram.setBeforeOpenProcedure(this.beforeOpen);
                        break;
                    }
                    case 272: {
                        this.afterOpen = this.tm.loadString();
                        screenProgram.setAfterOpenProcedure(this.afterOpen);
                        break;
                    }
                    case 288: {
                        this.beforeClose = this.tm.loadString();
                        screenProgram.setBeforeCloseProcedure(this.beforeClose);
                        break;
                    }
                    case 268: {
                        this.afterClose = this.tm.loadString();
                        screenProgram.setAfterCloseProcedure(this.afterClose);
                        break;
                    }
                    case 635: {
                        this.needMainScreen = this.tm.loadBool();
                        break;
                    }
                    case 281: {
                        blArray[0] = this.tm.loadBool();
                        screenProgram.setAnsiFormat(blArray[0]);
                        break;
                    }
                    case 690: {
                        this.tm.loadString();
                        break;
                    }
                    case 791: {
                        this.tm.loadString();
                        break;
                    }
                    case 363: {
                        this.tm.loadInt();
                        break;
                    }
                    case 771: {
                        this.tm.loadString();
                        break;
                    }
                    case 91: {
                        bl = false;
                        this.tm.ungetToken();
                        break;
                    }
                    default: {
                        if (token.getToknum() == 123) break;
                        IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + this.progName, 0, "In PROGRAM_CONTENT Unexpected token: " + token.getWord(), null));
                        this.tm.getToken();
                    }
                }
                screenProgram.setPromptWhenProgramExits(this.quitConfirm);
                if (n != token.getFLN() && (stringBuilder = (StringBuilder)vector.lastElement()).toString().trim().equals("{{@DESCRIPTION:")) {
                    this.description = this.tm.getDescr(false);
                    screenProgram.setRemarks(this.description.toString());
                    bl = false;
                }
                n = token.getFLN();
                if (!bl) continue;
                token = this.tm.getToken();
            }
        }
        catch (InternalErrorException internalErrorException) {
            throw internalErrorException;
        }
        catch (Exception exception) {
            throw new InternalErrorException("Exception in ProgramAcb " + exception + " on line " + vector.lastElement());
        }
        if (this.tm.hasDebug()) {
            System.out.println("------>Program content");
            System.out.println("progName [" + this.progName + "]");
            System.out.println("dirtyAfterGen [" + this.dirtyAfterGen + "]");
            System.out.println("quitConfirm [" + this.quitConfirm + "]");
            System.out.println("initProgram [" + this.initProgram + "]");
            System.out.println("mainScreenName [" + this.mainScreenName + "]");
            System.out.println("iconFilePath [" + this.iconFilePath + "]");
            System.out.println("beforeProgram [" + this.beforeProgram + "]");
            System.out.println("afterProgram [" + this.afterProgram + "]");
            System.out.println("beforeInit [" + this.beforeInit + "]");
            System.out.println("afterInit [" + this.afterInit + "]");
            System.out.println("beforeOpen [" + this.beforeOpen + "]");
            System.out.println("afterOpen [" + this.afterOpen + "]");
            System.out.println("beforeClose [" + this.beforeClose + "]");
            System.out.println("afterClose [" + this.afterClose + "]");
            System.out.println("description [" + this.description + "]");
            System.out.println("needMainScreen [" + this.description + "]");
        }
        return true;
    }

    boolean loadBeforeAfterProg(Vector vector, ScreenProgram screenProgram) throws InternalErrorException {
        boolean bl = true;
        Token token = null;
        Token token2 = null;
        try {
            token = token2 = this.tm.getToken();
            while (token2 != null && bl) {
                if (token.getToknum() == 91 && token2.getToknum() == 317) {
                    bl = false;
                    token2 = this.tm.getToken();
                    continue;
                }
                if (token.getToknum() == 91 && token2.getToknum() == 787) {
                    this.tm.ungetToken();
                    this.tm.ungetToken();
                    return true;
                }
                if (token.getToknum() == 91 && token2.getToknum() == 463) {
                    this.loadKeyStatus(vector, screenProgram);
                    token = token2;
                    token2 = this.tm.getToken();
                    continue;
                }
                if (token.getToknum() == 91 && token2.getWord().length() >= 8 && token2.getWord().substring(0, 8).equalsIgnoreCase("DMD-FILE")) {
                    this.loadTotemFile(vector, screenProgram);
                    token = token2;
                    token2 = this.tm.getToken();
                    continue;
                }
                if (token.getToknum() == 91 && token2.getWord().length() >= 12 && token2.getWord().substring(0, 12).equalsIgnoreCase("DMD-DOCUMENT")) {
                    this.loadDocument(vector, screenProgram);
                    token = token2;
                    token2 = this.tm.getToken();
                    continue;
                }
                token = token2;
                token2 = this.tm.getToken();
            }
            if (token2 != null) {
                token2 = this.tm.getToken();
                bl = true;
                while (token2 != null && bl) {
                    switch (token2.getToknum()) {
                        case 404: {
                            screenProgram.setFollowDefaultFlag(this.tm.loadBool());
                            break;
                        }
                        case 424: {
                            screenProgram.setGenerateProgramFile(this.tm.loadBool());
                            break;
                        }
                        case 427: {
                            screenProgram.setGenerateWorkingFile(this.tm.loadBool());
                            break;
                        }
                        case 410: {
                            screenProgram.setGenerateEventFile(this.tm.loadBool());
                            break;
                        }
                        case 426: {
                            screenProgram.setGenerateScreenFile(this.tm.loadBool());
                            break;
                        }
                        case 425: {
                            this.tm.loadBool();
                            break;
                        }
                        case 423: {
                            screenProgram.setGenerateProcedureFile(this.tm.loadBool());
                            break;
                        }
                        case 422: {
                            screenProgram.setGenerateMenuFile(this.tm.loadBool());
                            break;
                        }
                        case 421: {
                            screenProgram.setGenerateLinkageFile(this.tm.loadBool());
                            break;
                        }
                        case 699: {
                            screenProgram.setRegenerateTaggedAreaOnly(this.tm.loadBool());
                            break;
                        }
                        case 389: {
                            screenProgram.setExcludeVariablesInProgram(this.tm.loadBool());
                            break;
                        }
                        case 388: {
                            screenProgram.setExcludeParagraphsInProgram(this.tm.loadBool());
                            break;
                        }
                        case 688: {
                            screenProgram.setProgramFileSuffix(this.tm.loadString());
                            break;
                        }
                        case 788: {
                            screenProgram.setWorkingFileSuffix(this.tm.loadString());
                            break;
                        }
                        case 385: {
                            screenProgram.setEventFileSuffix(this.tm.loadString());
                            break;
                        }
                        case 716: {
                            screenProgram.setScreenFileSuffix(this.tm.loadString());
                            break;
                        }
                        case 701: {
                            this.tm.loadString();
                            break;
                        }
                        case 521: {
                            screenProgram.setMenuFileSuffix(this.tm.loadString());
                            break;
                        }
                        case 685: {
                            screenProgram.setProcedureFileSuffix(this.tm.loadString());
                            break;
                        }
                        case 477: {
                            screenProgram.setLinkageFileSuffix(this.tm.loadString());
                            break;
                        }
                        case 689: {
                            screenProgram.setProgramFileReadOnly(this.tm.loadBool());
                            break;
                        }
                        case 479: {
                            this.tm.loadInt();
                            break;
                        }
                        case 346: {
                            screenProgram.setCopyBookReadOnly(this.tm.loadBool());
                            break;
                        }
                        case 409: {
                            screenProgram.setSplitSource(this.tm.loadBool());
                            break;
                        }
                        case 282: {
                            screenProgram.setAnsiFormat(this.tm.loadBool());
                            break;
                        }
                        case 258: {
                            this.tm.loadBool();
                            break;
                        }
                        case 363: {
                            this.tm.loadInt();
                            break;
                        }
                        case 771: {
                            this.tm.loadString();
                            break;
                        }
                        case 91: {
                            bl = false;
                            this.tm.ungetToken();
                            break;
                        }
                        default: {
                            if (token2.getToknum() == 123) break;
                            IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + this.progName, 0, "In CODE_GENERATION_OPTION Unexpected token:" + token2.getWord(), null));
                            this.tm.loadString();
                        }
                    }
                    if (!bl) continue;
                    token2 = this.tm.getToken();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    boolean loadKeyStatus(Vector vector, ScreenProgram screenProgram) throws InternalErrorException {
        int n = 0;
        boolean bl = true;
        String string = null;
        Vector<Object> vector2 = new Vector<Object>();
        Vector<String> vector3 = new Vector<String>();
        Token token = null;
        Token token2 = null;
        try {
            WorkItem workItem;
            Object object;
            token2 = this.tm.getToken();
            token2 = this.tm.getToken();
            if (token2.getToknum() == 640) {
                screenProgram.setGenerateKeyStatus(!this.tm.loadBool());
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 464) {
                screenProgram.setKeyStatusName(this.tm.loadString());
                token2 = this.tm.getToken();
            }
            if (token2.getToknum() == 673) {
                screenProgram.setKeyStatusPicture(this.tm.loadString());
                token2 = this.tm.getToken();
                if (token2.getToknum() == 768) {
                    string = this.tm.loadString();
                    if (!string.toUpperCase().equals("[NONE]")) {
                        screenProgram.setKeyStatusUsage(new Float(string).intValue());
                    }
                } else if (token2.getToknum() != 123) {
                    IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + this.progName, 0, "In KEY_STATUS_FIELD_FORMAT expencted PIC found:" + token2.getWord(), null));
                    this.tm.loadString();
                }
            } else if (token2.getToknum() != 123) {
                IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + this.progName, 0, "In KEY_STATUS_FIELD_FORMAT expencted PIC found:" + token2.getWord(), null));
                this.tm.loadString();
            }
            token = token2;
            token2 = this.tm.getToken();
            while (token2 != null && bl) {
                if (token.getToknum() == 91 && token2.getToknum() == 317) {
                    bl = false;
                    continue;
                }
                if (token.getToknum() == 91 && token2.getToknum() == 462) {
                    token2 = this.tm.getToken();
                    token2 = this.tm.getToken();
                    token2 = this.tm.getToken();
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 339) {
                        object = this.tm.loadString();
                        workItem = (WorkItem)this.tm.allVars.get(((String)object).toUpperCase().replace('_', '-'));
                        vector2.add(object);
                        if (workItem != null && workItem.isAdded()) {
                            this.tm.allVars.remove(((String)object).toUpperCase().replace('_', '-'));
                        }
                        if ((token2 = this.tm.getToken()).getToknum() == 772) {
                            vector3.add(this.tm.loadString());
                            continue;
                        }
                        throw new InternalErrorException("KEYSTATUS_CONTENT expected CONDITION found:" + token2.getWord());
                    }
                    throw new InternalErrorException("KEYSTATUS_CONTENT expected VALUE found:" + token2.getWord());
                }
                if (token.getToknum() == 91 && token2.getWord().equalsIgnoreCase("COBOLAID-DATASET-INFO")) {
                    bl = false;
                    continue;
                }
                token = token2;
                token2 = this.tm.getToken();
            }
            if (token2 != null) {
                if (vector2.size() > 0) {
                    object = new String[vector2.size()];
                    workItem = new String[vector3.size()];
                    for (n = 0; n < vector2.size(); ++n) {
                        object[n] = (String)vector2.elementAt(n);
                        workItem[n] = (String)vector3.elementAt(n);
                    }
                    screenProgram.setKeyStatusConditions((String[])object, (String[])workItem);
                }
                this.tm.ungetToken();
                this.tm.ungetToken();
            }
        }
        catch (InternalErrorException internalErrorException) {
            throw internalErrorException;
        }
        catch (Exception exception) {
            throw new InternalErrorException("Error " + exception + " on line " + vector.lastElement());
        }
        return true;
    }

    boolean loadBeforeParagraph(Vector vector, ScreenProgram screenProgram) throws InternalErrorException {
        boolean bl = true;
        String[] stringArray = null;
        String[] stringArray2 = null;
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        int n = 0;
        Token token = null;
        Token token2 = null;
        try {
            Enumeration enumeration;
            token = token2 = this.tm.getToken();
            while (token2 != null && bl) {
                if (token2.getToknum() == 123) {
                    bl = false;
                    this.tm.ungetToken();
                    continue;
                }
                if (token.getToknum() == 91 && token2.getToknum() == 392) {
                    token2 = this.tm.getToken();
                    token2 = this.tm.getToken();
                    token2 = this.tm.getToken();
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 672) {
                        vector3.add(this.tm.loadString());
                        continue;
                    }
                    throw new InternalErrorException("[EXTERNAL_PARAGRAPH:EP<n>] invalid syntax! on line " + vector.lastElement());
                }
                if (token.getToknum() == 91 && token2.getToknum() == 391) {
                    token2 = this.tm.getToken();
                    token2 = this.tm.getToken();
                    token2 = this.tm.getToken();
                    token2 = this.tm.getToken();
                    if (token2.getToknum() == 774) {
                        vector2.add(this.tm.loadString());
                        continue;
                    }
                    throw new InternalErrorException("[EXTERNAL_VARIABLE:EV<n>] invalid syntax! on line " + vector.lastElement());
                }
                token = token2;
                token2 = this.tm.getToken();
            }
            if (vector3.size() > 0) {
                stringArray2 = new String[vector3.capacity()];
                enumeration = vector3.elements();
                while (enumeration.hasMoreElements()) {
                    stringArray2[n] = (String)enumeration.nextElement();
                    ++n;
                }
                screenProgram.setExternalParagraphs(stringArray2);
            }
            if (vector2.size() > 0) {
                stringArray = new String[vector2.size()];
                n = 0;
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    stringArray[n] = (String)enumeration.nextElement();
                    ++n;
                }
                screenProgram.setExternalVariables(stringArray);
            }
        }
        catch (InternalErrorException internalErrorException) {
            throw internalErrorException;
        }
        catch (Exception exception) {
            throw new InternalErrorException("Error " + exception + " on line " + vector.lastElement());
        }
        return true;
    }

    boolean loadTotemFile(Vector vector, ScreenProgram screenProgram) throws InternalErrorException {
        boolean bl = true;
        String string = null;
        DataSet dataSet = new DataSet();
        FDAttributes fDAttributes = new FDAttributes();
        int n = 0;
        dataSet.setTotemCode(true);
        Token token = null;
        try {
            token = this.tm.getToken();
            token = this.tm.getToken();
            while (token != null && bl) {
                if (token.getToknum() == 91) {
                    bl = false;
                    this.tm.ungetToken();
                } else if (token.getWord().equalsIgnoreCase("OBJ-NAME")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("OBJ-ID")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("REL-M-OBJ-ID")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("ENTITY")) {
                    string = this.tm.loadString();
                    dataSet.setName(string);
                    dataSet.setFDName(string);
                    fDAttributes.setFDName(string);
                } else if (token.getWord().equalsIgnoreCase("LINK")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("LINK-NAME")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("DSN-SIZE")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("FD-SIZE")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("SL-SIZE")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("DSN-INFO-OPEN-MODE")) {
                    n = this.tm.loadInt();
                    fDAttributes.setOpenMode(new OpenMode(n + 1));
                } else if (token.getWord().equalsIgnoreCase("DSN-INFO-LOCK-OPTION")) {
                    n = this.tm.loadInt();
                    fDAttributes.setOpenLockMode(new OpenLockMode(n));
                } else if (token.getWord().equalsIgnoreCase("DSN-INFO-KEY-IS")) {
                    string = this.tm.loadString();
                    dataSet.setKeyName(string);
                } else if (token.getWord().equalsIgnoreCase("DSN-INFO-DATA-ORDER")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("DSN-INFO-START-VALUE")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("DSN-INFO-END-VALUE")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("DSN-INFO-PRIMARY")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("DSN-INFO-OPEN")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("DSN-INFO-CLOSE")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("DSN-INFO-EXCLUSIVE")) {
                    fDAttributes.setExclusive(this.tm.loadBool());
                } else if (token.getWord().equalsIgnoreCase("DSN-INFO-IS-LOGICAL")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("DSN-INFO-LOGICAL-FDNAME")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("DSN-INFO-ORIGINAL-FDNAME")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("DSN-INFO-REPLACEBY-FILESTATUS")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("DSN-INFO-REPLACEBY-FDDATA")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("DSN-INFO-REPLACEBY-RELATIVEKEY")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("DSN-INFO-REPLACEBY-SLDATA")) {
                    string = this.tm.loadString();
                } else if (token.getToknum() == 123) {
                    this.description = this.tm.getDescr(false);
                } else {
                    IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + this.progName, 0, "loadTotemFile found the unexpected token:" + token.getWord(), null));
                    this.tm.loadString();
                }
                if (!bl) continue;
                token = this.tm.getToken();
            }
        }
        catch (Exception exception) {
            if (exception instanceof EndOfProgramException) {
                this.dataContent.getFileSection().addDataSet(dataSet);
            }
            throw new InternalErrorException("Error " + exception + " on line " + vector.lastElement());
        }
        this.dataContent.getFileSection().addDataSet(dataSet);
        return true;
    }

    boolean loadDocument(Vector vector, ScreenProgram screenProgram) throws InternalErrorException {
        boolean bl = true;
        String string = "";
        Token token = null;
        try {
            token = this.tm.getToken();
            token = this.tm.getToken();
            while (token != null && bl) {
                if (token.getToknum() == 91) {
                    bl = false;
                    this.tm.ungetToken();
                } else if (token.getWord().equalsIgnoreCase("OBJ-NAME")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("OBJ-ID")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("FILE-TITLE-TYPE")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("FILE-SHOW-ITEM")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("FILE-SHOW-KEY")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("FILE-SHOW-PIC")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("FILE-SHOW-HEAD")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("FILE-SHOW-LEVEL")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("FILE-SHOW-TREE")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("FILE-SHOW-CLPS")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("FILE-SHOW-BMP")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("FILE-SHOW-LINE")) {
                    string = this.tm.loadString();
                } else if (token.getWord().equalsIgnoreCase("FILE-SHOW-MINIZE")) {
                    string = this.tm.loadString();
                } else if (token.getToknum() == 123) {
                    this.description = this.tm.getDescr(false);
                } else {
                    IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + this.progName, 0, "loadDocument found the unexpected token:" + token.getWord(), null));
                }
                if (!bl) continue;
                token = this.tm.getToken();
            }
        }
        catch (Exception exception) {
            throw new InternalErrorException("Error " + exception + " on line " + vector.lastElement());
        }
        string = string + "";
        return true;
    }
}

