/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.programimport;

import com.iscobol.reportdesigner.beans.ReportControl;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.programimport.Errors;
import com.iscobol.screenpainter.programimport.ImpAcb;
import com.iscobol.screenpainter.programimport.InternalErrorException;
import com.iscobol.screenpainter.programimport.IsConsolePlugin;
import com.iscobol.screenpainter.programimport.ProjectToken;
import com.iscobol.screenpainter.programimport.Token;
import com.iscobol.screenpainter.programimport.TokenManager;
import com.iscobol.screenpainter.programimport.Utilities;
import java.util.Vector;
import org.eclipse.core.runtime.Status;

public class ReportControlObj
implements ProjectToken {
    TokenManager tm;
    private Vector lines;
    private String font = "";
    protected int rptFactor = 10000;

    public ReportControlObj(TokenManager tokenManager, Errors errors, Vector vector, ImpAcb impAcb, ReportControl reportControl, int n) throws InternalErrorException {
        this.tm = tokenManager;
        this.lines = vector;
        this.rptFactor = n;
    }

    protected void setFont(ReportControl reportControl) throws InternalErrorException {
        reportControl.setFont(Utilities.getRptFont((String)this.font, (boolean)false, (TokenManager)this.tm));
    }

    public boolean loadProperty(ReportControl reportControl) throws InternalErrorException {
        boolean bl = true;
        try {
            Token token = this.tm.getToken();
            switch (token.getToknum()) {
                case 482: {
                    reportControl.setLock(this.tm.loadBool());
                    break;
                }
                case 40: {
                    token = this.tm.getToken();
                    if (token != null && token.getToknum() == 633) {
                        token = this.tm.getToken();
                        if (token != null && token.getToknum() == 41) {
                            reportControl.setName(this.tm.loadString());
                            break;
                        }
                        bl = false;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 319: {
                    token = this.tm.getToken();
                    if (token != null) {
                        if (token.getToknum() == 773) {
                            reportControl.setColorVariable(this.tm.loadVar());
                            break;
                        }
                        if (token.getToknum() == 61) {
                            this.tm.ungetToken();
                            reportControl.setColor(new ColorType(this.tm.loadInt()));
                            break;
                        }
                        bl = false;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 405: {
                    token = this.tm.getToken();
                    if (token != null) {
                        if (token.getToknum() == 61) {
                            this.tm.ungetToken();
                            this.font = this.tm.loadString();
                            break;
                        }
                        bl = false;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 475: {
                    reportControl.setLines(this.tm.loadNum() / (float)this.rptFactor);
                    break;
                }
                case 474: {
                    reportControl.setLine(this.tm.loadNum() / (float)this.rptFactor);
                    break;
                }
                case 321: {
                    reportControl.setColumn(this.tm.loadNum() / (float)this.rptFactor);
                    break;
                }
                case 734: {
                    reportControl.setSize(this.tm.loadNum() / (float)this.rptFactor);
                    break;
                }
                case 776: {
                    token = this.tm.getToken();
                    if (token != null) {
                        if (token.getToknum() == 773) {
                            reportControl.setVisibleVariable(this.tm.loadVar());
                            break;
                        }
                        if (token.getToknum() == 61) {
                            this.tm.ungetToken();
                            reportControl.setVisible(this.tm.loadBool());
                            break;
                        }
                        bl = false;
                        break;
                    }
                    bl = false;
                    break;
                }
                case 821: {
                    reportControl.setAfterPrint(this.tm.loadString());
                    break;
                }
                case 822: {
                    reportControl.setBeforePrint(this.tm.loadString());
                    break;
                }
                case 823: {
                    token = this.tm.getToken();
                    if (token != null) {
                        if (token.getToknum() == 339) {
                            reportControl.setPrintCondition(Utilities.normalizePrintCondition((String)this.tm.loadString(true, false, false)));
                            break;
                        }
                        bl = false;
                        break;
                    }
                    bl = false;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!bl) {
                IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + this.tm.getFileName(), 0, "Report Control unexpected token: " + token.getWord() + " on line " + this.lines.lastElement() + " " + this.tm.getFileName(), null));
                token = this.tm.getTokNL();
                if (token != null) {
                    this.tm.ungetToken();
                }
            }
        }
        catch (Exception exception) {
            throw new InternalErrorException("Report Control exception: " + exception + " on line " + this.lines.lastElement());
        }
        return bl;
    }
}

