/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.programimport;

import com.iscobol.reportdesigner.beans.ReportControl;
import com.iscobol.reportdesigner.beans.ReportTable;
import com.iscobol.reportdesigner.beans.types.BitmapPath;
import com.iscobol.reportdesigner.beans.types.BorderStyle;
import com.iscobol.reportdesigner.beans.types.TableCellAlignment;
import com.iscobol.reportdesigner.beans.types.TableCellDataType;
import com.iscobol.reportdesigner.beans.types.TableCellSetting;
import com.iscobol.reportdesigner.beans.types.TableCellSettingList;
import com.iscobol.reportdesigner.beans.types.TableColumnAlignment;
import com.iscobol.reportdesigner.beans.types.TableColumnSetting;
import com.iscobol.reportdesigner.beans.types.TableColumnSettingList;
import com.iscobol.reportdesigner.beans.types.TableRowAlignment;
import com.iscobol.reportdesigner.beans.types.TableRowSetting;
import com.iscobol.reportdesigner.beans.types.TableRowSettingList;
import com.iscobol.screenpainter.beans.types.ColorType;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.ForegroundColorType;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.programimport.Errors;
import com.iscobol.screenpainter.programimport.ImpAcb;
import com.iscobol.screenpainter.programimport.InternalErrorException;
import com.iscobol.screenpainter.programimport.IsConsolePlugin;
import com.iscobol.screenpainter.programimport.ReportControlObj;
import com.iscobol.screenpainter.programimport.Token;
import com.iscobol.screenpainter.programimport.TokenManager;
import java.util.Vector;
import org.eclipse.core.runtime.Status;

public class ReportTableObj
extends ReportControlObj {
    TokenManager tm;
    int rptFact;
    private Vector lines;

    public ReportTableObj(TokenManager tokenManager, Errors errors, Vector vector, ImpAcb impAcb, ReportTable reportTable, int n) throws InternalErrorException {
        super(tokenManager, errors, vector, impAcb, (ReportControl)reportTable, n);
        this.lines = vector;
        boolean bl = true;
        boolean bl2 = true;
        String string = "";
        reportTable.setRearrangeCellsEnabled(false);
        this.tm = tokenManager;
        this.rptFact = n;
        Token token = null;
        try {
            token = this.tm.getToken();
            while (token != null && bl && bl2) {
                switch (token.getToknum()) {
                    case 377: {
                        bl = false;
                        break;
                    }
                    case 300: {
                        String string2;
                        token = this.tm.getToken();
                        if (token != null && token.getToknum() == 319) {
                            reportTable.setBorderColor(new ForegroundColorType(this.tm.loadInt()));
                            break;
                        }
                        if (token != null && token.getToknum() == 739) {
                            string2 = this.tm.loadString();
                            if (string2.equalsIgnoreCase("BOXED")) {
                                reportTable.setBorderStyle(new BorderStyle(0));
                                break;
                            }
                            if (!string2.equalsIgnoreCase("NO BOX")) break;
                            reportTable.setBorderStyle(new BorderStyle(1));
                            break;
                        }
                        if (token != null && token.getToknum() == 785) {
                            reportTable.setBorderWidth(this.tm.loadInt());
                            break;
                        }
                        bl2 = false;
                        break;
                    }
                    case 299: {
                        String string2;
                        token = this.tm.getToken();
                        if (token != null && token.getToknum() == 829) {
                            string2 = this.tm.loadString();
                            if (string2.equalsIgnoreCase("FULL PATH")) {
                                reportTable.setBitmapPath(new BitmapPath(0));
                                break;
                            }
                            if (string2.equalsIgnoreCase("DYNAMIC FULL PATH")) {
                                reportTable.setBitmapPath(new BitmapPath(1));
                                break;
                            }
                            if (!string2.equalsIgnoreCase("USER DEFINED")) break;
                            reportTable.setBitmapPath(new BitmapPath(2));
                            break;
                        }
                        bl2 = false;
                        break;
                    }
                    case 307: {
                        token = this.tm.getToken();
                        if (token != null && token.getToknum() == 828) {
                            reportTable.setCellSpacing(this.tm.loadInt());
                            break;
                        }
                        if (token != null && token.getToknum() == 831) {
                            reportTable.setCellSpacing(this.tm.loadInt());
                            break;
                        }
                        bl2 = false;
                        break;
                    }
                    case 731: {
                        token = this.tm.getToken();
                        if (token != null && token.getWord().equalsIgnoreCase("GRID")) {
                            token = this.tm.getToken();
                            if (token != null && token.getWord().equalsIgnoreCase("LINE")) {
                                reportTable.setShowGridLine(this.tm.loadBool());
                                break;
                            }
                            bl2 = false;
                            break;
                        }
                        bl2 = false;
                        break;
                    }
                    case 831: {
                        token = this.tm.getToken();
                        if (token != null && token.getToknum() == 728) {
                            token = this.tm.getToken();
                            if (token != null && token.getToknum() == 61) {
                                token = this.tm.getToken();
                                if (token != null && token.getToknum() == 40) {
                                    bl2 = this.loadTableSetting(reportTable);
                                    break;
                                }
                                bl2 = false;
                                break;
                            }
                            bl2 = false;
                            break;
                        }
                        bl2 = false;
                        break;
                    }
                    default: {
                        this.tm.ungetToken();
                        bl2 = super.loadProperty((ReportControl)reportTable);
                    }
                }
                if (!bl || !bl2) continue;
                token = this.tm.getToken();
            }
            if (!bl2) {
                IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + this.tm.getFileName(), 0, "Report Control Table unexpected token: " + token.getWord() + " on line " + this.lines.lastElement() + " " + this.tm.getFileName(), null));
                token = this.tm.getTokNL();
                if (token != null) {
                    this.tm.ungetToken();
                }
            }
        }
        catch (InternalErrorException internalErrorException) {
            throw internalErrorException;
        }
        catch (Exception exception) {
            string = string + exception;
            throw new InternalErrorException("Report Control Table exception: " + string + " on line " + this.lines.lastElement() + " " + this.tm.getFileName());
        }
        this.setFont((ReportControl)reportTable);
        reportTable.setRearrangeCellsEnabled(true);
    }

    public boolean loadTableSetting(ReportTable reportTable) throws InternalErrorException {
        boolean bl = true;
        boolean bl2 = true;
        int n = -1;
        Token token = null;
        int n2 = 0;
        int n3 = 0;
        try {
            token = this.tm.getToken();
            if (token != null) {
                if (token.getToknum() == 10002) {
                    int n4;
                    n = Integer.parseInt(token.getWord());
                    if (n == 0) {
                        while (bl2) {
                            token = this.tm.getToken();
                            if (token != null && token.getToknum() == 44) continue;
                            if (token != null && token.getWord().equalsIgnoreCase("NumRow")) {
                                n3 = this.tm.loadInt(false);
                                continue;
                            }
                            if (token != null && token.getWord().equalsIgnoreCase("NumCol")) {
                                n2 = this.tm.loadInt(false);
                                continue;
                            }
                            if (token != null && token.getToknum() == 41) {
                                bl2 = false;
                                continue;
                            }
                            return false;
                        }
                    } else {
                        return false;
                    }
                    TableRowSetting tableRowSetting = null;
                    TableColumnSetting tableColumnSetting = null;
                    TableCellSetting tableCellSetting = null;
                    TableColumnSettingList tableColumnSettingList = new TableColumnSettingList();
                    TableRowSettingList tableRowSettingList = new TableRowSettingList();
                    TableCellSettingList tableCellSettingList = new TableCellSettingList();
                    for (n4 = 1; n4 <= n2; ++n4) {
                        tableColumnSetting = this.loadColSetting(n4);
                        if (tableColumnSetting == null) {
                            return false;
                        }
                        tableColumnSettingList.addSetting((SettingItem)tableColumnSetting);
                    }
                    reportTable.setColumnSettings(tableColumnSettingList);
                    for (n4 = 1; n4 <= n3; ++n4) {
                        tableRowSetting = this.loadRowSetting(n4);
                        if (tableRowSetting == null) {
                            return false;
                        }
                        tableRowSettingList.addSetting((SettingItem)tableRowSetting);
                    }
                    reportTable.setRowSettings(tableRowSettingList);
                    for (n4 = 1; n4 <= n3; ++n4) {
                        for (int i = 1; i <= n2; ++i) {
                            tableCellSetting = this.loadCellSetting(i, n4);
                            if (tableColumnSetting == null) {
                                return false;
                            }
                            tableCellSettingList.addSetting((SettingItem)tableCellSetting);
                        }
                    }
                    reportTable.setCellSettings(tableCellSettingList);
                }
                return bl;
            }
            return false;
        }
        catch (InternalErrorException internalErrorException) {
            throw internalErrorException;
        }
        catch (Exception exception) {
            throw new InternalErrorException("Report Control Table Setting exception: " + exception + " on line " + this.lines.lastElement() + " " + this.tm.getFileName());
        }
    }

    public TableColumnSetting loadColSetting(int n) throws InternalErrorException {
        TableColumnSetting tableColumnSetting = new TableColumnSetting();
        boolean bl = true;
        int n2 = 1;
        Token token = null;
        try {
            TokenManager.Marker marker = null;
            token = this.tm.getToken();
            while (token != null && bl && tableColumnSetting != null) {
                switch (token.getToknum()) {
                    case 831: {
                        marker = this.tm.getMarker();
                        this.tm.setMarker(marker);
                        token = this.tm.getToken();
                        if (token != null && token.getToknum() == 728) {
                            token = this.tm.getToken();
                            if (token != null && token.getToknum() == 61) {
                                token = this.tm.getToken();
                                if (token != null && token.getToknum() == 40) {
                                    token = this.tm.getToken();
                                    n2 = Integer.parseInt(token.getWord());
                                    if (n2 == 1) break;
                                    this.tm.rewindToMarker(marker);
                                    this.tm.ungetToken();
                                    bl = false;
                                    break;
                                }
                                tableColumnSetting = null;
                                break;
                            }
                            tableColumnSetting = null;
                            break;
                        }
                        tableColumnSetting = null;
                        break;
                    }
                    case 785: {
                        tableColumnSetting.setWidth(this.tm.loadNum(false) / (float)this.rptFactor);
                        break;
                    }
                    case 319: {
                        token = this.tm.getToken();
                        if (token != null) {
                            if (token.getToknum() == 773) {
                                tableColumnSetting.setColorVariable(this.tm.loadVar(false));
                                break;
                            }
                            if (token.getToknum() == 61) {
                                this.tm.ungetToken();
                                tableColumnSetting.setColor(new ColorType(this.tm.loadInt(false)));
                                break;
                            }
                            tableColumnSetting = null;
                            break;
                        }
                        tableColumnSetting = null;
                        break;
                    }
                    case 405: {
                        tableColumnSetting.setFont(FontType.getStandardFont((String)this.tm.loadStringPar()));
                        break;
                    }
                    case 277: {
                        tableColumnSetting.setAlignment(new TableColumnAlignment(this.tm.loadInt(false)));
                        break;
                    }
                    case 41: 
                    case 44: {
                        break;
                    }
                    default: {
                        if (token.getWord().equalsIgnoreCase("X")) {
                            int n3 = this.tm.loadInt(false);
                            if (n3 == n) break;
                            this.tm.rewindToMarker(marker);
                            this.tm.ungetToken();
                            bl = false;
                            break;
                        }
                        bl = false;
                    }
                }
                if (!bl || tableColumnSetting == null) continue;
                token = this.tm.getToken();
            }
            if (tableColumnSetting == null) {
                IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + this.tm.getFileName(), 0, "Report Control Table Column Setting unexpected token: " + token.getWord() + " on line " + this.lines.lastElement() + " " + this.tm.getFileName(), null));
                token = this.tm.getTokNL();
                if (token != null) {
                    this.tm.ungetToken();
                }
            }
            return tableColumnSetting;
        }
        catch (InternalErrorException internalErrorException) {
            throw internalErrorException;
        }
        catch (Exception exception) {
            throw new InternalErrorException("Report Control Table Column Setting exception: " + exception + " on line " + this.lines.lastElement() + " " + this.tm.getFileName());
        }
    }

    public TableRowSetting loadRowSetting(int n) throws InternalErrorException {
        TableRowSetting tableRowSetting = new TableRowSetting();
        boolean bl = true;
        int n2 = 2;
        Token token = null;
        try {
            token = this.tm.getToken();
            TokenManager.Marker marker = null;
            while (token != null && bl && tableRowSetting != null) {
                switch (token.getToknum()) {
                    case 831: {
                        marker = this.tm.getMarker();
                        this.tm.setMarker(marker);
                        token = this.tm.getToken();
                        if (token != null && token.getToknum() == 728) {
                            token = this.tm.getToken();
                            if (token != null && token.getToknum() == 61) {
                                token = this.tm.getToken();
                                if (token != null && token.getToknum() == 40) {
                                    n2 = Integer.parseInt(this.tm.getToken().getWord());
                                    if (n2 == 2) break;
                                    this.tm.rewindToMarker(marker);
                                    this.tm.ungetToken();
                                    bl = false;
                                    break;
                                }
                                tableRowSetting = null;
                                break;
                            }
                            tableRowSetting = null;
                            break;
                        }
                        tableRowSetting = null;
                        break;
                    }
                    case 441: {
                        tableRowSetting.setHeight(this.tm.loadNum(false) / (float)this.rptFactor);
                        break;
                    }
                    case 277: {
                        tableRowSetting.setAlignment(new TableRowAlignment(this.tm.loadInt(false)));
                        break;
                    }
                    case 319: {
                        token = this.tm.getToken();
                        if (token != null) {
                            if (token.getToknum() == 773) {
                                tableRowSetting.setColorVariable(this.tm.loadVar(false));
                                break;
                            }
                            if (token.getToknum() == 61) {
                                this.tm.ungetToken();
                                tableRowSetting.setColor(new ColorType(this.tm.loadInt(false)));
                                break;
                            }
                            tableRowSetting = null;
                            break;
                        }
                        tableRowSetting = null;
                        break;
                    }
                    case 405: {
                        tableRowSetting.setFont(FontType.getStandardFont((String)this.tm.loadStringPar()));
                        break;
                    }
                    case 41: 
                    case 44: {
                        break;
                    }
                    default: {
                        if (token.getWord().equalsIgnoreCase("Y")) {
                            int n3 = this.tm.loadInt(false);
                            if (n3 == n) break;
                            this.tm.rewindToMarker(marker);
                            this.tm.ungetToken();
                            bl = false;
                            break;
                        }
                        bl = false;
                    }
                }
                if (!bl || tableRowSetting == null) continue;
                token = this.tm.getToken();
            }
            if (tableRowSetting == null) {
                IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + this.tm.getFileName(), 0, "Report Control Table Row Setting unexpected token: " + token.getWord() + " on line " + this.lines.lastElement() + " " + this.tm.getFileName(), null));
                token = this.tm.getTokNL();
                if (token != null) {
                    this.tm.ungetToken();
                }
            }
        }
        catch (InternalErrorException internalErrorException) {
            throw internalErrorException;
        }
        catch (Exception exception) {
            throw new InternalErrorException("Report Control Table Row Setting exception: " + exception + " on line " + this.lines.lastElement() + " " + this.tm.getFileName());
        }
        return tableRowSetting;
    }

    public TableCellSetting loadCellSetting(int n, int n2) throws InternalErrorException {
        TableCellSetting tableCellSetting = new TableCellSetting();
        boolean bl = true;
        int n3 = 3;
        Token token = null;
        try {
            token = this.tm.getToken();
            TokenManager.Marker marker = null;
            int n4 = 0;
            int n5 = 0;
            while (token != null && bl && tableCellSetting != null) {
                switch (token.getToknum()) {
                    case 831: {
                        marker = this.tm.getMarker();
                        this.tm.setMarker(marker);
                        token = this.tm.getToken();
                        if (token != null && token.getToknum() == 728) {
                            token = this.tm.getToken();
                            if (token != null && token.getToknum() == 61) {
                                token = this.tm.getToken();
                                if (token != null && token.getToknum() == 40) {
                                    n3 = Integer.parseInt(this.tm.getToken().getWord());
                                    if (n3 == 3) break;
                                    this.tm.rewindToMarker(marker);
                                    this.tm.ungetToken();
                                    bl = false;
                                    break;
                                }
                                tableCellSetting = null;
                                break;
                            }
                            tableCellSetting = null;
                            break;
                        }
                        tableCellSetting = null;
                        break;
                    }
                    case 319: {
                        token = this.tm.getToken();
                        if (token != null) {
                            if (token.getToknum() == 773) {
                                tableCellSetting.setColorVariable(this.tm.loadVar(false));
                                break;
                            }
                            if (token.getToknum() == 61) {
                                this.tm.ungetToken();
                                tableCellSetting.setColor(new ColorType(this.tm.loadInt(false)));
                                break;
                            }
                            tableCellSetting = null;
                            break;
                        }
                        tableCellSetting = null;
                        break;
                    }
                    case 405: {
                        tableCellSetting.setFont(FontType.getStandardFont((String)this.tm.loadStringPar()));
                        break;
                    }
                    case 277: {
                        tableCellSetting.setAlignment(new TableCellAlignment(this.tm.loadInt(false)));
                        break;
                    }
                    case 673: 
                    case 674: {
                        tableCellSetting.setPicture(this.tm.loadStringPar());
                        break;
                    }
                    case 352: {
                        tableCellSetting.setData(this.tm.loadString(false));
                        break;
                    }
                    case 826: {
                        token = this.tm.getToken();
                        if (token != null) {
                            if (token.getToknum() == 773) {
                                tableCellSetting.setHyperlinkVariable(this.tm.loadVar(false));
                                break;
                            }
                            if (token.getToknum() == 61) {
                                this.tm.ungetToken();
                                tableCellSetting.setHyperlink(this.tm.loadString(false));
                                break;
                            }
                            tableCellSetting = null;
                            break;
                        }
                        tableCellSetting = null;
                        break;
                    }
                    case 41: 
                    case 44: {
                        break;
                    }
                    default: {
                        if (token.getWord().equalsIgnoreCase("X")) {
                            n4 = this.tm.loadInt(false);
                            break;
                        }
                        if (token.getWord().equalsIgnoreCase("Y")) {
                            n5 = this.tm.loadInt(false);
                            if (n4 == n && n5 == n2) break;
                            this.tm.rewindToMarker(marker);
                            this.tm.ungetToken();
                            bl = false;
                            break;
                        }
                        if (token.getWord().equalsIgnoreCase("CellType")) {
                            tableCellSetting.setDataType(new TableCellDataType(this.tm.loadInt(false)));
                            break;
                        }
                        bl = false;
                    }
                }
                if (!bl || tableCellSetting == null) continue;
                token = this.tm.getToken();
            }
            if (tableCellSetting == null) {
                IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + this.tm.getFileName(), 0, "Report Control Table Column Setting unexpected token: " + token.getWord() + " on line " + this.lines.lastElement() + " " + this.tm.getFileName(), null));
                token = this.tm.getTokNL();
                if (token != null) {
                    this.tm.ungetToken();
                }
            } else {
                this.tm.ungetToken();
            }
            return tableCellSetting;
        }
        catch (InternalErrorException internalErrorException) {
            throw internalErrorException;
        }
        catch (Exception exception) {
            throw new InternalErrorException("Report Control Table Column Setting exception: " + exception + " on line " + this.lines.lastElement() + " " + this.tm.getFileName());
        }
    }
}

