/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.programimport;

import com.iscobol.screenpainter.beans.swing.SwingStatusbar;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.SPStyle;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.beans.types.StatusPanelSetting;
import com.iscobol.screenpainter.beans.types.StatusPanelSettingList;
import com.iscobol.screenpainter.programimport.EndOfProgramException;
import com.iscobol.screenpainter.programimport.Errors;
import com.iscobol.screenpainter.programimport.GeneralErrorException;
import com.iscobol.screenpainter.programimport.GenericScreenObj;
import com.iscobol.screenpainter.programimport.InternalErrorException;
import com.iscobol.screenpainter.programimport.IsConsolePlugin;
import com.iscobol.screenpainter.programimport.Token;
import com.iscobol.screenpainter.programimport.TokenManager;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.runtime.Status;

/*
 * Exception performing whole class analysis ignored.
 */
public class StatusBarObj
extends GenericScreenObj {
    private boolean grip = false;
    private boolean lockCntr = false;
    private Vector panelsWidth = new Vector();
    private Vector panelsStyle = new Vector();
    private Vector panelsPicture = new Vector();
    private Vector panelsVariable = new Vector();
    private Vector panelsText = new Vector();
    private String handVar;
    private String font = "";
    private String fontVar = "";
    private int panel;
    private int tabOrd = 0;
    public String name = "";
    private TokenManager tm;

    public StatusBarObj(TokenManager tokenManager, Errors errors, Vector vector, SwingStatusbar swingStatusbar) throws InternalErrorException {
        super(tokenManager, errors, vector);
        boolean bl = true;
        boolean bl2 = true;
        this.tm = tokenManager;
        try {
            Token token = this.tm.getToken();
            token = this.tm.getToken();
            while (token != null && bl && bl2) {
                switch (token.getToknum()) {
                    case 40: {
                        token = this.tm.getToken();
                        if (token != null && token.getToknum() == 633) {
                            token = this.tm.getToken();
                            if (token != null && token.getToknum() == 41) {
                                this.name = this.tm.loadString();
                                swingStatusbar.setName(this.name);
                                break;
                            }
                            bl = false;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 405: {
                        token = this.tm.getToken();
                        if (token != null) {
                            if (token.getToknum() == 773) {
                                this.fontVar = this.tm.loadVar();
                                break;
                            }
                            if (token.getToknum() == 61) {
                                this.tm.ungetToken();
                                this.font = this.tm.loadString();
                                bl = this.intSetFont(swingStatusbar);
                                break;
                            }
                            bl = false;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 433: {
                        this.grip = this.tm.loadBool();
                        swingStatusbar.setGrip(this.grip);
                        break;
                    }
                    case 437: {
                        token = this.tm.getToken();
                        if (token != null && token.getToknum() == 773) {
                            this.handVar = this.tm.loadVar();
                            swingStatusbar.setHandle(this.handVar);
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 665: {
                        this.panel = this.tm.loadInt();
                        swingStatusbar.setPanelIndex(this.panel);
                        break;
                    }
                    case 670: {
                        bl = StatusBarObj.parseList((TokenManager)this.tm, (Vector)this.panelsWidth);
                        bl2 = true;
                        break;
                    }
                    case 666: {
                        bl = StatusBarObj.parseList((TokenManager)this.tm, (Vector)this.panelsPicture);
                        bl2 = true;
                        break;
                    }
                    case 667: {
                        bl = StatusBarObj.parseList((TokenManager)this.tm, (Vector)this.panelsStyle);
                        bl2 = true;
                        break;
                    }
                    case 668: {
                        bl = StatusBarObj.parseList((TokenManager)this.tm, (Vector)this.panelsText);
                        bl2 = true;
                        break;
                    }
                    case 669: {
                        bl = StatusBarObj.parseList((TokenManager)this.tm, (Vector)this.panelsVariable);
                        bl2 = true;
                        break;
                    }
                    case 743: {
                        token = this.tm.getToken();
                        if (token != null) {
                            if (token.getToknum() == 660) {
                                this.tabOrd = this.tm.loadInt();
                                break;
                            }
                            bl = false;
                            break;
                        }
                        bl = false;
                        break;
                    }
                    case 482: {
                        this.lockCntr = this.tm.loadBool();
                        break;
                    }
                    case 377: {
                        bl2 = false;
                        break;
                    }
                    default: {
                        this.tm.ungetToken();
                        bl = super.loadProperty();
                    }
                }
                if (!bl || !bl2) continue;
                token = this.tm.getToken();
            }
            StatusPanelSettingList statusPanelSettingList = new StatusPanelSettingList();
            int n = 0;
            int n2 = 0;
            if (this.panelsText.size() > n2) {
                n2 = this.panelsText.size();
            }
            if (this.panelsWidth.size() > n2) {
                n2 = this.panelsWidth.size();
            }
            if (this.panelsVariable.size() > n2) {
                n2 = this.panelsVariable.size();
            }
            if (this.panelsPicture.size() > n2) {
                n2 = this.panelsPicture.size();
            }
            if (this.panelsStyle.size() > n2) {
                n2 = this.panelsStyle.size();
            }
            for (n = 0; n < n2; ++n) {
                StatusPanelSetting statusPanelSetting = new StatusPanelSetting();
                if (this.panelsWidth.size() > n) {
                    token = (Token)this.panelsWidth.elementAt(n);
                    if (token.getWord().length() > 0) {
                        statusPanelSetting.setWidth(new Float(token.getWord()).intValue());
                    } else {
                        statusPanelSetting.setWidth(0);
                    }
                } else {
                    statusPanelSetting.setWidth(0);
                }
                if (this.panelsPicture.size() > n) {
                    token = (Token)this.panelsPicture.elementAt(n);
                    if (token.getWord().length() > 0) {
                        statusPanelSetting.setTextPicture(token.getWord());
                    } else {
                        statusPanelSetting.setTextPicture(null);
                    }
                } else {
                    statusPanelSetting.setTextPicture(null);
                }
                if (this.panelsStyle.size() > n && (token = (Token)this.panelsStyle.elementAt(n)).getWord().length() > 0) {
                    statusPanelSetting.setStyle(new SPStyle(new Float(token.getWord()).intValue()));
                }
                if (this.panelsText.size() > n) {
                    token = (Token)this.panelsText.elementAt(n);
                    if (token.getWord().length() > 0 && token.getWord().charAt(0) == '\"') {
                        statusPanelSetting.setText(token.getWord().substring(1, token.getWord().length() - 1));
                    } else {
                        statusPanelSetting.setText("");
                    }
                } else {
                    statusPanelSetting.setText("");
                }
                if (this.panelsVariable.size() > n && (token = (Token)this.panelsVariable.elementAt(n)).getWord().length() > 1) {
                    statusPanelSetting.setTextVariable(token.getWord());
                }
                statusPanelSettingList.addSetting((SettingItem)statusPanelSetting);
            }
            if (!bl && token != null) {
                IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + this.tm.getFileName(), 0, "StatusBarObj Unexpected token: " + token.getWord(), null));
                token = this.tm.getTokNL();
                if (token != null) {
                    this.tm.ungetToken();
                }
            } else if (!bl) {
                IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + this.tm.getFileName(), 0, "StatusBarObj Unexpected token:null!", null));
            }
            swingStatusbar.setPanelSettings(statusPanelSettingList);
        }
        catch (InternalErrorException internalErrorException) {
            throw internalErrorException;
        }
        catch (Exception exception) {
            throw new InternalErrorException("StatusBar exception: " + exception + " on line " + vector.lastElement());
        }
        if (this.tm.hasDebug()) {
            this.printDebug();
        }
        if (this.fontVar != "" && swingStatusbar.getFont() != null) {
            swingStatusbar.getFont().setHandleName(this.fontVar);
        }
    }

    void printDebug() {
        Token token;
        System.out.println("     ------>StatusBar begin");
        System.out.println("     grip [" + this.grip + "]");
        System.out.println("     font [" + this.fontVar + "]");
        System.out.println("     handVar [" + this.handVar + "]");
        System.out.println("     lockCntr [" + this.lockCntr + "]");
        System.out.println("     name [" + this.name + "]");
        System.out.println("     panel [" + this.panel + "]");
        System.out.println("     tabOrd [" + this.tabOrd + "]");
        Enumeration enumeration = this.panelsWidth.elements();
        while (enumeration.hasMoreElements()) {
            token = (Token)enumeration.nextElement();
            System.out.println("       panel [" + token.getWord() + "]");
        }
        enumeration = this.panelsStyle.elements();
        while (enumeration.hasMoreElements()) {
            token = (Token)enumeration.nextElement();
            System.out.println("       panelS [" + token.getWord() + "]");
        }
        enumeration = this.panelsVariable.elements();
        while (enumeration.hasMoreElements()) {
            token = (Token)enumeration.nextElement();
            System.out.println("       panelV [" + token.getWord() + "]");
        }
        enumeration = this.panelsPicture.elements();
        while (enumeration.hasMoreElements()) {
            token = (Token)enumeration.nextElement();
            System.out.println("       panelP [" + token.getWord() + "]");
        }
        enumeration = this.panelsText.elements();
        while (enumeration.hasMoreElements()) {
            token = (Token)enumeration.nextElement();
            System.out.println("       panelT [" + token.getWord() + "]");
        }
        super.printGenDebug();
    }

    public boolean intSetFont(SwingStatusbar swingStatusbar) throws InternalErrorException {
        boolean bl = true;
        if (this.font.indexOf(47) < 0) {
            this.myFont = new FontType(this.font);
            this.myFont.setSize(9.0f);
        } else if (this.font.indexOf(47) == 0) {
            this.myFont = new FontType("Default Font");
            this.myFont.setSize(9.0f);
        } else {
            this.myFont = StatusBarObj.getFont((String)this.font);
        }
        if (this.myFont != null) {
            swingStatusbar.setFont(this.myFont);
        } else {
            bl = false;
        }
        return bl;
    }

    public boolean setFont(SwingStatusbar swingStatusbar) throws InternalErrorException {
        boolean bl = true;
        if (this.myFont != null) {
            if (!this.fontVar.equals("")) {
                if (this.tm.getFont(this.fontVar) != null) {
                    this.myFont = this.tm.getFont(this.fontVar);
                } else {
                    this.tm.addMyFont(this.fontVar, this.myFont);
                }
            } else {
                this.fontVar = this.font.replace(' ', '-');
                if (this.tm.allVars.get(this.fontVar.toUpperCase().replace('_', '-')) == null) {
                    this.tm.makeVar(this.fontVar);
                    this.myFont = StatusBarObj.getFont((String)this.font);
                    this.tm.addMyFont(this.fontVar, this.myFont);
                }
            }
            if (this.myFont != null) {
                swingStatusbar.setFont(this.myFont);
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean parseList(TokenManager tokenManager, Vector vector) throws EndOfProgramException, GeneralErrorException {
        Token token = tokenManager.getToken();
        if (token == null || token.getToknum() != 61) return false;
        token = tokenManager.getToken();
        if (token == null || token.getToknum() != 40) return false;
        Token token2 = new Token();
        token = tokenManager.getAllToken();
        while (token != null) {
            switch (token.getToknum()) {
                case 44: {
                    vector.add(token2);
                    token2 = new Token();
                    break;
                }
                case 41: {
                    vector.add(token2);
                    return true;
                }
                default: {
                    token2 = token;
                }
            }
            token = tokenManager.getAllToken();
        }
        return true;
    }
}

