/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.programimport;

import com.iscobol.screenpainter.programimport.ProjectToken;
import java.math.BigDecimal;

/*
 * Exception performing whole class analysis ignored.
 */
public class Token
implements ProjectToken {
    static final String eol = System.getProperty("line.separator", "\n");
    private String word;
    private int token;
    private String fileName;
    private int fileLineNumber;
    private int offset;
    private boolean isAll;
    private boolean national;
    private boolean resource;
    private boolean figurative;
    private boolean hexdecimal;
    private boolean isDouble;
    private int nativeSize;

    public static String version() {
        return "$Id: Token.java,v 1.5 2009/03/31 13:10:25 daniela Exp $";
    }

    public Token assign(Token token) {
        this.word = token.word;
        this.token = token.token;
        this.fileLineNumber = token.fileLineNumber;
        this.offset = token.offset;
        this.fileName = token.fileName;
        return this;
    }

    public Token() {
        this(0, new char[0], 0, 0, 0, 0, null);
    }

    public Token(int n, char[] cArray, int n2, int n3, int n4, int n5, String string) {
        StringBuilder stringBuilder = new StringBuilder(n3);
        n3 += n2;
        for (int i = n2; i < n3 && i < cArray.length; ++i) {
            stringBuilder.append(cArray[i]);
        }
        this.token = n;
        this.word = stringBuilder.toString();
        this.fileLineNumber = n4;
        this.offset = n5;
        this.fileName = string;
    }

    public Token(char c, int n, int n2, String string) {
        this.token = c;
        this.word = "" + c;
        this.fileLineNumber = n;
        this.offset = n2;
        this.fileName = string;
    }

    public Token(int n, String string, int n2, int n3, String string2) {
        this.token = n;
        this.word = string;
        this.fileLineNumber = n2;
        this.offset = n3;
        this.fileName = string2;
    }

    public Token(Token token) {
        this.assign(token);
    }

    public Token combine(char c, Token token) {
        int n = 0;
        n = this.word.indexOf(44);
        BigDecimal bigDecimal = n > 0 ? new BigDecimal(this.word.substring(0, n) + "." + this.word.substring(n + 1)) : new BigDecimal(this.word);
        n = 0;
        n = token.word.indexOf(44);
        BigDecimal bigDecimal2 = n > 0 ? new BigDecimal(token.word.substring(0, n) + "." + token.word.substring(n + 1)) : new BigDecimal(token.word);
        switch (c) {
            case '+': {
                bigDecimal = bigDecimal.add(bigDecimal2);
                break;
            }
            case '-': {
                bigDecimal = bigDecimal.subtract(bigDecimal2);
                break;
            }
            case '*': {
                bigDecimal = bigDecimal.multiply(bigDecimal2);
                break;
            }
            case '/': {
                bigDecimal = bigDecimal.divide(bigDecimal2, 4);
                break;
            }
            default: {
                throw new IllegalArgumentException("OP=" + c);
            }
        }
        Token token2 = new Token(this);
        token2.setWord(bigDecimal.toString());
        return token2;
    }

    public int getToknum() {
        return this.token;
    }

    public int getOffset() {
        return this.offset;
    }

    int getLength() {
        return this.word.length();
    }

    public int getFLN() {
        return this.fileLineNumber;
    }

    public String getWord() {
        return this.word;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setWord(String string) {
        this.word = string;
    }

    void setToknum(int n) {
        this.token = n;
    }

    void setAll(boolean bl) {
        this.isAll = bl;
    }

    void setNational(boolean bl) {
        this.national = bl;
    }

    void setResource(boolean bl) {
        this.resource = bl;
    }

    boolean isAll() {
        return this.isAll;
    }

    boolean isNational() {
        return this.national;
    }

    boolean isResource() {
        return this.resource;
    }

    void setFigurative(boolean bl) {
        this.figurative = bl;
    }

    boolean isFigurative() {
        return this.figurative;
    }

    void setHexdecimal(boolean bl) {
        this.hexdecimal = bl;
    }

    boolean isHexdecimal() {
        return this.hexdecimal;
    }

    boolean isFigurativeZero() {
        return this.getFigurativeChar() == 48;
    }

    boolean isFigurativeSpace() {
        return this.getFigurativeChar() == 32;
    }

    boolean isFigurativeHighValue() {
        return this.getFigurativeChar() == 255;
    }

    void setDouble(boolean bl) {
        this.isDouble = bl;
    }

    void setNativeSize(int n) {
        this.nativeSize = n;
    }

    int getNativeSize() {
        return this.nativeSize;
    }

    int getFigurativeChar() {
        if (this.figurative) {
            if (this.token == 10001) {
                return this.word.charAt(1);
            }
            return this.word.charAt(0);
        }
        return -1;
    }

    public void putKeyword() {
        this.token = this.findResKey();
    }

    private int findResKey() {
        String string = this.word.toUpperCase().replace('_', '-');
        Integer n = (Integer)reservedWords.get(string);
        if (n != null) {
            this.word = string;
            return n;
        }
        int n2 = string.length();
        char[] cArray = new char[n2];
        int n3 = 0;
        string.getChars(0, n2, cArray, 0);
        char c = cArray[0];
        if (c >= '0' && c <= '9' || c == '-' || c == '+') {
            for (n3 = 1; n3 < n2 && (c = cArray[n3]) >= '0' && c <= '9'; ++n3) {
            }
        }
        if (n3 == n2) {
            return 10002;
        }
        this.word = string;
        return 10009;
    }

    public static boolean changeKeyword(String string, String string2) {
        string = string.toUpperCase().replace('_', '-');
        string2 = string2.toUpperCase().replace('_', '-');
        Integer n = (Integer)reservedWords.get(string);
        if (n != null && reservedWords.get(string2) == null) {
            reservedWords.remove(string);
            reservedWords.put(string2, n);
            return true;
        }
        return false;
    }

    public boolean isZero() {
        int n;
        if (this.token == 10002 && (n = this.word.length()) > 0) {
            --n;
            while (n >= 0) {
                if (this.word.charAt(n) != '0') {
                    return false;
                }
                --n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return "[" + this.word + "]";
    }

    public int getRealLength() {
        int n = 0;
        if (this.token == 10001) {
            char[] cArray = this.word.toCharArray();
            char c = cArray[0];
            int n2 = cArray.length - 1;
            block3: for (int i = 1; i < n2; ++i) {
                char c2 = cArray[i];
                switch (c2) {
                    case '\"': 
                    case '\'': {
                        if (c == c2) {
                            ++i;
                        }
                        ++n;
                        continue block3;
                    }
                    default: {
                        ++n;
                    }
                }
            }
        } else {
            n = this.word.length();
        }
        return n;
    }

    public String getCode() {
        String string;
        if (this.token == 10001) {
            char[] cArray = this.word.toCharArray();
            StringBuilder stringBuilder = new StringBuilder();
            char c = cArray[0];
            int n = cArray.length - 1;
            block7: for (int i = 1; i < n; ++i) {
                char c2 = cArray[i];
                switch (c2) {
                    case '\n': {
                        stringBuilder.append("\\n");
                        continue block7;
                    }
                    case '\r': {
                        stringBuilder.append("\\r");
                        continue block7;
                    }
                    case '\"': {
                        stringBuilder.append("\\\"");
                        if (c != c2) continue block7;
                        ++i;
                        continue block7;
                    }
                    case '\'': {
                        stringBuilder.append("'");
                        if (c != c2) continue block7;
                        ++i;
                        continue block7;
                    }
                    case '\\': {
                        stringBuilder.append("\\\\");
                        continue block7;
                    }
                    default: {
                        stringBuilder.append(c2);
                    }
                }
            }
            string = stringBuilder.toString();
        } else {
            string = this.token == 10009 ? this.word.replace('-', '_') : this.word;
        }
        return string;
    }

    public String getPlain() {
        String string;
        if (this.token == 10001) {
            char[] cArray = this.word.toCharArray();
            StringBuilder stringBuilder = new StringBuilder();
            char c = cArray[0];
            int n = cArray.length - 1;
            block4: for (int i = 1; i < n; ++i) {
                char c2 = cArray[i];
                switch (c2) {
                    case '\"': {
                        stringBuilder.append("\"");
                        if (c != c2) continue block4;
                        ++i;
                        continue block4;
                    }
                    case '\'': {
                        stringBuilder.append("'");
                        if (c != c2) continue block4;
                        ++i;
                        continue block4;
                    }
                    default: {
                        stringBuilder.append(c2);
                    }
                }
            }
            string = stringBuilder.toString();
        } else {
            string = this.word;
        }
        return string;
    }

    public String getLitArg() {
        String string;
        if (this.word.length() == 0) {
            string = "";
        } else if (this.token == 10001) {
            if (this.hexdecimal) {
                char[] cArray = this.word.substring(1, this.word.length() - 1).toCharArray();
                string = "new byte[] {";
                if (this.national && this.isFigurativeHighValue()) {
                    string = string + "-1,-1";
                } else {
                    int n = 0;
                    while (true) {
                        string = cArray[n] > '\u007f' ? string + "-" + (256 - cArray[n]) : string + cArray[n];
                        if (++n >= cArray.length) break;
                        string = string + ',';
                        if (n % 10 != 0) continue;
                        string = string + eol;
                    }
                }
                string = string + "}";
            } else {
                string = "\"" + this.getCode() + "\"";
            }
        } else if (this.isDouble) {
            string = this.word;
        } else {
            char c = this.word.charAt(0);
            int n = c == '-' || c == '+' ? 1 : 0;
            if (Token.countDigit((String)this.word) > 18) {
                return "\"" + this.word + "\"";
            }
            int n2 = this.word.indexOf(46);
            if (n2 >= 0 || (n2 = this.word.indexOf(44)) >= 0) {
                string = this.word.substring(0, n2) + this.word.substring(n2 + 1) + "L,";
                string = string + (n2 - n) + "," + (this.word.length() - n2 - 1);
            } else {
                string = this.word + "L," + (this.word.length() - n) + "," + 0;
            }
            int n3 = string.length();
            for (n2 = n; n2 < n3 && string.charAt(n2) == '0'; ++n2) {
            }
            if (n2 > n) {
                string = string.charAt(n2) == 'L' ? string.substring(n2 - 1, string.length()) : string.substring(n2, string.length());
                if (n > 0) {
                    string = c + string;
                }
            }
        }
        return string;
    }

    public String getAsLong() {
        String string;
        switch (this.getToknum()) {
            case 10002: {
                string = this.getLitArg();
                int n = string.indexOf(44);
                if (n < 0) break;
                string = string.substring(0, n);
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public String getAsInt() {
        String string;
        switch (this.getToknum()) {
            case 10002: {
                string = this.getAsLong();
                int n = string.indexOf(76);
                if (n < 0) break;
                string = string.substring(0, n);
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public int longValue() {
        try {
            return Integer.parseInt(this.getAsInt());
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    boolean isWord() {
        return this.token == 10009 || this.token > 255 && this.token < 10000;
    }

    boolean isSeparator() {
        return this.token == 44 || this.token == 59;
    }

    private static int countDigit(String string) {
        int n = 0;
        for (int i = string.length() - 1; i >= 0; --i) {
            if (!Character.isDigit(string.charAt(i))) continue;
            ++n;
        }
        return n;
    }

    int length() {
        if (this.getToknum() == 10001) {
            if (this.hexdecimal && this.national) {
                return (this.word.length() - 2) / 2;
            }
            return this.word.length() - 2;
        }
        return this.word.length();
    }
}

