/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.programimport;

import com.iscobol.screenpainter.beans.AbstractInputField;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.programimport.EndOfProgramException;
import com.iscobol.screenpainter.programimport.Errors;
import com.iscobol.screenpainter.programimport.ErrorsNumbers;
import com.iscobol.screenpainter.programimport.GeneralErrorException;
import com.iscobol.screenpainter.programimport.InternalErrorException;
import com.iscobol.screenpainter.programimport.OptionList;
import com.iscobol.screenpainter.programimport.PreProcessor;
import com.iscobol.screenpainter.programimport.ProjectToken;
import com.iscobol.screenpainter.programimport.Token;
import com.iscobol.screenpainter.programimport.TokenManager;
import com.iscobol.screenpainter.programimport.Utilities;
import com.iscobol.screenpainter.programimport.WorkItem;
import com.iscobol.screenpainter.programimport.WorkingAcb;
import java.util.Hashtable;
import java.util.Vector;

/*
 * Exception performing whole class analysis ignored.
 */
public class TokenManager
implements ProjectToken,
ErrorsNumbers {
    private PreProcessor pp;
    private Vector tokenBuff = new Vector();
    private int tokenBuffIdx = -1;
    private OptionList optList;
    Hashtable allLiterals = new Hashtable();
    Hashtable allUsedLiterals = new Hashtable();
    Hashtable allVars = new Hashtable();
    Vector allMarkers = new Vector();
    private boolean lastVirtualDot;
    private Errors error;
    private Token oldTok;
    boolean inExecSql;
    private int lowValue = 0;
    private int highValue = 255;
    boolean debug;
    private Vector workingStorageCopies = new Vector();
    private WorkingAcb work = null;
    private Hashtable myNewFont = new Hashtable();
    private Hashtable usedPopUp = new Hashtable();
    private Hashtable menuHandle = new Hashtable();
    private boolean isTotem = false;

    public TokenManager(PreProcessor preProcessor, OptionList optionList, Errors errors) {
        this.pp = preProcessor;
        this.optList = optionList;
        this.error = errors;
        this.debug = this.optList.getOption("-d") != null;
    }

    public Marker getMarker() {
        return new Marker(this);
    }

    public void skipTillDot() throws EndOfProgramException, GeneralErrorException {
        while (this.getToken().getToknum() != 10006) {
        }
        this.ungetToken();
    }

    public void skipToDot() throws EndOfProgramException, GeneralErrorException {
        while (this.getToken().getToknum() != 10006) {
        }
    }

    public void skipTill(int[] nArray) throws EndOfProgramException, GeneralErrorException {
        block0: while (true) {
            int n = this.getToken().getToknum();
            int n2 = 0;
            while (true) {
                if (n2 >= nArray.length) continue block0;
                if (n == nArray[n2]) {
                    this.ungetToken();
                    return;
                }
                ++n2;
            }
            break;
        }
    }

    protected void setLowHighValues(int n, int n2) {
        this.lowValue = n;
        this.highValue = n2;
    }

    int getLowValue() {
        return this.lowValue;
    }

    int getHighValue() {
        return this.highValue;
    }

    public Token getToken() throws EndOfProgramException, GeneralErrorException {
        Token token;
        while ((token = this.getAllToken()).isSeparator()) {
        }
        this.oldTok = token;
        return token;
    }

    private static boolean hexToString(Token token, Errors errors) {
        char[] cArray = token.getWord().toCharArray();
        char c = cArray[1];
        StringBuilder stringBuilder = new StringBuilder().append(c);
        int n = 2;
        while (n < cArray.length && cArray[n] != c) {
            int n2 = 0;
            int n3 = 0;
            while (n3 < 2 && cArray[n] != c) {
                n2 <<= 4;
                switch (cArray[n]) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        n2 += (char)(cArray[n] - 48);
                        break;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'E': 
                    case 'F': {
                        n2 += (char)(cArray[n] - 65 + 10);
                        break;
                    }
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        n2 += (char)(cArray[n] - 97 + 10);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                ++n3;
                ++n;
            }
            stringBuilder.append((char)n2);
        }
        stringBuilder.append(c);
        if (stringBuilder.length() == 2) {
            token.setToknum(10002);
            token.setWord("0");
            return false;
        }
        token.setWord(stringBuilder.toString());
        token.setHexdecimal(true);
        return true;
    }

    private void handleStringLiteral(Token token) {
        char c = token.getWord().charAt(0);
        if (c == 'X' || c == 'x') {
            if (!TokenManager.hexToString((Token)token, (Errors)this.error)) {
                // empty if block
            }
        } else {
            c = token.getWord().charAt(0);
            if (c == 'N' || c == 'n') {
                token.setNational(true);
                c = token.getWord().charAt(1);
                if (c == 'X' || c == 'x') {
                    token.setWord(token.getWord().substring(1));
                    if (!TokenManager.hexToString((Token)token, (Errors)this.error)) {
                        // empty if block
                    }
                } else {
                    token.setWord(token.getWord().substring(1));
                }
            } else {
                c = token.getWord().charAt(0);
                if (c == 'R' || c == 'r') {
                    token.setNational(true);
                    token.setResource(true);
                    token.setWord(token.getWord().substring(1));
                }
            }
        }
    }

    public Token getAllToken() throws EndOfProgramException, GeneralErrorException {
        Token token = this.myGetToken();
        Object var2_2 = null;
        switch (token.getToknum()) {
            default: {
                break;
            }
            case 10001: {
                this.handleStringLiteral(token);
                while (this.myGetToken().getToknum() == 38) {
                    Token token2 = this.myGetToken();
                    if (token2.getToknum() == 10001) {
                        this.handleStringLiteral(token2);
                        String string = token.getWord();
                        char c = string.charAt(0);
                        string = string.substring(1, string.length() - 1);
                        String string2 = token2.getWord();
                        string2 = string2.substring(1, string2.length() - 1);
                        token.setWord(c + string + string2 + c);
                        this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                        this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                        continue;
                    }
                    this.error.print(8, 18, token, " & " + token2.getWord());
                    break;
                }
                this.ungetToken();
                break;
            }
            case 10002: {
                int n = this.tokenBuffIdx--;
                try {
                    Token token3 = this.myGetToken();
                    Token token4 = this.myGetToken();
                    if (token3.getToknum() == 10006 && token3.getWord().length() == 1 && token4.getToknum() == 10002) {
                        Token token5 = this.myGetToken();
                        if (token5.getToknum() == 10002) {
                            Token token6 = this.myGetToken();
                            token.setDouble(true);
                            if (token6.getToknum() == 10002) {
                                token.setWord(token.getWord() + "." + token4.getWord() + "E" + token6.getWord());
                            } else {
                                token.setWord(token.getWord() + "." + token4.getWord() + "E00");
                            }
                        } else {
                            --this.tokenBuffIdx;
                            token.setWord(token.getWord() + token3.getWord() + token4.getWord());
                        }
                        token.setToknum(10017);
                        while (this.tokenBuffIdx > n) {
                            this.tokenBuff.removeElementAt(this.tokenBuffIdx--);
                        }
                        break;
                    }
                    this.tokenBuffIdx = n;
                    break;
                }
                catch (EndOfProgramException endOfProgramException) {
                    this.tokenBuffIdx = n;
                }
            }
        }
        if (var2_2 == null) {
            switch (token.getToknum()) {
                case 10001: 
                case 10002: 
                case 10017: {
                    this.loadLiteral(token);
                }
            }
        }
        return token;
    }

    public void addWorkingStorageCopy(String string) {
        this.workingStorageCopies.addElement(string);
    }

    void startWorkingStorage(Token token) {
        int n = this.workingStorageCopies.size() - 1;
        if (n >= 0 && this.tokenBuffIdx < this.tokenBuff.size() - 1) {
            this.error.print(8, 18, token, " (-exec=)");
        }
    }

    private Token myGetToken() throws EndOfProgramException {
        Token token = null;
        ++this.tokenBuffIdx;
        while (this.tokenBuffIdx >= this.tokenBuff.size() && this.pp.getLine(this.tokenBuff, null, null) > 0) {
        }
        if (this.tokenBuffIdx < this.tokenBuff.size()) {
            Token token2;
            token = (Token)this.tokenBuff.elementAt(this.tokenBuffIdx);
            if (this.tokenBuffIdx + 1 == this.tokenBuff.size()) {
                this.pp.getLine(this.tokenBuff, null, null);
            }
            if (this.tokenBuffIdx + 1 < this.tokenBuff.size() && (token2 = (Token)this.tokenBuff.elementAt(this.tokenBuffIdx + 1)).getToknum() == 1) {
                this.tokenBuff.removeElementAt(this.tokenBuffIdx + 1);
                if (this.tokenBuffIdx + 1 < this.tokenBuff.size()) {
                    token2 = (Token)this.tokenBuff.elementAt(this.tokenBuffIdx + 1);
                    if (token.getToknum() == 10006) {
                        token.setWord(".");
                    } else if (token.getToknum() == 44) {
                        token.setWord(",");
                    } else if (token.getToknum() > 127 && token2.getToknum() > 127 && token2.getToknum() != 10006) {
                        token.setWord(token.getWord() + token2.getWord());
                        this.tokenBuff.removeElementAt(this.tokenBuffIdx + 1);
                    }
                }
            }
        }
        if (token == null) {
            if (this.lastVirtualDot) {
                throw new EndOfProgramException();
            }
            this.lastVirtualDot = true;
            token = new Token(10006, ".", 0, 0, "");
        }
        return token;
    }

    public void ungetToken() throws EndOfProgramException {
        do {
            this.ungetAllToken();
        } while (this.tokenBuffIdx > 0 && ((Token)this.tokenBuff.elementAt(this.tokenBuffIdx)).isSeparator());
    }

    public void ungetAllToken() throws EndOfProgramException {
        if (this.tokenBuffIdx >= 0) {
            --this.tokenBuffIdx;
        }
    }

    public void flushToken() {
        this.tokenBuffIdx = -1;
        this.tokenBuff = new Vector();
        for (int i = this.allMarkers.size() - 1; i >= 0; --i) {
            Marker marker = (Marker)this.allMarkers.remove(i);
            Marker.access$002((Marker)marker, (int)-1);
        }
    }

    public void setMarker(Marker marker) {
        Marker.access$002((Marker)marker, (int)this.tokenBuffIdx);
        this.allMarkers.add(marker);
    }

    public void rewindToMarker(Marker marker) throws InternalErrorException {
        if (Marker.access$000((Marker)marker) == -1) {
            throw new InternalErrorException("marker not set");
        }
        this.tokenBuffIdx = Marker.access$000((Marker)marker);
    }

    public void removeMarker(Marker marker) {
        this.allMarkers.remove(marker);
    }

    public int getLineNumber() {
        return this.pp.getLineNumber();
    }

    public String getFileName() {
        return this.pp.getFileName();
    }

    public String getLastLine() {
        return ((StringBuilder)this.pp.lines.lastElement()).toString();
    }

    public OptionList getOptionList() {
        return this.optList;
    }

    public void removeToken(Token token) {
        int n = this.tokenBuff.lastIndexOf(token);
        if (n >= 0) {
            this.tokenBuff.remove(n);
        }
        --this.tokenBuffIdx;
    }

    public void removeLastToken() {
        this.tokenBuff.remove(this.tokenBuffIdx--);
    }

    public void removeToMarker(Marker marker) throws InternalErrorException {
        int n = this.tokenBuffIdx - 1;
        if (Marker.access$000((Marker)marker) == -1) {
            throw new InternalErrorException("marker not set");
        }
        for (int i = n; i >= Marker.access$000((Marker)marker); --i) {
            this.removeToken((Token)this.tokenBuff.elementAt(i));
        }
        this.tokenBuffIdx = Marker.access$000((Marker)marker);
    }

    private static String buildName(Token token) {
        StringBuilder stringBuilder = new StringBuilder(token.getWord());
        if (token.isNational()) {
            stringBuilder.insert(0, "N");
        }
        if (token.isAll()) {
            stringBuilder.insert(0, "all ");
        } else if (token.getNativeSize() > 0) {
            stringBuilder.insert(0, "nat ");
        }
        return stringBuilder.toString();
    }

    public void loadLiteral(Token token) {
        String string = TokenManager.buildName((Token)token);
        if (this.allLiterals.get(string) == null) {
            String string2 = "$" + this.allLiterals.size() + "$";
            this.allLiterals.put(string, new Object[]{string2, token});
        }
    }

    public String getCodeLiteral(Token token) {
        String string = TokenManager.buildName((Token)token);
        Object v = this.allLiterals.get(string);
        if (v == null) {
            this.loadLiteral(token);
            v = this.allLiterals.get(string);
        }
        this.allUsedLiterals.put(string, v);
        return (String)((Object[])v)[0];
    }

    public boolean loadBool() throws InternalErrorException, EndOfProgramException, GeneralErrorException {
        return this.loadBool(true);
    }

    public boolean loadBool(boolean bl) throws InternalErrorException, EndOfProgramException, GeneralErrorException {
        boolean bl2 = false;
        Token token = this.getToken();
        if (token == null || token.getToknum() != 61) {
            throw new InternalErrorException("tm.loadBool error: on line " + (StringBuilder)this.pp.lines.lastElement());
        }
        token = this.getToken();
        if (token != null && (token.getWord().trim().equals("0") || token.getWord().trim().toUpperCase().equals("FALSE"))) {
            bl2 = false;
        } else if (token != null && (token.getWord().trim().equals("1") || token.getWord().trim().toUpperCase().equals("TRUE"))) {
            bl2 = true;
        }
        if (bl && (token = this.getTokNL()) != null) {
            this.ungetToken();
        }
        return bl2;
    }

    public int loadBoolNone() throws InternalErrorException, EndOfProgramException, GeneralErrorException {
        return this.loadBoolNone(true);
    }

    public int loadBoolNone(boolean bl) throws InternalErrorException, EndOfProgramException, GeneralErrorException {
        int n = 0;
        Token token = this.getToken();
        if (token == null || token.getToknum() != 61) {
            throw new InternalErrorException("tm.loadBoolNone error: on line " + (StringBuilder)this.pp.lines.lastElement());
        }
        token = this.getToken();
        if (token != null && (token.getWord().trim().equals("0") || token.getWord().trim().toUpperCase().equals("FALSE"))) {
            n = 1;
        } else if (token != null && (token.getWord().trim().equals("1") || token.getWord().trim().toUpperCase().equals("TRUE"))) {
            n = 2;
        }
        if (bl && (token = this.getTokNL()) != null) {
            this.ungetToken();
        }
        return n;
    }

    public String loadValue() throws InternalErrorException, EndOfProgramException, GeneralErrorException {
        String string = this.loadString(true, false, true);
        if (!string.startsWith("'") && !string.startsWith("\"") && string.contains(":")) {
            string = string.substring(0, string.indexOf(":"));
        }
        return string;
    }

    public String loadString() throws InternalErrorException, EndOfProgramException, GeneralErrorException {
        return this.loadString(true, true, true);
    }

    public String loadString(boolean bl) throws InternalErrorException, EndOfProgramException, GeneralErrorException {
        return this.loadString(bl, true, true);
    }

    public String loadString(boolean bl, boolean bl2, boolean bl3) throws InternalErrorException, EndOfProgramException, GeneralErrorException {
        Token token = this.getToken();
        String string = "";
        if (token == null || token.getToknum() != 61) {
            throw new InternalErrorException("tm.loadString error: on line " + (StringBuilder)this.pp.lines.lastElement());
        }
        if (bl) {
            StringBuilder stringBuilder = this.pp.getLines(token.getFLN() - 1);
            int n = stringBuilder.length() - 1;
            string = stringBuilder.length() > 0 && token.getOffset() < n ? stringBuilder.substring(token.getOffset() + 1).trim() : "";
        } else {
            token = this.getToken();
            if (token != null && token.getToknum() != 41) {
                if (token.getToknum() == 38) {
                    int n = token.getOffset();
                    while (token != null && token.getToknum() == 38 && token.getOffset() == n) {
                        string = string + token.getWord();
                        token = this.getToken();
                        if (token == null || token.getToknum() == 38 || token.getOffset() != ++n) continue;
                        string = string + token.getWord();
                        n += token.getLength();
                        token = this.getToken();
                    }
                    this.ungetToken();
                } else {
                    string = token.getWord();
                    token = this.getToken();
                    boolean bl4 = false;
                    while (token != null && (token.getToknum() == 47 || token.getToknum() == 656)) {
                        if (token.getToknum() == 656) {
                            string = string + " " + token.getWord();
                            token = this.getToken();
                            if (token == null) continue;
                            string = string + " " + token.getWord();
                            bl4 = true;
                            continue;
                        }
                        string = string + token.getWord();
                        token = this.getToken();
                        if (token == null) continue;
                        string = string + token.getWord();
                        bl4 = true;
                    }
                    if (token != null && !bl4) {
                        this.ungetToken();
                    }
                }
            } else {
                string = "";
                if (token != null) {
                    this.ungetToken();
                }
            }
        }
        if (bl && (token = this.getTokNL()) != null) {
            this.ungetToken();
        }
        if (bl3) {
            string = Utilities.normalizeString((String)string, (boolean)bl2);
        }
        return string;
    }

    public String loadStringPar() throws InternalErrorException, EndOfProgramException, GeneralErrorException {
        Token token = this.getToken();
        boolean bl = true;
        String string = "";
        if (token == null || token.getToknum() != 61) {
            throw new InternalErrorException("tm.loadString error: on line " + (StringBuilder)this.pp.lines.lastElement());
        }
        int n = token.getOffset() + 1;
        String string2 = this.pp.lines.lastElement().toString();
        int n2 = token.getFLN();
        int n3 = 1;
        while (n < string2.length() && string2.charAt(n) != ',' && bl) {
            if (string2.charAt(n) == ')') {
                --n3;
            } else if (string2.charAt(n) == '(') {
                ++n3;
            }
            if (n3 == 0) {
                bl = false;
                continue;
            }
            ++n;
        }
        string = string2.substring(token.getOffset() + 1, n).trim();
        while (token != null && token.getOffset() < n && token.getFLN() == n2) {
            token = this.getToken();
        }
        this.ungetToken();
        return string;
    }

    public String loadVar() throws InternalErrorException, EndOfProgramException, GeneralErrorException {
        return this.loadVar(true);
    }

    public String loadVar(boolean bl) throws InternalErrorException, EndOfProgramException, GeneralErrorException {
        String string = this.loadString(bl);
        Token token = this.getToken();
        if (token != null && token.getToknum() == 40) {
            while (token != null && token.getToknum() != 41) {
                string = string + token.getWord();
                token = this.getToken();
            }
            if (token != null) {
                string = string + token.getWord();
            }
            this.oldTok = token;
        } else {
            this.ungetToken();
        }
        return string;
    }

    public StringBuilder getDescr(boolean bl) throws InternalErrorException, EndOfProgramException, GeneralErrorException {
        boolean bl2 = true;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder("");
        try {
            Token token = this.getToken();
            int n = token.getFLN();
            while (token != null && n == token.getFLN()) {
                token = this.getToken();
            }
            n = token.getFLN();
            int n2 = 0;
            while (token != null && bl2) {
                if (n != n2) {
                    stringBuilder2 = this.getLines(n);
                }
                if (stringBuilder2.toString().trim().equals("@}}")) {
                    bl2 = false;
                }
                if (bl2 && n != n2) {
                    if (stringBuilder.length() > 1) {
                        stringBuilder.append("\n");
                    }
                    if (bl) {
                        stringBuilder.append("      *>");
                    }
                    stringBuilder.append((CharSequence)stringBuilder2);
                }
                n2 = n;
                token = this.getToken();
                n = token.getFLN();
            }
            while (token != null && n == token.getFLN()) {
                token = this.getToken();
            }
            if (token != null) {
                this.ungetToken();
            }
        }
        catch (Exception exception) {
            throw new InternalErrorException("TokenManager exception:" + exception + " on line " + (StringBuilder)this.pp.lines.lastElement());
        }
        return stringBuilder;
    }

    public Token getTokNL() throws EndOfProgramException, GeneralErrorException {
        int n = this.oldTok.getFLN();
        Token token = this.getToken();
        while (token != null && n == token.getFLN()) {
            token = this.getToken();
        }
        this.oldTok = token;
        return token;
    }

    public float loadNum() throws InternalErrorException, EndOfProgramException, GeneralErrorException {
        return this.loadNum(true, false);
    }

    public float loadNum(boolean bl) throws InternalErrorException, EndOfProgramException, GeneralErrorException {
        return this.loadNum(bl, false);
    }

    public float loadNum(boolean bl, boolean bl2) throws InternalErrorException, EndOfProgramException, GeneralErrorException {
        boolean bl3;
        Float f = null;
        Token token = this.getToken();
        boolean bl4 = bl3 = token == null;
        if (!bl3) {
            if (bl2) {
                bl3 = token.getToknum() != 61 && token.getToknum() != 43 && token.getToknum() != 45;
            } else {
                boolean bl5 = bl3 = token.getToknum() != 61;
            }
        }
        if (bl3) {
            throw new InternalErrorException("tm.loadNum error: on line " + (StringBuilder)this.pp.lines.lastElement());
        }
        int n = token.getFLN();
        token = this.getToken();
        if (token != null) {
            if (token.getFLN() > n) {
                this.ungetToken();
                return 0.0f;
            }
            String string = token.getWord();
            Token token2 = this.getAllToken();
            if (token2 != null && token2.getToknum() == 44) {
                token2 = this.getToken();
                if (token2 != null && token2.getToknum() == 10002) {
                    string = string + "." + token2.getWord();
                } else {
                    this.ungetToken();
                }
            } else {
                this.ungetAllToken();
            }
            f = new Float(string);
        }
        if (bl && (token = this.getTokNL()) != null) {
            this.ungetToken();
        }
        return f.floatValue();
    }

    public int loadInt(boolean bl) throws InternalErrorException, EndOfProgramException, GeneralErrorException {
        return (int)this.loadNum(bl);
    }

    public int loadInt() throws InternalErrorException, EndOfProgramException, GeneralErrorException {
        return this.loadInt(true);
    }

    public boolean hasDebug() {
        return this.debug;
    }

    public StringBuilder getLines(int n) {
        return this.pp.getLines(n - 1);
    }

    public void setWork(WorkingAcb workingAcb) {
        this.work = workingAcb;
    }

    public void addMyFont(String string, FontType fontType) {
        if (fontType != null) {
            this.myNewFont.put(string, fontType);
        }
    }

    public FontType getFont(String string) {
        return (FontType)this.myNewFont.get(string);
    }

    public void addUsedPopUp(String string, AbstractInputField abstractInputField) {
        this.usedPopUp.put(string.toLowerCase(), abstractInputField);
    }

    public AbstractInputField getUsedPopUp(String string) {
        return (AbstractInputField)this.usedPopUp.get(string.toLowerCase());
    }

    public void addMenuHandle(String string, String string2) {
        this.menuHandle.put(string, string2);
    }

    public String getMenuName(String string) {
        return string != null ? (String)this.menuHandle.get(string) : null;
    }

    public void makeVar(String string) {
        if (this.allVars.get(string.toUpperCase().replace('_', '-')) == null) {
            WorkItem workItem = new WorkItem(this, this.error);
            workItem.setName(string);
            workItem.setLevel(77);
            workItem.setPic("X(80)");
            this.allVars.put(string.toUpperCase().replace('_', '-'), workItem);
            this.work.addField(workItem);
        }
    }

    public void setIsTotem() {
        this.isTotem = true;
    }

    public boolean getIsTotem() {
        return this.isTotem;
    }

    public int getPointIdx() {
        return this.tokenBuffIdx;
    }

    public void ungetUntilSetPoint(int n) {
        if (n != -1) {
            this.tokenBuffIdx = n;
        }
        n = -1;
    }
}

