/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.programimport;

import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.OccursClause;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.programimport.EndOfProgramException;
import com.iscobol.screenpainter.programimport.GeneralErrorException;
import com.iscobol.screenpainter.programimport.InternalErrorException;
import com.iscobol.screenpainter.programimport.Token;
import com.iscobol.screenpainter.programimport.TokenManager;
import com.iscobol.screenpainter.programimport.WorkItem;
import com.iscobol.screenpainter.util.PluginUtilities;
import java.io.File;
import java.util.StringTokenizer;

/*
 * Exception performing whole class analysis ignored.
 */
public class Utilities {
    private static String getImportedCopyPath(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        File file = new File(string);
        if (file.isAbsolute()) {
            return string;
        }
        if (file.getParentFile() != null) {
            int n = string.indexOf(92);
            if (n > 0) {
                return string.substring(n + 1);
            }
            n = string.indexOf(47);
            if (n > 0) {
                return string.substring(n + 1);
            }
        }
        return string;
    }

    public static void setOccurs(WorkItem workItem, VariableType variableType) {
        if (workItem.isOccurs()) {
            if (workItem.getBFixed()) {
                variableType.setOccurs(OccursClause.getOccursFixed((int)workItem.getNSize()));
            } else {
                variableType.setOccurs(OccursClause.getOccursDepOn((int)workItem.getNMin(), (int)workItem.getNMax(), (String)workItem.getOccursDependingOn()));
            }
            if (!workItem.getLstIndex().equals("")) {
                variableType.getOccurs().setIndexed(true);
                variableType.getOccurs().setIndexes(workItem.getLstIndex());
            }
            if (workItem.isKeyList()) {
                variableType.getOccurs().setKeyList(workItem.getKeyList());
                variableType.getOccurs().setKeys(true);
            }
        }
    }

    public static void setCopyAttributes(WorkItem workItem, VariableType variableType) {
        variableType.setCopyFile(workItem.getCopyFile());
        variableType.setCopyEntry(Utilities.getImportedCopyPath((String)workItem.getCopyEntry()));
        variableType.setCopyFilePathName(Utilities.getImportedCopyPath((String)workItem.getCopyFilePathName()));
    }

    public static FontType getRptFont(String string, TokenManager tokenManager) throws InternalErrorException {
        return Utilities.getRptFont((String)string, (boolean)true, (TokenManager)tokenManager);
    }

    public static FontType getRptFont(String string, boolean bl, TokenManager tokenManager) throws InternalErrorException {
        if (string == null || string.equals("")) {
            return FontType.getNullFont();
        }
        FontType fontType = tokenManager.getFont(string);
        if (fontType != null) {
            return fontType;
        }
        String string2 = string.replace(' ', '-');
        if (FontType.isStandardFontName((String)string2)) {
            if (bl || !string2.equalsIgnoreCase("default-font")) {
                return FontType.getStandardFont((String)string2);
            }
            return FontType.getNullFont();
        }
        fontType = Utilities.intGetFont((String)string);
        if (fontType != null) {
            tokenManager.addMyFont(string, fontType);
            fontType.setHandleName(string);
        }
        return fontType;
    }

    private static FontType intGetFont(String string) throws InternalErrorException {
        FontType fontType = null;
        if (string.indexOf(47) < 0) {
            fontType = new FontType(string);
            fontType.setSize(9.0f);
        } else if (string.indexOf(47) == 0) {
            fontType = new FontType("Default Font");
            fontType.setSize(9.0f);
        } else {
            float f = 9.0f;
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            int n2 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                switch (n2) {
                    case 0: {
                        fontType = new FontType(string2);
                        break;
                    }
                    case 1: {
                        int n3 = string2.indexOf(58);
                        if (n3 >= 0) {
                            string2 = string2.substring(0, n3);
                        }
                        f = Float.parseFloat(string2);
                        break;
                    }
                    default: {
                        if (string2.toUpperCase().charAt(0) == 'B') {
                            n += 2;
                            break;
                        }
                        if (string2.toUpperCase().charAt(0) == 'I') {
                            n += 4;
                            break;
                        }
                        if (string2.toUpperCase().charAt(0) == 'U') {
                            n += 8;
                            break;
                        }
                        if (string2.toUpperCase().charAt(0) != 'S') break;
                        n += 16;
                    }
                }
                ++n2;
            }
            if (fontType != null) {
                fontType.setSize(f);
                fontType.setStyle(n);
            }
        }
        return fontType;
    }

    public static String getCustomColors(Token token, TokenManager tokenManager) throws EndOfProgramException, GeneralErrorException {
        StringBuilder stringBuilder = new StringBuilder();
        while (token.getToknum() == 856) {
            Token token2;
            Token token3;
            if (tokenManager.getToken().getToknum() == 61 && tokenManager.getToken().getToknum() == 40 && (token3 = tokenManager.getToken()).getToknum() == 10002 && (token2 = tokenManager.getToken()).getToknum() == 10002) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(";");
                }
                stringBuilder.append(token3.getWord());
                stringBuilder.append(",");
                int n = Integer.parseInt(token2.getWord());
                stringBuilder.append(n & 0xFF);
                stringBuilder.append(",");
                stringBuilder.append((n & 0xFF00) >>> 8);
                stringBuilder.append(",");
                stringBuilder.append((n & 0xFF0000) >>> 16);
                tokenManager.getToken();
                token = tokenManager.getToken();
                continue;
            }
            stringBuilder = null;
            break;
        }
        return stringBuilder != null ? stringBuilder.toString() : null;
    }

    public static String normalizeString(String string, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = cArray.length;
        if (bl && cArray.length > 0 && cArray[0] == '\"') {
            ++n;
            --n2;
        }
        for (int i = n; i < n2; ++i) {
            switch (cArray[i]) {
                case '\"': 
                case '\'': {
                    if (i >= n2 - 1 || cArray[i + 1] != cArray[i]) break;
                    ++i;
                }
            }
            stringBuilder.append(cArray[i]);
        }
        return stringBuilder.toString();
    }

    public static String normalizePrintCondition(String string) {
        String string2;
        if (string == null || string.length() == 0) {
            return string;
        }
        String string3 = PluginUtilities.getLineDelimiter();
        if (string.charAt(0) == '(') {
            StringBuilder stringBuilder = new StringBuilder();
            string = string.substring(1, string.length() - 1).trim();
            char[] cArray = string.toCharArray();
            boolean bl = false;
            for (int i = 0; i < cArray.length; ++i) {
                if (cArray[i] == '\"') {
                    if (!bl) {
                        bl = true;
                        if (stringBuilder.length() <= 0) continue;
                        stringBuilder.append(string3);
                        continue;
                    }
                    if (i < cArray.length - 1 && cArray[i + 1] == '\"') {
                        stringBuilder.append(cArray[++i]);
                        continue;
                    }
                    bl = false;
                    continue;
                }
                if (!bl) continue;
                stringBuilder.append(cArray[i]);
            }
            string2 = stringBuilder.toString();
        } else {
            string2 = Utilities.normalizeString((String)string, (boolean)true);
        }
        return string2;
    }
}

