/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.programimport;

import com.iscobol.screenpainter.beans.types.DataTypeDirective;
import com.iscobol.screenpainter.beans.types.XFDAttributes;
import com.iscobol.screenpainter.programimport.Errors;
import com.iscobol.screenpainter.programimport.InternalErrorException;
import com.iscobol.screenpainter.programimport.IsConsolePlugin;
import com.iscobol.screenpainter.programimport.ProjectToken;
import com.iscobol.screenpainter.programimport.Token;
import com.iscobol.screenpainter.programimport.TokenManager;
import java.util.Vector;
import org.eclipse.core.runtime.Status;

public class WorkItem
implements ProjectToken {
    private String m_strname = "FILLER";
    private String m_strname_xfd = "";
    private String m_stralias = "FILLER";
    private String m_strrawpic = "";
    private String m_strrawmax;
    private String m_strrawmin;
    private boolean m_bname_xfd;
    private String m_strpic = "";
    private String m_strdefaultvalue = "";
    private String m_streditformat = "";
    private String m_strtrue = "";
    private String m_strfalse = "";
    private String m_strprompt = "";
    private int m_nblank;
    private int m_ntype;
    private int m_nusage;
    private int m_nspecial;
    private int m_nexternal;
    private int m_bredefines;
    private boolean m_bcomment;
    private int m_bvalue;
    private int m_bindexed;
    private int m_boccurs;
    private boolean m_boccurskey;
    private boolean m_bwhenxfd;
    private boolean m_busegroupxfd;
    private boolean m_bdatatypexfd;
    private int m_ndatatypexfd;
    private String m_lstindex = "";
    private String m_strredefines = "";
    private String m_strrawsize = "";
    private String m_strdateformatxfd = "";
    private String m_strcommentxfd = "";
    private int m_nmax;
    private int m_nmin;
    private int m_nsize;
    private int m_nsign;
    private boolean m_bfixed;
    private int m_nsync;
    private int m_njustified;
    private String m_strCopyE = "";
    private String m_strCopyF = "";
    private String m_strCopyL = "";
    private String m_strCopyP = "";
    private String m_stroccd = "";
    private String m_strtable = "";
    private String m_strwhenxfd = "";
    private StringBuilder description = new StringBuilder();
    Vector fields = new Vector();
    private TokenManager tm;
    private int m_nitemlevel;
    Vector children = new Vector();
    private WorkItem lastChild;
    private boolean isAdded;
    private boolean haveXFD;
    private XFDAttributes xfda;
    private int m_nglobal;
    private String m_1stindex = "";
    private boolean isKeyList;
    private String keys = "";

    public WorkItem(TokenManager tokenManager, Errors errors) {
        this.tm = tokenManager;
    }

    public WorkItem(TokenManager tokenManager, Errors errors, Vector vector) throws InternalErrorException {
        this.tm = tokenManager;
        try {
            this.tm.getTokNL();
            this.tm.ungetToken();
        }
        catch (Exception exception) {
            throw new InternalErrorException("WorkItem Error " + exception);
        }
        this.loadField(vector);
    }

    boolean loadField(Vector vector) throws InternalErrorException {
        boolean bl = true;
        try {
            Token token = this.tm.getToken();
            int n = token.getFLN();
            while (token != null && bl) {
                String string;
                try {
                    switch (token.getToknum()) {
                        case 538: {
                            this.m_nitemlevel = this.tm.loadInt();
                            break;
                        }
                        case 527: {
                            this.m_nblank = this.tm.loadInt();
                            break;
                        }
                        case 552: {
                            this.m_ntype = this.tm.loadInt();
                            break;
                        }
                        case 612: {
                            this.m_strname = this.tm.loadString();
                            break;
                        }
                        case 613: {
                            if (!this.haveXFD) {
                                this.xfda = new XFDAttributes();
                                this.haveXFD = true;
                            }
                            this.m_strname_xfd = this.tm.loadString();
                            this.xfda.setNameDirective(this.m_strname_xfd);
                            break;
                        }
                        case 600: {
                            this.m_stralias = this.tm.loadString();
                            break;
                        }
                        case 609: {
                            this.m_strfalse = this.tm.loadValue();
                            break;
                        }
                        case 626: {
                            this.m_strtrue = this.tm.loadValue();
                            break;
                        }
                        case 616: {
                            this.m_strpic = this.tm.loadString();
                            break;
                        }
                        case 618: {
                            this.m_strprompt = this.tm.loadString();
                            break;
                        }
                        case 620: {
                            this.m_strrawmax = this.tm.loadString();
                            break;
                        }
                        case 621: {
                            this.m_strrawmin = this.tm.loadString();
                            break;
                        }
                        case 619: {
                            this.m_strrawpic = this.tm.loadString();
                            break;
                        }
                        case 607: {
                            this.m_strdefaultvalue = this.tm.loadValue();
                            break;
                        }
                        case 550: {
                            this.m_strdefaultvalue = this.tm.loadValue();
                            break;
                        }
                        case 608: {
                            this.m_streditformat = this.tm.loadString();
                            break;
                        }
                        case 553: {
                            this.m_nusage = this.tm.loadInt();
                            break;
                        }
                        case 549: {
                            this.m_nspecial = this.tm.loadInt();
                            break;
                        }
                        case 534: {
                            this.m_nexternal = this.tm.loadInt();
                            break;
                        }
                        case 492: {
                            if (!this.haveXFD) {
                                this.xfda = new XFDAttributes();
                                this.haveXFD = true;
                            }
                            this.m_bcomment = this.tm.loadBool();
                            this.xfda.setUseCommentDirective(this.m_bcomment);
                            break;
                        }
                        case 508: {
                            this.m_bredefines = this.tm.loadInt();
                            break;
                        }
                        case 513: {
                            this.m_bvalue = this.tm.loadInt();
                            break;
                        }
                        case 499: {
                            this.m_bindexed = this.tm.loadInt();
                            break;
                        }
                        case 503: {
                            this.m_boccurs = this.tm.loadInt();
                            break;
                        }
                        case 504: {
                            this.m_boccurskey = this.tm.loadBool();
                            break;
                        }
                        case 525: {
                            this.m_lstindex = this.tm.loadString();
                            break;
                        }
                        case 541: {
                            this.m_nmax = this.tm.loadInt();
                            break;
                        }
                        case 542: {
                            this.m_nmin = this.tm.loadInt();
                            break;
                        }
                        case 548: {
                            this.m_nsign = this.tm.loadInt();
                            break;
                        }
                        case 547: {
                            this.m_nsize = this.tm.loadInt();
                            break;
                        }
                        case 539: {
                            this.m_njustified = this.tm.loadInt();
                            break;
                        }
                        case 624: {
                            this.m_strredefines = this.tm.loadString();
                            break;
                        }
                        case 546: {
                            this.m_strredefines = this.tm.loadString();
                            break;
                        }
                        case 622: {
                            this.m_strrawsize = this.tm.loadString();
                            break;
                        }
                        case 551: {
                            this.m_nsync = this.tm.loadInt();
                            break;
                        }
                        case 498: {
                            this.m_bfixed = this.tm.loadBool();
                            break;
                        }
                        case 502: {
                            if (!this.haveXFD) {
                                this.xfda = new XFDAttributes();
                                this.haveXFD = true;
                            }
                            this.m_bname_xfd = this.tm.loadBool();
                            break;
                        }
                        case 514: {
                            if (!this.haveXFD) {
                                this.xfda = new XFDAttributes();
                                this.haveXFD = true;
                            }
                            this.m_bwhenxfd = this.tm.loadBool();
                            this.xfda.setUseWhenDirective(this.m_bwhenxfd);
                            break;
                        }
                        case 602: {
                            if (!this.haveXFD) {
                                this.xfda = new XFDAttributes();
                                this.haveXFD = true;
                            }
                            this.m_strcommentxfd = this.tm.loadString();
                            this.xfda.setUseCommentDirective(true);
                            this.xfda.setCommentDirective(this.m_strcommentxfd);
                            break;
                        }
                        case 603: {
                            this.m_strCopyE = this.tm.loadString();
                            break;
                        }
                        case 604: {
                            this.m_strCopyF = this.tm.loadString();
                            break;
                        }
                        case 531: {
                            this.m_strCopyL = this.tm.loadString();
                            break;
                        }
                        case 605: {
                            this.m_strCopyP = this.tm.loadString();
                            break;
                        }
                        case 614: {
                            this.m_stroccd = this.tm.loadString();
                            break;
                        }
                        case 512: {
                            if (!this.haveXFD) {
                                this.xfda = new XFDAttributes();
                                this.haveXFD = true;
                            }
                            this.m_busegroupxfd = this.tm.loadBool();
                            this.xfda.setUseGroupDirective(this.m_busegroupxfd);
                            break;
                        }
                        case 495: {
                            if (!this.haveXFD) {
                                this.xfda = new XFDAttributes();
                                this.haveXFD = true;
                            }
                            this.m_bdatatypexfd = this.tm.loadBool();
                            this.xfda.setUseDataTypeDirective(this.m_bdatatypexfd);
                            break;
                        }
                        case 532: {
                            if (!this.haveXFD) {
                                this.xfda = new XFDAttributes();
                                this.haveXFD = true;
                            }
                            this.m_ndatatypexfd = this.tm.loadInt();
                            this.xfda.setDataTypeDirective(new DataTypeDirective(this.m_ndatatypexfd));
                            break;
                        }
                        case 606: {
                            if (!this.haveXFD) {
                                this.xfda = new XFDAttributes();
                                this.haveXFD = true;
                            }
                            this.m_strdateformatxfd = this.tm.loadString();
                            this.xfda.setDateFormat(this.m_strdateformatxfd);
                            break;
                        }
                        case 628: {
                            if (!this.haveXFD) {
                                this.xfda = new XFDAttributes();
                                this.haveXFD = true;
                            }
                            this.m_strtable = this.tm.loadString();
                            this.xfda.setTableName(this.m_strtable);
                            break;
                        }
                        case 627: {
                            if (!this.haveXFD) {
                                this.xfda = new XFDAttributes();
                                this.haveXFD = true;
                            }
                            this.m_strwhenxfd = this.tm.loadString();
                            this.xfda.setWhenDirective(this.m_strwhenxfd);
                            break;
                        }
                        case 537: {
                            this.m_nglobal = this.tm.loadInt();
                            break;
                        }
                        case 524: {
                            this.m_1stindex = this.tm.loadString();
                            break;
                        }
                        default: {
                            if (token.getToknum() != 123) {
                                throw new InternalErrorException("Working storage item unexpected token: " + token.getWord() + " on line " + vector.lastElement());
                            }
                            break;
                        }
                    }
                }
                catch (InternalErrorException internalErrorException) {
                    switch (token.getToknum()) {
                        case 514: {
                            if (this.m_bwhenxfd) {
                                this.tm.getTokNL();
                                this.tm.ungetToken();
                                break;
                            }
                        }
                        case 502: {
                            if (this.m_bname_xfd) {
                                this.tm.getTokNL();
                                this.tm.ungetToken();
                                break;
                            }
                        }
                        case 532: {
                            if (this.m_bdatatypexfd) {
                                this.tm.getTokNL();
                                this.tm.ungetToken();
                                break;
                            }
                        }
                        default: {
                            IsConsolePlugin.log((Status)new Status(2, this.tm.getFileName(), 0, internalErrorException.getMessage() + "\n" + internalErrorException.getStackTrace(), null));
                            this.tm.getTokNL();
                            this.tm.ungetToken();
                        }
                    }
                }
                if (n != token.getFLN() && (string = ((StringBuilder)vector.lastElement()).toString().trim()).length() > 33 && string.substring(0, 34).equalsIgnoreCase("{{@DataItem_m_strDescriptionFDITEM")) {
                    this.description = this.tm.getDescr(true);
                    string = ((StringBuilder)vector.lastElement()).toString();
                    while (string.length() > 18 && string.substring(0, 18).equals("[DATAITEMOCCURSKEY")) {
                        this.isKeyList = true;
                        token = this.tm.getTokNL();
                        n = token.getFLN();
                        String string2 = "D";
                        while (token != null && bl) {
                            switch (token.getToknum()) {
                                case 489: {
                                    if (this.tm.loadBool()) {
                                        string2 = "A";
                                        break;
                                    }
                                    string2 = "D";
                                    break;
                                }
                                case 511: {
                                    this.tm.loadString();
                                    break;
                                }
                                default: {
                                    if (token.getToknum() != 123) {
                                        throw new InternalErrorException("Working storage item in occurs unexpected token: " + token.getWord() + " on line " + vector.lastElement());
                                    }
                                    bl = false;
                                }
                            }
                            if (!bl) continue;
                            token = this.tm.getToken();
                        }
                        string = ((StringBuilder)vector.lastElement()).toString();
                        if (string.length() > 40 && string.substring(0, 40).equalsIgnoreCase("{{@Key_m_strDescriptionDATAITEMOCCURSKEY")) {
                            this.description.append((CharSequence)this.tm.getDescr(true));
                        }
                        string = ((StringBuilder)vector.lastElement()).toString();
                        bl = true;
                        while (string.length() > 29 && string.substring(0, 29).equals("[SLKEYATOM0_DATAITEMOCCURSKEY")) {
                            token = this.tm.getTokNL();
                            n = token.getFLN();
                            while (token != null && bl) {
                                switch (token.getToknum()) {
                                    case 612: {
                                        this.keys = this.keys + string2 + this.tm.loadString() + ";";
                                        break;
                                    }
                                    case 792: {
                                        this.tm.loadBool();
                                        break;
                                    }
                                    default: {
                                        if (token.getToknum() != 91) {
                                            throw new InternalErrorException("Working storage item in occurs unexpected token: " + token.getWord() + " on line " + vector.lastElement());
                                        }
                                        bl = false;
                                        this.tm.ungetToken();
                                    }
                                }
                                if (!bl) continue;
                                token = this.tm.getToken();
                            }
                            string = ((StringBuilder)vector.lastElement()).toString();
                            bl = true;
                        }
                        string = ((StringBuilder)vector.lastElement()).toString();
                    }
                    bl = false;
                }
                n = token.getFLN();
                if (!bl) continue;
                token = this.tm.getToken();
            }
        }
        catch (InternalErrorException internalErrorException) {
            throw internalErrorException;
        }
        catch (Exception exception) {
            throw new InternalErrorException("Exception in WorkItem: " + exception + " on line " + vector.lastElement());
        }
        this.tm.allVars.put(this.m_strname.toUpperCase().replace('_', '-'), this);
        if (this.tm.hasDebug()) {
            System.out.println("------>Working storage");
            System.out.println("m_strname [" + this.m_strname + "]");
            System.out.println("m_ntype [" + this.m_ntype + "]");
            System.out.println("m_nusage [" + this.m_nusage + "]");
            System.out.println("m_strrawpic [" + this.m_strrawpic + "]");
            System.out.println("m_strpic [" + this.m_strpic + "]");
            System.out.println("m_nitemlevel [" + this.m_nitemlevel + "]");
            System.out.println("m_njustified [" + this.m_njustified + "]");
            System.out.println("m_strdefaultvalue [" + this.m_strdefaultvalue + "]");
            System.out.println("m_bindexed [" + this.m_bindexed + "]");
            System.out.println("m_boccurs [" + this.m_boccurs + "]");
            System.out.println("m_lstindex [" + this.m_lstindex + "]");
            System.out.println("m_bredefines [" + this.m_bredefines + "]");
            System.out.println("m_bvalue [" + this.m_bvalue + "]");
            System.out.println("m_strredefines [" + this.m_strredefines + "]");
            System.out.println("m_strrawsize [" + this.m_strrawsize + "]");
            System.out.println("m_strrawmax [" + this.m_strrawmax + "]");
            System.out.println("m_strrawmin [" + this.m_strrawmin + "]");
            System.out.println("m_strtrue [" + this.m_strtrue + "]");
            System.out.println("m_strfalse [" + this.m_strfalse + "]");
            System.out.println("m_nsize [" + this.m_nsize + "]");
            System.out.println("m_nsign [" + this.m_nsign + "]");
            System.out.println("m_nmax [" + this.m_nmax + "]");
            System.out.println("m_nmin [" + this.m_nmin + "]");
            System.out.println("m_nsync [" + this.m_nsync + "]");
            System.out.println("m_nblank [" + this.m_nblank + "]");
            System.out.println("m_bfixed [" + this.m_bfixed + "]");
            System.out.println("m_stroccd [" + this.m_stroccd + "]");
            System.out.println("m_strCopyE [" + this.m_strCopyE + "]");
            System.out.println("m_strCopyF [" + this.m_strCopyF + "]");
            System.out.println("m_strCopyL [" + this.m_strCopyL + "]");
            System.out.println("m_strCopyP [" + this.m_strCopyP + "]");
            System.out.println("description [" + this.description + "]");
        }
        return true;
    }

    public int getLevel() {
        return this.m_nitemlevel;
    }

    public String getPic() {
        return this.m_strpic;
    }

    public void addChild(WorkItem workItem) {
        if (workItem != this.lastChild) {
            this.children.add(workItem);
        }
        this.lastChild = workItem;
    }

    public String getName() {
        return this.m_strname;
    }

    public String getRedefines() {
        return this.m_strredefines;
    }

    public String getValue() {
        if (this.m_nitemlevel == 88) {
            return this.m_strtrue;
        }
        return this.m_strdefaultvalue;
    }

    public String getFalseValue() {
        if (this.m_nitemlevel == 88) {
            return this.m_strfalse;
        }
        return null;
    }

    public int getUsage() {
        return this.m_nusage;
    }

    public boolean havePic() {
        return this.m_nusage > 13 || this.m_strpic != "";
    }

    public int getNSign() {
        return this.m_nsign;
    }

    public int getNSize() {
        return this.m_nsize;
    }

    public String getStrRawPic() {
        return this.m_strrawpic;
    }

    public String getStrRawMax() {
        return this.m_strrawmax;
    }

    public String getStrRawMin() {
        return this.m_strrawmin;
    }

    public String getStrRawSize() {
        return this.m_strrawsize;
    }

    public String getStrAlias() {
        return this.m_stralias;
    }

    public String getStrDefaultValue() {
        return this.m_strdefaultvalue;
    }

    public int getNSync() {
        return this.m_nsync;
    }

    public int getNBlank() {
        return this.m_nblank;
    }

    public int getNSpecial() {
        return this.m_nspecial;
    }

    public int getNExternal() {
        return this.m_nexternal;
    }

    public int getBRedefines() {
        return this.m_bredefines;
    }

    public int getBValue() {
        return this.m_bvalue;
    }

    public int getBIndexed() {
        return this.m_bindexed;
    }

    public int getBOccurs() {
        return this.m_boccurs;
    }

    public boolean getBFixed() {
        return this.m_bfixed;
    }

    public int getNMax() {
        return this.m_nmax;
    }

    public int getNMin() {
        return this.m_nmin;
    }

    public int getNType() {
        return this.m_ntype;
    }

    public int getNJustified() {
        return this.m_njustified;
    }

    public String getLstIndex() {
        return this.m_lstindex;
    }

    public String getOccursDependingOn() {
        return this.m_stroccd;
    }

    public String getCopyFile() {
        return this.m_strCopyF;
    }

    public String getCopyFilePathName() {
        return this.m_strCopyP;
    }

    public String getCopyEntry() {
        return this.m_strCopyE;
    }

    public boolean getHaveXFD() {
        return this.haveXFD;
    }

    public XFDAttributes getXFDAttribues() {
        return this.xfda;
    }

    public String getDesc() {
        return this.description.toString();
    }

    public String getStrCommentXfd() {
        return this.m_strcommentxfd;
    }

    public boolean getUseCommentXFD() {
        return this.m_bcomment;
    }

    public void setLevel(int n) {
        this.m_nitemlevel = n;
    }

    public void setPic(String string) {
        this.m_strpic = string;
    }

    public void setName(String string) {
        this.m_strname = string;
    }

    public void setIsAdded(boolean bl) {
        this.isAdded = bl;
    }

    public boolean isOccurs() {
        return this.m_boccurs == 1;
    }

    public boolean isAdded() {
        return this.isAdded;
    }

    public int getNGlobal() {
        return this.m_nglobal;
    }

    public boolean isOccurKeys() {
        return this.m_boccurskey;
    }

    public boolean isKeyList() {
        return this.isKeyList;
    }

    public String getKeyList() {
        return this.keys;
    }

    public WorkItem getLastElement() {
        if (((WorkItem)this.children.lastElement()).children.isEmpty()) {
            return (WorkItem)this.children.lastElement();
        }
        return ((WorkItem)this.children.lastElement()).getLastElement();
    }

    public WorkItem getLastChild() {
        return this.lastChild;
    }
}

