/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.programimport;

import com.iscobol.screenpainter.ScreenProgram;
import com.iscobol.screenpainter.beans.types.FileSection;
import com.iscobol.screenpainter.beans.types.FontType;
import com.iscobol.screenpainter.beans.types.SettingTreeItem;
import com.iscobol.screenpainter.beans.types.SignClause;
import com.iscobol.screenpainter.beans.types.SpecialNamesClause;
import com.iscobol.screenpainter.beans.types.VariableType;
import com.iscobol.screenpainter.beans.types.VariableTypeList;
import com.iscobol.screenpainter.beans.types.VariableUsage;
import com.iscobol.screenpainter.programimport.Errors;
import com.iscobol.screenpainter.programimport.InternalErrorException;
import com.iscobol.screenpainter.programimport.IsConsolePlugin;
import com.iscobol.screenpainter.programimport.ProjectToken;
import com.iscobol.screenpainter.programimport.Token;
import com.iscobol.screenpainter.programimport.TokenManager;
import com.iscobol.screenpainter.programimport.Utilities;
import com.iscobol.screenpainter.programimport.WorkItem;
import com.iscobol.screenpainter.propertysheet.ResourceRegistry;
import java.util.Enumeration;
import java.util.Vector;
import org.eclipse.core.runtime.Status;

public class WorkingAcb
implements ProjectToken {
    private String m_ntype = "";
    private String m_strname = "";
    private String m_bblockrecords = "";
    private String m_brecordfixed = "";
    private String m_bstandard = "";
    private int m_bxfdfile = 0;
    private StringBuilder description = new StringBuilder();
    private Vector fields = new Vector();
    private Errors error;
    private TokenManager tm;
    private WorkItem lastField = null;
    private WorkItem lastAdded = null;
    private boolean positioned = false;
    private String actLin = "";

    public WorkingAcb(TokenManager tokenManager, Errors errors, Vector vector, ScreenProgram screenProgram, String string) throws InternalErrorException {
        this.tm = tokenManager;
        this.error = errors;
        Token token = null;
        Token token2 = null;
        try {
            token = token2 = this.tm.getToken();
            token2 = this.tm.getToken();
            while (token2 != null && (token.getToknum() != 91 || token2.getToknum() != 787)) {
                token = token2;
                token2 = this.tm.getToken();
            }
            if (token2 == null) {
                throw new InternalErrorException("[WORKING_STORAGE] not found! on line " + vector.lastElement());
            }
            token2 = this.tm.getToken();
            if (token2 == null || token2.getToknum() != 93) {
                throw new InternalErrorException("[WORKING_STORAGE] not found! on line " + vector.lastElement());
            }
        }
        catch (InternalErrorException internalErrorException) {
            throw internalErrorException;
        }
        catch (Exception exception) {
            throw new InternalErrorException("Working Error " + exception);
        }
        this.loadWork(vector, string);
        this.loadFields(vector, (WorkItem)null, string);
        if (this.lastField != this.lastAdded && (this.lastAdded.children.isEmpty() || this.lastAdded.children.lastElement() != this.lastField) && this.lastField.getLevel() != 78 && this.lastField.getLevel() != 66 && this.lastField.getLevel() != 88) {
            this.fields.add(this.lastField);
        }
    }

    boolean loadWork(Vector vector, String string) throws InternalErrorException {
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        try {
            Token token = this.tm.getToken();
            int n = token.getFLN();
            while (token != null && bl) {
                switch (token.getToknum()) {
                    case 552: {
                        this.m_ntype = this.tm.loadString();
                        break;
                    }
                    case 612: {
                        this.m_strname = this.tm.loadString();
                        break;
                    }
                    case 491: {
                        this.m_bblockrecords = this.tm.loadString();
                        break;
                    }
                    case 507: {
                        this.m_brecordfixed = this.tm.loadString();
                        break;
                    }
                    case 509: {
                        this.m_bstandard = this.tm.loadString();
                        break;
                    }
                    case 510: {
                        this.m_bxfdfile = this.tm.loadInt();
                        break;
                    }
                    default: {
                        if (token.getToknum() == 123) break;
                        IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter" + string, 0, "In WORKING_STORAGE Unexpected token: " + token.getWord() + " At line:" + token.getFLN(), null));
                        this.tm.loadString();
                    }
                }
                if (n != token.getFLN() && (stringBuilder = (StringBuilder)vector.lastElement()).toString().trim().equals("{{@FD_m_strDescriptionWK")) {
                    this.description = this.tm.getDescr(true);
                    bl = false;
                }
                n = token.getFLN();
                if (!bl) continue;
                token = this.tm.getToken();
            }
        }
        catch (InternalErrorException internalErrorException) {
            throw internalErrorException;
        }
        catch (Exception exception) {
            throw new InternalErrorException("Exception in WorkingAcb " + exception + " on line " + vector.lastElement());
        }
        if (this.tm.hasDebug()) {
            System.out.println("------>Working storage");
            System.out.println("m_ntype [" + this.m_ntype + "]");
            System.out.println("m_bblockrecords [" + this.m_bblockrecords + "]");
            System.out.println("m_brecordfixed [" + this.m_brecordfixed + "]");
            System.out.println("m_bstandard [" + this.m_bstandard + "]");
            System.out.println("m_strname [" + this.m_strname + "]");
            System.out.println("description [" + this.description + "]");
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    WorkItem loadFields(Vector vector, WorkItem workItem, String string) throws InternalErrorException {
        WorkItem workItem2 = null;
        WorkItem workItem3 = null;
        boolean bl = true;
        try {
            Token token = this.tm.getToken();
            this.actLin = ((StringBuilder)vector.lastElement()).toString();
            while (bl && token != null && this.actLin.length() > 7 && this.actLin.substring(0, 7).equals("[FDITEM")) {
                if (workItem3 != null) {
                    workItem2 = workItem3;
                    workItem3 = null;
                } else {
                    workItem2 = new WorkItem(this.tm, this.error, vector);
                    this.positioned = false;
                    if (workItem2.getLevel() != 88 && workItem2.getLevel() != 78 && workItem2.getLevel() != 66) {
                        this.lastField = workItem2;
                    }
                }
                if (workItem2.getLevel() == 78) {
                    this.fields.add(workItem2);
                    this.lastAdded = workItem2;
                    if (this.lastField != null && this.lastField.getLevel() == 77) {
                        this.lastField = workItem2;
                    }
                } else if (workItem2.getLevel() == 66) {
                    this.fields.add(workItem2);
                    this.lastAdded = workItem2;
                    if (this.lastField != null && this.lastField.getLevel() == 77) {
                        this.lastField = workItem2;
                    }
                } else if (workItem2.getLevel() == 88) {
                    if (this.lastField != null) {
                        this.lastField.addChild(workItem2);
                    }
                } else {
                    if (workItem != null && workItem.getLevel() >= workItem2.getLevel()) {
                        return workItem2;
                    }
                    if (workItem2.getLevel() == 77 || workItem2.getLevel() == 1 && workItem2.havePic()) {
                        if (workItem != null) return workItem2;
                        this.fields.add(workItem2);
                        this.lastAdded = workItem2;
                    } else if (!workItem2.havePic()) {
                        if (workItem == null) {
                            this.fields.add(workItem2);
                            this.lastAdded = workItem2;
                            workItem3 = this.loadFields(vector, workItem2, string);
                        } else if (workItem.getLevel() < workItem2.getLevel()) {
                            workItem.addChild(workItem2);
                            workItem3 = this.loadFields(vector, workItem2, string);
                        } else if (workItem.getLevel() >= workItem2.getLevel()) {
                            return workItem2;
                        }
                    } else {
                        if (workItem == null) {
                            workItem = this.lastField;
                        }
                        workItem.addChild(workItem2);
                        this.lastAdded = workItem2;
                    }
                }
                if (this.positioned) continue;
                token = this.tm.getToken();
                this.actLin = ((StringBuilder)vector.lastElement()).toString();
                if (this.actLin.toString().trim().equals("@}}")) {
                    token = this.tm.getTokNL();
                    this.actLin = ((StringBuilder)vector.lastElement()).toString();
                }
                this.positioned = true;
            }
            this.tm.ungetToken();
            return null;
        }
        catch (InternalErrorException internalErrorException) {
            throw internalErrorException;
        }
        catch (Exception exception) {
            throw new InternalErrorException("Exception loadFields WorkingAcb " + exception + " on line " + vector.lastElement());
        }
    }

    void loadVar(ScreenProgram screenProgram) {
        ResourceRegistry resourceRegistry = screenProgram.getResourceRegistry();
        VariableTypeList variableTypeList = resourceRegistry.getVariableTypeList();
        FileSection fileSection = screenProgram.getFileSection();
        Enumeration enumeration = this.fields.elements();
        while (enumeration.hasMoreElements()) {
            WorkItem workItem = (WorkItem)enumeration.nextElement();
            VariableType variableType = this.setVariable(screenProgram, workItem, null);
            if (!(variableType.getName().length() > 8 && variableType.getName().substring(0, 8).equalsIgnoreCase("f-status") && fileSection.findFDName(variableType.getName().substring(8, variableType.getName().length())) >= 0 || variableType.getName().toUpperCase().equals("TRADITIONAL-FONT") || variableType.getName().toUpperCase().equals("FIXED-FONT") || variableType.getName().toUpperCase().equals("LARGE-FONT") || variableType.getName().toUpperCase().equals("SMALL-FONT") || variableType.getName().toUpperCase().equals("MEDIUM-FONT") || variableType.getName().toUpperCase().equals("DEFAULT-FONT") || this.tm.allVars.get(variableType.getName().toUpperCase().replace('_', '-')) == null)) {
                variableTypeList.addVariable(variableType);
            }
            if (!variableType.getName().toUpperCase().equals("KEY-STATUS")) continue;
            screenProgram.setGenerateKeyStatus(false);
        }
    }

    VariableType setVariable(ScreenProgram screenProgram, WorkItem workItem, VariableType variableType) {
        FontType fontType = this.tm.getFont(workItem.getName());
        int n = workItem.getLevel();
        VariableType variableType2 = VariableType.newInstance((int)n);
        variableType2.setName(workItem.getName());
        variableType2.setInLinkage(false);
        if (!workItem.getPic().equals("PIC78")) {
            variableType2.setPicture(workItem.getPic());
        }
        variableType2.setValue(workItem.getValue());
        variableType2.setFalseValue(workItem.getFalseValue());
        variableType2.setRedefines(workItem.getRedefines());
        variableType2.setUsage(new VariableUsage(VariableUsage.acuUsage2IsUsage((int)workItem.getUsage())));
        if (workItem.getUsage() > 54) {
            IsConsolePlugin.log((Status)new Status(2, "com.iscobol.plugins.screenpainter.IscobolScreenPainter", 0, "In WORKING_STORAGE Unexpected usage:" + workItem.getUsage() + " for variable " + workItem.getName(), null));
        }
        if (fontType != null) {
            fontType.setHandle(variableType2);
            variableType2.setUsage(new VariableUsage(26));
            variableType2.setPicture("");
        }
        variableType2.setStrRawPic(workItem.getStrRawPic());
        variableType2.setStrRawMin(workItem.getStrRawMin());
        variableType2.setStrRawMax(workItem.getStrRawMax());
        variableType2.setStrAlias(workItem.getStrAlias());
        variableType2.setNType(workItem.getNType());
        variableType2.setBlankWhenZero(workItem.getNBlank() != 0);
        int n2 = workItem.getNSpecial();
        n2 = n2 >= 0 && n2 < SpecialNamesClause.acu2is.length ? SpecialNamesClause.acu2is[n2] : 0;
        variableType2.setSpecialNames(new SpecialNamesClause(n2));
        variableType2.setExternal(workItem.getNExternal() != 0);
        variableType2.setBRedefines(workItem.getBRedefines());
        variableType2.setBValue(workItem.getBValue());
        variableType2.setBIndex(workItem.getBIndexed());
        Utilities.setOccurs((WorkItem)workItem, (VariableType)variableType2);
        variableType2.getOccurs().setFixed(workItem.getBFixed());
        variableType2.setSynchronized(workItem.getNSync() != 0);
        variableType2.setJustified(workItem.getNJustified() != 0);
        variableType2.setLstIndex(workItem.getLstIndex());
        Utilities.setCopyAttributes((WorkItem)workItem, (VariableType)variableType2);
        variableType2.setComment(workItem.getDesc());
        variableType2.setSign(new SignClause(workItem.getNSign()));
        int n3 = 0;
        Enumeration enumeration = workItem.children.elements();
        while (enumeration.hasMoreElements()) {
            WorkItem workItem2 = (WorkItem)enumeration.nextElement();
            variableType2.addChild(++n3, (SettingTreeItem)this.setVariable(screenProgram, workItem2, variableType2));
        }
        return variableType2;
    }

    void addField(WorkItem workItem) {
        this.fields.add(workItem);
    }
}

