/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet;

import com.iscobol.screenpainter.propertysheet.CellEditor;
import com.iscobol.screenpainter.propertysheet.ValueListener;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class CellEditor {
    protected ICellEditorValidator validator;
    protected String errorMessage;
    protected boolean valueValid;
    protected ValueListener vListener;
    protected boolean editable = true;

    public void setListener(ValueListener valueListener) {
        this.vListener = valueListener;
    }

    protected void handleValueChanged() {
        Object object = this.getValue();
        if (this.editable) {
            this.valueValid = this.isCorrect(object);
            if (this.vListener != null) {
                this.vListener.valueChanged(object);
            }
        } else {
            this.valueValid = true;
        }
    }

    void intHandleEvent(Event event) {
        switch (event.type) {
            case 16: {
                this.handleValueChanged();
                this.dispose();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 4: {
                        this.handleValueChanged();
                    }
                    case 2: {
                        this.dispose();
                        event.doit = false;
                    }
                }
            }
        }
    }

    public void createEditor(Composite composite) {
        this.intCreateEditor(composite);
        TableItemListener tableItemListener = new TableItemListener(this, null);
        this.addListener(16, (Listener)tableItemListener);
        this.addListener(31, (Listener)tableItemListener);
    }

    protected abstract void intCreateEditor(Composite var1);

    public abstract Control getEditor();

    public final void setValue(Object object) {
        this.valueValid = this.isCorrect(object);
        this.doSetValue(object);
    }

    protected boolean isCorrect(Object object) {
        this.errorMessage = null;
        if (this.validator == null) {
            return true;
        }
        this.errorMessage = this.validator.isValid(object);
        return this.errorMessage == null || this.errorMessage.equals("");
    }

    public abstract void doSetValue(Object var1);

    public abstract Object getValue();

    abstract void addListener(int var1, Listener var2);

    public abstract void dispose();

    public abstract void selectAll();

    public abstract void setFocus();

    public ICellEditorValidator getValidator() {
        return this.validator;
    }

    public void setValidator(ICellEditorValidator iCellEditorValidator) {
        this.validator = iCellEditorValidator;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        this.errorMessage = string;
    }

    public boolean isValueValid() {
        return this.valueValid;
    }

    public void setValueValid(boolean bl) {
        this.valueValid = bl;
    }

    public abstract String valueToString(Object var1);

    public void setEditable(boolean bl) {
        this.editable = bl;
    }

    public boolean isEditable() {
        return this.editable;
    }
}

