/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet;

import com.iscobol.screenpainter.beans.AbstractGrid;
import com.iscobol.screenpainter.beans.types.GridCellSetting;
import com.iscobol.screenpainter.beans.types.GridCellSettingList;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.beans.types.SettingItemList;
import com.iscobol.screenpainter.dialogs.SettingsDialog;
import com.iscobol.screenpainter.model.GridModel;
import com.iscobol.screenpainter.parts.IscobolScreenPainterEditPart;
import com.iscobol.screenpainter.propertysheet.CellSettingsContentPane;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.propertysheet.PropertySheetContainer;
import com.iscobol.screenpainter.propertysheet.PropertySheetTable;
import com.iscobol.screenpainter.propertysheet.SettingsContentPane;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TreeItem;

public class CellSettingsContentPane
extends SettingsContentPane {
    private int gridRowCount;
    private int gridColumnCount;

    public CellSettingsContentPane(Composite composite, SettingsDialog settingsDialog, GridCellSettingList gridCellSettingList, int n, int n2) {
        super(composite, settingsDialog, (SettingItemList)gridCellSettingList, 600, n, n2);
        IscobolScreenPainterEditPart iscobolScreenPainterEditPart = PropertyDescriptorRegistry.getCurrentSelectedEditPart();
        if (iscobolScreenPainterEditPart != null) {
            GridModel gridModel = (GridModel)iscobolScreenPainterEditPart.getModel();
            AbstractGrid abstractGrid = (AbstractGrid)gridModel.getTarget();
            this.gridRowCount = abstractGrid.getNumRows();
            this.gridColumnCount = abstractGrid.getNumColumns();
        }
    }

    protected SettingItem addItem(TreeItem treeItem, boolean bl, boolean bl2) {
        GridCellSetting gridCellSetting = (GridCellSetting)super.addItem(treeItem, bl, bl2);
        if (!this.getNextAvailableCell(gridCellSetting, 1, this.gridRowCount, this.gridColumnCount)) {
            this.getNextAvailableCell(gridCellSetting, this.gridColumnCount + 1, this.gridRowCount, Integer.MAX_VALUE);
        }
        return gridCellSetting;
    }

    private boolean getNextAvailableCell(GridCellSetting gridCellSetting, int n, int n2, int n3) {
        if (n3 <= 0 || n2 <= 0) {
            return false;
        }
        GridCellSettingList gridCellSettingList = (GridCellSettingList)this.valueWorkingCopy;
        for (int i = n; i <= n3; ++i) {
            for (int j = 1; j <= n2; ++j) {
                boolean bl = true;
                for (int k = 0; k < gridCellSettingList.getSettingCount() && bl; ++k) {
                    GridCellSetting gridCellSetting2 = (GridCellSetting)gridCellSettingList.getSettingAt(k);
                    if (gridCellSetting2 == gridCellSetting) continue;
                    bl &= gridCellSetting2.getX() != i || gridCellSetting2.getY() != j;
                }
                if (!bl) continue;
                gridCellSetting.setX(i);
                gridCellSetting.setY(j);
                if (this.currentItem != null) {
                    this.currentItem.setText(gridCellSetting.toString());
                }
                return true;
            }
        }
        return false;
    }

    protected PropertySheetTable createPropertySheetTable(SashForm sashForm) {
        MyPropertySheetTable myPropertySheetTable = new MyPropertySheetTable(this, (Composite)sashForm, 0, (PropertySheetContainer)this, this.screenProgram, this.screenProgram.getProject(), this.propertyColumnWidth, this.valueColumnWidth);
        return myPropertySheetTable;
    }
}

