/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet;

import com.iscobol.plugins.editor.util.ProjectClassLoader;
import com.iscobol.screenpainter.beans.types.Repository;
import com.iscobol.screenpainter.util.PluginUtilities;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ICellEditorValidator;

public class CobolClassValidator
implements ICellEditorValidator {
    private Repository rep;
    private ProjectClassLoader loader;

    public CobolClassValidator(Repository repository, ProjectClassLoader projectClassLoader) {
        this.rep = repository;
        this.loader = projectClassLoader;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String isValid(Object object) {
        String string = object.toString();
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.length() == 2 ? "" : string.substring(1, string.length() - 1);
            String string2 = string;
            while (string2.endsWith("[]")) {
                string2 = string2.substring(0, string2.length() - 2);
            }
            try {
                PluginUtilities.checkClassName((String)string2, (ClassLoader)this.loader);
                return null;
            }
            catch (Throwable throwable) {
                if (this.isPrimitive(string2)) return null;
                return throwable.toString();
            }
        } else {
            IProject iProject;
            IProject iProject2 = iProject = this.loader != null ? this.loader.getProject() : null;
            if (this.rep == null || this.rep.containsCobolClass(string, iProject)) return null;
            return "Cobol Class Name not found: '" + string + "'";
        }
    }

    private boolean isPrimitive(String string) {
        return string.equals("byte") || string.equals("short") || string.equals("int") || string.equals("long") || string.equals("float") || string.equals("double") || string.equals("char") || string.equals("boolean");
    }
}

