/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet;

import com.iscobol.plugins.editor.util.SortedList;
import com.iscobol.screenpainter.propertysheet.DialogEditor;
import com.iscobol.screenpainter.propertysheet.ElementsProvider;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public abstract class ComboDialogEditor
extends DialogEditor
implements ElementsProvider {
    protected CCombo combo;
    private SortedList list;
    private boolean mouseDown;
    protected int style = 8;

    public ComboDialogEditor() {
        Object[] objectArray = this.getElements();
        SortedList sortedList = this.getList();
        for (int i = 0; i < objectArray.length; ++i) {
            sortedList.add((Comparable)objectArray[i]);
        }
    }

    public void setFocus() {
        this.combo.setFocus();
    }

    protected final SortedList getList() {
        if (this.list == null) {
            this.list = this.createList();
        }
        return this.list;
    }

    protected SortedList createList() {
        return new SortedList();
    }

    protected void commitValue() {
        if (this.vListener != null) {
            this.vListener.valueChanged(this.getValue());
        }
    }

    void intHandleEvent(Event event) {
        block0 : switch (event.type) {
            case 16: {
                event.display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 4: {
                        this.commitValue();
                        this.dispose();
                        event.doit = false;
                        break block0;
                    }
                    case 2: {
                        if (this.vListener != null) {
                            this.vListener.valueChanged(this.getValue());
                        }
                        this.dispose();
                        event.doit = false;
                    }
                }
            }
        }
    }

    void addListener(int n, Listener listener) {
        super.addListener(n, listener);
        this.contents.addListener(n, listener);
    }

    protected void clearSelection() {
        this.combo.select(0);
        this.setValue(null);
    }

    protected Control createContents(Composite composite) {
        this.combo = new CCombo(composite, this.style);
        this.combo.setEditable(false);
        this.combo.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        this.combo.addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        this.combo.addMouseListener((MouseListener)new /* Unavailable Anonymous Inner Class!! */);
        this.fillCombo();
        this.contents = this.combo;
        return this.contents;
    }

    protected void fillCombo() {
        this.combo.add("");
        for (int i = 0; i < this.list.size(); ++i) {
            this.combo.add(this.elementToString(this.list.get(i)));
        }
    }

    protected void updateContents(Object object) {
        Comparable comparable = (Comparable)object;
        this.combo.setText("");
        if (comparable == null) {
            this.combo.select(0);
        } else {
            int n = this.list.indexOf(comparable);
            if (n >= 0) {
                this.combo.setItem(n + 1, this.elementToString((Object)comparable));
                this.combo.select(n + 1);
                this.list.setElementAt(n, comparable);
            } else {
                n = this.list.add(comparable);
                this.combo.add(this.elementToString((Object)comparable), n + 1);
                this.combo.select(n + 1);
            }
        }
    }

    protected String elementToString(Object object) {
        return this.valueToString(object);
    }

    static /* synthetic */ SortedList access$000(ComboDialogEditor comboDialogEditor) {
        return comboDialogEditor.list;
    }

    static /* synthetic */ boolean access$100(ComboDialogEditor comboDialogEditor) {
        return comboDialogEditor.mouseDown;
    }

    static /* synthetic */ boolean access$102(ComboDialogEditor comboDialogEditor, boolean bl) {
        comboDialogEditor.mouseDown = bl;
        return comboDialogEditor.mouseDown;
    }
}

