/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet;

import com.iscobol.screenpainter.propertysheet.CellEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class DialogEditor
extends CellEditor {
    Button button;
    Control contents;
    private Composite composite;
    protected Object value;

    void addListener(int n, Listener listener) {
        this.button.addListener(n, listener);
        this.button.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected abstract Object openDialog(Shell var1);

    protected Control createContents(Composite composite) {
        this.contents = new Label(composite, 2048);
        return this.contents;
    }

    public void intCreateEditor(Composite composite) {
        this.composite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginBottom = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginLeft = 0;
        gridLayout.marginRight = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.numColumns = 2;
        this.composite.setLayout((Layout)gridLayout);
        Control control = this.createContents(this.composite);
        GridData gridData = new GridData(768);
        control.setLayoutData((Object)gridData);
        this.button = new Button(this.composite, 8);
        gridData = new GridData();
        gridData.widthHint = 27;
        gridData.heightHint = 15;
        this.button.setLayoutData((Object)gridData);
        this.button.setText("...");
    }

    void intHandleEvent(Event event) {
        switch (event.type) {
            case 16: {
                Control control = event.display.getFocusControl();
                if (control != this.button && this.vListener != null) {
                    this.vListener.valueChanged(this.getValue());
                }
                this.dispose();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: {
                        if (this.vListener != null) {
                            this.vListener.valueChanged(this.getValue());
                        }
                        this.dispose();
                        event.doit = false;
                    }
                }
            }
        }
    }

    public void dispose() {
        this.composite.dispose();
    }

    public Control getEditor() {
        return this.composite;
    }

    public void selectAll() {
    }

    public void setFocus() {
        this.button.setFocus();
    }

    public void doSetValue(Object object) {
        this.value = object;
        this.updateContents(object);
    }

    protected void updateContents(Object object) {
        ((Label)this.contents).setText(this.valueToString(object));
    }

    public Object getValue() {
        return this.value;
    }

    public String valueToString(Object object) {
        if (object != null) {
            return object.toString();
        }
        return "";
    }
}

