/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.screenpainter.propertysheet;

import com.iscobol.screenpainter.ISPBundle;
import com.iscobol.screenpainter.beans.types.MenuItemSetting;
import com.iscobol.screenpainter.beans.types.MenuItemSettingList;
import com.iscobol.screenpainter.beans.types.SettingItem;
import com.iscobol.screenpainter.beans.types.SettingItemList;
import com.iscobol.screenpainter.beans.types.SettingTreeItem;
import com.iscobol.screenpainter.dialogs.SettingsDialog;
import com.iscobol.screenpainter.model.WindowModel;
import com.iscobol.screenpainter.propertysheet.MenuSettingsContentPane;
import com.iscobol.screenpainter.propertysheet.PropertyDescriptorRegistry;
import com.iscobol.screenpainter.propertysheet.PropertySheetTable;
import com.iscobol.screenpainter.propertysheet.SettingsContentPane;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TreeItem;

public class MenuSettingsContentPane
extends SettingsContentPane {
    private TreeMap<Integer, Integer> currentExceptionValues = new TreeMap();

    public MenuSettingsContentPane(Composite composite, SettingsDialog settingsDialog, MenuItemSettingList menuItemSettingList, int n, int n2) {
        super(composite, settingsDialog, (SettingItemList)menuItemSettingList, 600, n, n2);
        WindowModel windowModel = PropertyDescriptorRegistry.getCurrentWindowModel();
        if (windowModel != null) {
            Set set = windowModel.getControlExceptionValues();
            for (Integer n3 : set) {
                this.registerExceptionValue(n3.intValue());
            }
        }
    }

    protected PropertySheetTable createPropertySheetTable(SashForm sashForm) {
        1 var2_2 = new /* Unavailable Anonymous Inner Class!! */;
        return var2_2;
    }

    protected SettingItem addSubitem(TreeItem treeItem, SettingTreeItem settingTreeItem) {
        int n = 0;
        SettingTreeItem settingTreeItem2 = settingTreeItem;
        while (settingTreeItem2 != null) {
            settingTreeItem2 = settingTreeItem2.getParent();
            ++n;
        }
        if (n > 4) {
            settingTreeItem2 = new MessageBox(this.getShell(), 33);
            settingTreeItem2.setText(this.getShell().getText());
            settingTreeItem2.setMessage(ISPBundle.getString((String)"exc_menu_level_msg"));
            settingTreeItem2.open();
            return null;
        }
        settingTreeItem2 = (MenuItemSetting)super.addSubitem(treeItem, settingTreeItem);
        int n2 = this.getDefaultExceptionValue();
        settingTreeItem2.setExceptionValue(n2);
        this.registerExceptionValue(n2);
        return settingTreeItem2;
    }

    protected SettingItem addItem(TreeItem treeItem, boolean bl, boolean bl2) {
        MenuItemSetting menuItemSetting = (MenuItemSetting)super.addItem(treeItem, bl, bl2);
        int n = this.getDefaultExceptionValue();
        menuItemSetting.setExceptionValue(n);
        this.registerExceptionValue(n);
        return menuItemSetting;
    }

    public void removeItem(TreeItem treeItem) {
        MenuItemSetting menuItemSetting = (MenuItemSetting)treeItem.getData();
        super.removeItem(treeItem);
        Vector vector = menuItemSetting.getControlExceptionValues();
        for (int i = 0; i < vector.size(); ++i) {
            this.unregisterExceptionValue((Integer)vector.elementAt(i));
        }
    }

    private int getDefaultExceptionValue() {
        int n = 1000;
        while (this.exceptionValueAlreadyExists(n)) {
            ++n;
        }
        return n;
    }

    private void registerExceptionValue(int n) {
        Integer n2 = new Integer(n);
        Integer n3 = (Integer)this.currentExceptionValues.get(n2);
        int n4 = n3 != null ? n3 + 1 : 1;
        this.currentExceptionValues.put(n2, new Integer(n4));
    }

    private void unregisterExceptionValue(Integer n) {
        Integer n2 = (Integer)this.currentExceptionValues.get(n);
        if (n2 != null) {
            if (n2 > 1) {
                this.currentExceptionValues.put(n, new Integer(n2 - 1));
            } else {
                this.currentExceptionValues.remove(n);
            }
        }
    }

    private boolean exceptionValueAlreadyExists(int n) {
        return this.currentExceptionValues.containsKey(new Integer(n));
    }
}

